<?php
/**
 * Exit if accessed directly
 */
if (!defined('ABSPATH')) {
    exit;
}

use WPSURL\App\Statistics;

do_action('wpsurl_bulk_actions');

$links_count = \WPSURL\App\Links::count();
$per_page = 15;
$show = false;
$types = \WPSURL\App\Links::getTypes();
?>
<div class="wrap wpsurl-admin-wrap">
    <?php if($links_count > 0): ?>
    <h1 class="wp-heading-inline"><?php _e('Safe Links', WPSURL_TEXT_DOMAIN) ?></h1>
    <a href="#" class="page-title-action wpsurl-add-new-link"><?php _e('Add New Link', WPSURL_TEXT_DOMAIN) ?></a>
    <div id="wpsurl-insert-loader" style="display:none;float: left;margin: 21px 0 0 0;"><?php \WPSURL\App\Utility::showLoader('#000000') ?></div>
    <?php endif; ?>
    <hr class="wp-header-end">
    <form id="posts-filter" method="get">
        <div class="wpsurl-admin-page">
            <?php
            if ($links_count > 0):
                ?>
                <div class="wpsurl-links-filter-wrap">
                    <div class="tablenav top">
                        <div class="alignleft actions bulkactions">
                            <div class="wpsurl-link-checkbox" style="float:<?php echo is_rtl() ? 'right' : 'left' ?>;margin:3px 11px 0">
                                <input type="checkbox" name="link_checked_all[]" id="link-checked-all">
                                <label for="link-checked-all"><i class="wpsurl-icon-check"></i></label>
                            </div>
                            <label for="bulk-action-selector-top" class="screen-reader-text"><?php _e('Select collective work', WPSURL_TEXT_DOMAIN) ?></label>
                            <select name="action" id="bulk-action-selector-top">
                                <option value="-1"><?php _e('Collective work', WPSURL_TEXT_DOMAIN) ?></option>
                                <option value="1"><?php _e('Active', WPSURL_TEXT_DOMAIN) ?></option>
                                <option value="2"><?php _e('Inactive', WPSURL_TEXT_DOMAIN) ?></option>
                                <option value="3"><?php _e('Delete', WPSURL_TEXT_DOMAIN) ?></option>
                                <?php do_action('wpsurl_links_bulk_action_options'); ?>
                            </select>
                            <input type="submit" id="doaction" class="button action" value="<?php _e('Run', WPSURL_TEXT_DOMAIN) ?>">
                            <a href="#" data-hystmodal="#replacement-modal" class="button"><?php _e('Replacement', WPSURL_TEXT_DOMAIN) ?></a>
                            <input type="hidden" name="page" value="<?php echo esc_attr($_GET['page']) ?>">
                        </div>
                        <div class="wpsurl-search-result" style="width: 100%;display: none">
                            <div class="wpsurl-links-list">
                                <div class="wpsurl-res" style="width: 100%;padding: 10px; background-color: #9ea3a8; border-radius: 5px; margin: 10px 0; "></div>
                            </div>
                        </div>
                        <br class="clear">
                    </div>
                    <div class="search-box">
                        <div class="tablenav-pages one-page">
                            <div class="wpsurl-links-counter">
                                <span class="count"><?php echo \WPSURL\App\Number::numByLang($links_count); ?></span>
                                <?php _e('Item', WPSURL_TEXT_DOMAIN) ?>
                            </div>
                        </div>
                        <input type="text" name="search_param" id="search_param" placeholder="<?php _e('Search...', WPSURL_TEXT_DOMAIN) ?>">
                        <select name="search_filter" id="search_filter">
                            <option value="0"><?php _e('Select...', WPSURL_TEXT_DOMAIN) ?></option>
                            <option value="title"><?php _e('Title', WPSURL_TEXT_DOMAIN) ?></option>
                            <option value="unique_id"><?php _e('ID', WPSURL_TEXT_DOMAIN) ?></option>
                            <option value="key"><?php _e('Key', WPSURL_TEXT_DOMAIN) ?></option>
                        </select>
                        <button class="button button-primary"><?php _e('Filter', WPSURL_TEXT_DOMAIN) ?></button>
                    </div>
                </div>
            <?php endif; ?>
            <div class="wpsurl-links-list wpsurl-links-list-container">
                <?php
                $search_field = (isset($_GET['search_filter'])) ? sanitize_text_field($_GET['search_filter']) : '';
                $search_param = (isset($_GET['search_param'])) ? sanitize_text_field($_GET['search_param']) : '';
                $offset = (\WPSURL\App\Utility::getCurrentPageNum() * $per_page) - $per_page;
                $args = [
                    'per_page' => $per_page,
                    'offset' => $offset,
                    'order_by' => 'created_at',
                    'order' => 'DESC',
                ];
                if(!empty($search_field)){
                    $args['fields'] = [
                        [
                            'key' => $search_field,
                            'value' => $search_param,
                            'compare' => 'LIKE'
                        ],
                    ];
                }
                $links = \WPSURL\App\Links::getResults($args);

                if ($links):
                    foreach ($links as $link):
                        $link_views = Statistics::getViews($link->unique_id);
                        $link_clicks = Statistics::getClicks($link->unique_id);
                        $is_preview = \WPSURL\App\LinkOptions::isIframePreview($link->unique_id);
                        $has_schedule = \WPSURL\App\LinkOptions::hasSchedule($link->unique_id);
                        $is_expired = \WPSURL\App\LinkOptions::isExpired($link->unique_id);
                        $is_start = \WPSURL\App\LinkOptions::isStartSchedule($link->unique_id);
                        $end_time = \WPSURL\App\LinkOptions::getScheduleEnd($link->unique_id);
                        $expired_days = !empty($end_time) ? \WPSURL\App\LinkOptions::getRemainingDays($link->unique_id) : 0;
                        $created_left_days = \WPSURL\App\Utility::convertToLeftDays(strtotime($link->created_at));
                        ?>
                        <div class="link-item link-item-<?php echo esc_attr($link->unique_id); ?> link-item-<?php echo esc_attr($link->key); ?> wpsurl-clearfix">
                            <div class="wpsurl-link-item-loader" style="display: none"><?php \WPSURL\App\Utility::showLoader('#9ea3a8'); ?></div>
                            <div class="wpsurl-float-<?php echo is_rtl() ? 'right' : 'left' ?>">
                                <div class="wpsurl-link-checkbox link-affected-chckbox">
                                    <input type="checkbox" name="link_check[]" value="<?php echo esc_attr($link->unique_id); ?>" id="link-check-<?php echo esc_attr($link->unique_id); ?>">
                                    <label for="link-check-<?php echo esc_attr($link->unique_id); ?>"><i class="wpsurl-icon-check"></i></label>
                                </div>
                                <a href="#" title="<?php _e('Active/Inactive', WPSURL_TEXT_DOMAIN); ?>" class="wpsurl-button link-status link-status-option-color <?php echo $link->status == 'active' ? 'active' : 'inactive'; ?>" data-wpsurl-unique-id="<?php echo esc_attr($link->unique_id); ?>" data-wpsurl-link-key="<?php echo esc_attr($link->key); ?>"><i class="wpsurl-icon-link"></i></a>
                                <span class="unique-id"><?php echo \WPSURL\App\Number::numByLang($link->unique_id); ?></span>
                                <div class="link-title" title="<?php echo esc_attr($link->title); ?>"><?php echo $link->title; ?></div>
                                <div class="link-option-item">
                                    <div class="link-option-group" data-value="<?php echo \WPSURL\App\Utility::getHashLink($link->unique_id); ?>/">
                                        <div class="link-option-title"><?php _e('Page Link', WPSURL_TEXT_DOMAIN) ?></div>
                                        <div class="link-option-btns">
                                            <div class="link-option-open link-option-btn"><i class="wpsurl-icon-external-link"></i></div>
                                            <div class="link-option-copy link-option-btn"><i class="wpsurl-icon-copy"></i></div>
                                        </div>
                                    </div>
                                </div>
                                <a href="#" title="<?php _e('More', WPSURL_TEXT_DOMAIN); ?>" class="wpsurl-button wpsurl-link-open-more" data-wpsurl-unique-id="<?php echo esc_attr($link->unique_id); ?>"><i class="wpsurl-icon-ellipsis-h"></i></a>
                                <?php if ($is_preview): ?>
                                    <span class="option-status"><?php echo __('Is Preview', WPSURL_TEXT_DOMAIN) ?></span>
                                <?php elseif(isset($types[$link->type])): ?>
                                    <span class="option-status"><?php echo $types[$link->type] ?></span>
                                <?php endif; ?>
                                <?php if ($has_schedule): ?>
                                    <?php if ($is_expired): ?>
                                        <span class="option-status option-status-error"><?php echo __('Expired', WPSURL_TEXT_DOMAIN) ?></span>
                                    <?php elseif($is_start && $expired_days): ?>
                                        <span class="option-status option-status-warning"><?php echo sprintf(__('Expire in %d days', WPSURL_TEXT_DOMAIN), $expired_days) ?></span>
                                    <?php elseif(!$is_start): ?>
                                        <span class="option-status option-status-warning"><?php echo __('Schedule is not started', WPSURL_TEXT_DOMAIN) ?></span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                            <div class="wpsurl-float-<?php echo is_rtl() ? 'left' : 'right' ?> wpsurl-link-action-btns" style="margin-top:7px;">
                                <span class="created-time"><?php echo $created_left_days > 0 ? sprintf(__('Created in %d days ago', WPSURL_TEXT_DOMAIN), $created_left_days) : __('Recently created', WPSURL_TEXT_DOMAIN) ?></span>
                                <a href="#" title="<?php _e('Edit'); ?>" class="wpsurl-button link-edit" data-wpsurl-unique-id="<?php echo esc_attr($link->unique_id); ?>" data-wpsurl-link-key="<?php echo esc_attr($link->key); ?>"><i class="wpsurl-icon-edit"></i></a>
                                <a href="#" title="<?php _e('Delete'); ?>" class="wpsurl-button link-delete" data-wpsurl-unique-id="<?php echo esc_attr($link->unique_id); ?>" data-wpsurl-link-key="<?php echo esc_attr($link->key); ?>"><i class="wpsurl-icon-trash"></i></a>
                                <a href="#" title="<?php _e('Lock', WPSURL_TEXT_DOMAIN); ?>" class="wpsurl-button link-lock link-status-option-color <?php echo !empty($link->password) || $link->password != null || $link->password != '' ? 'active' : 'inactive'; ?>" data-wpsurl-unique-id="<?php echo esc_attr($link->unique_id); ?>" data-wpsurl-link-key="<?php echo esc_attr($link->key); ?>" data-wpsurl-link-locked="<?php echo !empty($link->password) || $link->password != null || $link->password != '' ? 'true' : 'false'; ?>"><i class="wpsurl-icon-lock"></i></a>
                            </div>
                            <div class="link-push-options" style="display: none">
                                <div class="link-option-item">
                                    <div class="link-option-group" data-value="<?php echo esc_attr($link->link); ?>">
                                        <div class="link-option-title"><?php _e('Original Link', WPSURL_TEXT_DOMAIN) ?></div>
                                        <div class="link-option-btns">
                                            <div class="link-option-open link-option-btn"><i class="wpsurl-icon-external-link"></i></div>
                                            <div class="link-option-copy link-option-btn"><i class="wpsurl-icon-copy"></i></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="link-option-item">
                                    <div class="link-option-group" data-value="<?php echo \WPSURL\App\Utility::getHashLink($link->unique_id, 'surl'); ?>">
                                        <div class="link-option-title"><?php _e('Short Link', WPSURL_TEXT_DOMAIN) ?></div>
                                        <div class="link-option-btns">
                                            <div class="link-option-open link-option-btn"><i class="wpsurl-icon-external-link"></i></div>
                                            <div class="link-option-copy link-option-btn"><i class="wpsurl-icon-copy"></i></div>
                                        </div>
                                    </div>
                                </div>
                                <?php if (in_array($link->type, [2])): ?>
                                    <?php
                                    $slug = \WPSURL\App\Utility::getPagesSlug(2);
                                    $dl_link = \WPSURL\App\Utility::getDownloadLink($link->unique_id);
                                    
                                    ?>
                                    <div class="link-option-item">
                                        <div class="link-option-group" data-value="<?php echo esc_html__($dl_link); ?>">
                                            <div class="link-option-title"><?php _e('Download Link', WPSURL_TEXT_DOMAIN) ?></div>
                                            <div class="link-option-btns">
                                                <div class="link-option-open link-option-btn"><i class="wpsurl-icon-external-link"></i></div>
                                                <div class="link-option-copy link-option-btn"><i class="wpsurl-icon-copy"></i></div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="link-option-item">
                                    <div class="link-option-group" data-value="<?php echo esc_attr($link->key); ?>">
                                        <div class="link-option-title"><?php _e('Key', WPSURL_TEXT_DOMAIN) ?></div>
                                        <div class="link-option-btns">
                                            <div class="link-option-copy link-option-btn"><i class="wpsurl-icon-copy"></i></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="link-option-item">
                                    <div class="link-option-group" data-value='[wpsurl id="<?php echo esc_attr($link->unique_id); ?>" views="false" clicks="false"]'>
                                        <div class="link-option-title"><?php _e('Shortcode', WPSURL_TEXT_DOMAIN) ?></div>
                                        <div class="link-option-btns">
                                            <div class="link-option-copy link-option-btn"><i class="wpsurl-icon-copy"></i></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="link-option-item">
                                    <div class="link-option-group" data-value="&lt;?php echo do_shortcode(&#39;[wpsurl id=&#34;<?php echo esc_attr($link->unique_id); ?>&#34; views=&#34;false&#34; clicks=&#34;false&#34;]&#39;) ?&gt;">
                                        <div class="link-option-title"><?php _e('PHP Code', WPSURL_TEXT_DOMAIN) ?></div>
                                        <div class="link-option-btns">
                                            <div class="link-option-copy link-option-btn"><i class="wpsurl-icon-copy"></i></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="link-counter">
                                <div class="link-views-count">
                                    <i class="wpsurl-icon-eye" title="<?php _e('Views Count', WPSURL_TEXT_DOMAIN) ?>"></i>
                                    <span><?php echo \WPSURL\App\Number::numByLang($link_views) ?></span>
                                    <?php if ($link_views > 0): ?>
                                        <a href="#" data-wpsurl-clear-type="views" data-wpsurl-unique-id="<?php echo esc_attr($link->unique_id) ?>" data-wpsurl-link-key="<?php echo esc_attr($link->key) ?>" class="clear-link-data"><?php _e('Clear', WPSURL_TEXT_DOMAIN) ?></a>
                                    <?php endif; ?>
                                </div>
                                <div class="link-clicks-count">
                                    <i class="wpsurl-icon-mouse-pointer" title="<?php _e('Clicks Count', WPSURL_TEXT_DOMAIN) ?>"></i>
                                    <span><?php echo \WPSURL\App\Number::numByLang($link_clicks) ?></span>
                                    <?php if ($link_clicks > 0): ?>
                                        <a href="#" data-wpsurl-clear-type="clicks" data-wpsurl-unique-id="<?php echo esc_attr($link->unique_id) ?>" data-wpsurl-link-key="<?php echo esc_attr($link->key) ?>" class="clear-link-data"><?php _e('Clear', WPSURL_TEXT_DOMAIN) ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php
                    endforeach;
                else: ?>
                    <div class="wpsurl-add-one-link">
                        <p><img src="<?php echo WPSURL_IMG_URL . 'logo.png'; ?>" style="width:100px;filter:grayscale(1);pointer-events:none"></p>
                        <p><?php _e('Create the first secure link', WPSURL_TEXT_DOMAIN) ?></p>
                        <p>
                            <a href="javascript:void(0)" class="wpsurl-add-new-link wpsurl-first-link">
                                <i class="wpsurl-icon-plus"></i>
                                <?php _e('Add New Link', WPSURL_TEXT_DOMAIN) ?>
                            </a>
                        </p>
                    </div>
                <?php
                endif;
                ?>
            </div>
            <div id="wpsurl-pagenavi" style="width: 100%;text-align: center;margin: 15px 0">
                <?php \WPSURL\App\Utility::renderPagination($per_page, $links_count) ?>
            </div>
        </div>
    </form>
</div>
<div class="hystmodal" id="replacement-modal" aria-hidden="true">
    <div class="hystmodal__wrap">
        <div class="hystmodal__window hystmodal__window--form" role="dialog" aria-modal="true">
            <button data-hystclose class="hystmodal__close">Close</button>
            <div class="hystmodal__styled">
                <form action="/" method="post" id="wpsurl-replacement-form">
                    <div class="field">
                        <label class="label text-right"><?php echo __('Field', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="control">
                            <select name="replace_field" required>
                                <option value="0"><?php echo __('Select...', WPSURL_TEXT_DOMAIN) ?></option>
                                <option value="1"><?php echo __('Title', WPSURL_TEXT_DOMAIN) ?></option>
                                <option value="2"><?php echo __('Link', WPSURL_TEXT_DOMAIN) ?></option>
                                <optgroup label="<?php echo esc_attr__('Meta', WPSURL_TEXT_DOMAIN) ?>">
                                    <option value="3"><?php echo __('Text', WPSURL_TEXT_DOMAIN) ?></option>
                                </optgroup>
                            </select>
                        </div>
                    </div>
                    <div class="field">
                        <label class="label text-right"><?php echo __('Search for', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="control">
                            <input type="text" name="search_value" required>
                        </div>
                    </div>
                    <div class="field">
                        <label class="label text-right"><?php echo __('Replace it', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="control">
                            <input type="text" name="replace_value" required>
                        </div>
                    </div>
                    <div class="field">
                        <div class="control">
                            <button type="submit" class="button button-primary is-link"><?php echo __('Replace', WPSURL_TEXT_DOMAIN) ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php
include_once(WPSURL_VIEW_ADMIN_PATH . 'new-link.php');