<?php
$per_page = 15;
$offset   = ( \WPSURL\App\Utility::getCurrentPageNum() * $per_page ) - $per_page;
$order    = ( isset( $_GET['order-by'] ) && ! empty( $_GET['order-by'] ) ) ? sanitize_text_field($_GET['order-by']) : 'DESC';
$api_keys  = \WPSURL\App\ApiKeys::getResults([
    'per_page' => $per_page,
    'offset' => $offset,
    'order_by' => 'last_access',
    'order' => $order,
]);
?>
<div class="wrap wpsurl-admin-wrap">
    <h1 class="wp-heading-inline"><?php _e('REST Api', WPSURL_TEXT_DOMAIN) ?></h1>
    <a href="#" data-hystmodal="#add-key-modal" class="page-title-action"><?php _e('Add Key', WPSURL_TEXT_DOMAIN) ?></a>
    <hr class="wp-header-end">
    <div class="wrap-content">
        <?php if ($api_keys): ?>
            <table class="wpsurl-api-keys-table wp-list-table widefat fixed striped posts">
                <thead>
                    <tr>
                        <th scope="col" class="manage-column"><?php _e('ID', WPSURL_TEXT_DOMAIN) ?></th>
                        <th scope="col" class="manage-column"><?php _e('Title', WPSURL_TEXT_DOMAIN) ?></th>
                        <th scope="col" class="manage-column"><?php _e('Secret', WPSURL_TEXT_DOMAIN) ?></th>
                        <th scope="col" class="manage-column"><?php _e('Description', WPSURL_TEXT_DOMAIN) ?></th>
                        <th scope="col" class="manage-column"><?php _e('Permissions', WPSURL_TEXT_DOMAIN) ?></th>
                        <th scope="col" class="manage-column"><?php _e('Status', WPSURL_TEXT_DOMAIN) ?></th>
                        <th scope="col" class="manage-column"><?php _e('Last Access', WPSURL_TEXT_DOMAIN) ?></th>
                        <th scope="col" class="manage-column"></th>
                    </tr>
                </thead>
                <tbody id="the-list">
                <?php foreach ($api_keys as $item): ?>
                <tr>
                    <th>#<?php echo $item->id ?></th>
                    <th><?php echo $item->title ?></th>
                    <th>
                        <a href="#" class="button wpsurl-copy-to-clipboard" data-value="<?php echo esc_attr($item->secret) ?>">
                            <?php _e('Get Secret Key', WPSURL_TEXT_DOMAIN) ?>
                        </a>
                    </th>
                    <th><?php echo $item->description ?></th>
                    <th><?php echo $item->permissions ?></th>
                    <th><?php echo $item->status ?></th>
                    <th><?php echo ($item->last_access) ? \WPSURL\App\Utility::date('Y-m-d H:i:s', strtotime($item->last_access)) : __('Unknown', WPSURL_TEXT_DOMAIN) ?></th>
                    <th>
                        <a href="#" class="wpsurl-revoke-api-key-btn" data-id="<?php echo esc_attr($item->id) ?>" style="color:red">
                            <?php _e('Revoke', WPSURL_TEXT_DOMAIN) ?>
                        </a>
                    </th>
                </tr>
                <?php endforeach; ?>
                </tbody>
                <tfoot>
                <tr>
                    <th scope="col" class="manage-column"><?php _e('ID', WPSURL_TEXT_DOMAIN) ?></th>
                    <th scope="col" class="manage-column"><?php _e('Title', WPSURL_TEXT_DOMAIN) ?></th>
                    <th scope="col" class="manage-column"><?php _e('Secret', WPSURL_TEXT_DOMAIN) ?></th>
                    <th scope="col" class="manage-column"><?php _e('Description', WPSURL_TEXT_DOMAIN) ?></th>
                    <th scope="col" class="manage-column"><?php _e('Permissions', WPSURL_TEXT_DOMAIN) ?></th>
                    <th scope="col" class="manage-column"><?php _e('Status', WPSURL_TEXT_DOMAIN) ?></th>
                    <th scope="col" class="manage-column"><?php _e('Last Access', WPSURL_TEXT_DOMAIN) ?></th>
                    <th scope="col" class="manage-column"></th>
                </tr>
                </tfoot>
            </table>
        <?php else: ?>
            <div class="wpsurl-blankstate">
                <div class="blankstate-msg">
                    <i class="dashicons dashicons-rest-api"></i>
                    <h2><?php _e('The REST API allows external apps to view and manage links data.', WPSURL_TEXT_DOMAIN) ?> <br> <?php _e('Access is granted only to those with valid API keys.', WPSURL_TEXT_DOMAIN) ?></h2>
                    <a href="#" data-hystmodal="#add-key-modal"><?php _e('Create an Api Key', WPSURL_TEXT_DOMAIN) ?></a>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <div id="wpsurl-pagenavi" style="width: 100%;text-align: center;margin: 15px 0">
        <?php \WPSURL\App\Utility::renderPagination($per_page, \WPSURL\App\ApiKeys::count()) ?>
    </div>
</div>
<!----------------- Add key modal ----------------->
<div class="hystmodal" id="add-key-modal" aria-hidden="true">
    <div class="hystmodal__wrap">
        <div class="hystmodal__window hystmodal__window--form" role="dialog" aria-modal="true">
            <button data-hystclose class="hystmodal__close">Close</button>
            <div class="hystmodal__styled">
                <form action="/" method="post" id="wpsurl-add-api-key-form">
                    <div class="field">
                        <label class="label text-right"><?php echo __('Title', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="control">
                            <input type="text" name="title" required>
                        </div>
                    </div>
                    <div class="field">
                        <label class="label text-right"><?php echo __('Description', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="control">
                            <input type="text" name="description">
                        </div>
                    </div>
                    <div class="field">
                        <label class="label text-right"><?php echo __('Permissions', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="control">
                            <select name="permission" required>
                                <option value="read"><?php echo __('Read', WPSURL_TEXT_DOMAIN) ?></option>
                                <option value="write"><?php echo __('Write', WPSURL_TEXT_DOMAIN) ?></option>
                                <option value="read_write"><?php echo __('Read & Write', WPSURL_TEXT_DOMAIN) ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="field">
                        <div class="control">
                            <button type="submit" class="button button-primary is-link"><?php echo __('Add', WPSURL_TEXT_DOMAIN) ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>