<?php
use WPSURL\App\Settings;
$alert_status = Settings::getOption('alert_status');
?>
<fieldset class="wpsurl-fieldset">
    <div class="wpsurl-field wpsurl-field--radio wpsurl-fieldset-group">
        <div class="wpsurl-radio">
            <input type="checkbox" name="alert_status" value="1" class="checkbox-affected-toggle-elements" data-elements=".is-active-alertbox" id="alert_status"<?php echo $alert_status == true ? ' checked' : ''; ?>>
            <label for="alert_status"><?php _e( 'Alert Status', WPSURL_TEXT_DOMAIN ) ?></label>
        </div>
    </div>
</fieldset>
<fieldset class="wpsurl-fieldset is-active-alertbox wpsurl-fieldset-group" style="display:<?php echo $alert_status == true ? 'block' : 'none'; ?>">
    <div class="wpsurl-fieldset-group">
        <div class="wpsurl-field wpsurl-field--group">
            <label for="view_alert_text"><?php _e( 'Alert text', WPSURL_TEXT_DOMAIN ) ?></label>
            <textarea name="view_alert_text" id="view_alert_text" cols="70"><?php echo Settings::getOption( 'view_alert_text' ) ?></textarea>
        </div>
    </div>
</fieldset>
<fieldset class="wpsurl-fieldset is-active-alertbox" style="display:<?php echo $alert_status == true ? 'block' : 'none'; ?>">
    <div class="wpsurl-field--group wpsurl-fieldset-group">
        <div class="wpsurl-field wpsurl-fieldset--input-text">
            <label for="view_alert_type"><?php _e( 'Alert Color', WPSURL_TEXT_DOMAIN ) ?></label>
            <select name="view_alert_type" id="view_alert_type" class="wpsurl-js-select">
                <option <?php echo selected( 'success', Settings::getOption( 'view_alert_type' ) ) ?> value="success"><?php echo esc_html__( 'Green', WPSURL_TEXT_DOMAIN ) ?></option>
                <option <?php echo selected( 'error', Settings::getOption( 'view_alert_type' ) ) ?> value="error"><?php echo esc_html__( 'Red', WPSURL_TEXT_DOMAIN ) ?></option>
                <option <?php echo selected( 'warning', Settings::getOption( 'view_alert_type' ) ) ?> value="warning"><?php echo esc_html__( 'Yellow', WPSURL_TEXT_DOMAIN ) ?></option>
                <option <?php echo selected( 'info', Settings::getOption( 'view_alert_type' ) ) ?> value="info"><?php echo esc_html__( 'Blue', WPSURL_TEXT_DOMAIN ) ?></option>
            </select>
        </div>
    </div>
</fieldset>
