<?php
/**
 * Exit if accessed directly
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

use WPSURL\App\Settings;

global $alert;
do_action('wpsurl_save_settings');
do_action( 'wpsurl_import_data_action' );
\WPSURL\APP\Alert::showMessage();
$use_elementor = Settings::getOption('use_elementor');
$tabs = Settings::getTabs();
?>
<div class="wpsurl-wrap wrap wpsurl-settings-page">
    <h1 class="screen-reader-text"><?php _e( 'Sase Url Settings', WPSURL_TEXT_DOMAIN ) ?></h1>
    <div class="wpsurl-body">
        <header class="wpsurl-header">
            <div class="wpsurl-header-logo">
                <img src="<?php echo WPSURL_IMG_URL . 'logo-l.png'; ?>" alt="<?php echo esc_html__('Safe url', WPSURL_TEXT_DOMAIN) ?>">
            </div>
            <div class="wpsurl-header-nav">
                <?php $i = 0; foreach ($tabs as $key => $value): ?>
                    <a href="#<?php echo esc_attr($key) ?>" id="wpsurl-nav-dashboard" class="wpsurl-menu-item <?php echo $i == 0 ? ' is-active' : '' ?>">
                        <?php if(isset($value['title']) && !empty($value['title'])): ?>
                            <div class="wpsurl-menu-item-title"><?php echo $value['title']; ?></div>
                        <?php endif; ?>
                        <?php if(isset($value['description']) && !empty($value['description'])): ?>
                            <div class="wpsurl-menu-item-description"><?php echo $value['description']; ?></div>
                        <?php endif; ?>
                    </a>
                <?php
                $i++;
                endforeach; ?>
            </div>
            <div class="wpsurl-header-footer">
                <?php echo \WPSURL\App\Number::numByLang( sprintf( __( 'Version %s', WPSURL_TEXT_DOMAIN ), WPSURL_VERSION ) ) ?>
            </div>
        </header>
        <section class="wpsurl-content">
            <div class="wpsurl-dashboard">
                <div class="wpsurl-page-row">
                    <div class="wpsurl-page-col">
                        <div class="wpsurl-fields-container">
                            <form method="post" id="wpsurl-settings-form" action="" enctype="multipart/form-data" style="width: 100%">
                                <?php
                                $i = 0; foreach ($tabs as $key => $value):
                                    if(isset($value['show']) && $value['show'] === false)
                                        continue;
                                    ?>
                                <div id="<?php echo esc_attr($key) ?>" class="wpsurl-tab-content" style="display:<?php echo $i == 0 ? 'block' : 'none' ?>">
                                    <div class="wpsurl-section-header">
                                        <h2 class="wpsurl-title <?php echo isset($value['icon']) ? $value['icon'] : '' ?>">
                                            <?php echo $value['title'] ?>
                                        </h2>
                                    </div>
                                    <?php
                                    if(isset($value['callback'])){
                                        $callback = $value['callback'];
                                        if(!is_array($callback) && function_exists($callback)){
                                            call_user_func($callback);
                                        } elseif(is_array($callback)){
                                            $class = $callback[0];
                                            if(class_exists($class)){
                                                $method = $callback[1];
                                                if(method_exists($class, $method)){
                                                    $class::{$method}();
                                                }
                                            }
                                        }
                                    } elseif(isset($value['content_path'])){
                                        if(file_exists($value['content_path']) && is_readable($value['content_path'])){
                                            include_once $value['content_path'];
                                        }
                                    } else {
                                        $path = WPSURL_SETTINGS_PATH . $key . '-section.php';
                                        if(file_exists($path)){
                                            include_once $path;
                                        }
                                    }
                                    ?>
                                    <button type="submit" class="wpsurl-button save-settings-btn" name="wpsurl-save-setting-options">
                                        <?php _e( 'Save Changes', WPSURL_TEXT_DOMAIN ) ?>
                                    </button>
                                    <?php wp_nonce_field( 'save_settings', 'settings_nonce' ); ?>
                                </div>
                                <?php
                                $i++;
                                endforeach;
                                ?>
                            </form>
                            <?php
                            if(isset($tabs['backup'])){
                                include_once WPSURL_SETTINGS_PATH . 'backup.php';
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>