<?php
namespace WPSURL\App;

use WPSURL\App\User\User;
use WPSURL\App\User\UserData;

class Ajax {
    public static function viewRedirectButton() {
        $link_token = sanitize_text_field($_POST['link_token']);
        $link = Links::get($link_token);
        if ($link) {
            $pwd     = $link->password;
            $type    = (int) $link->type;
            $unique_id = $link->unique_id;
            if (empty($pwd)) {
                $download = null;
                $msg = __( 'Redirecting ...', WPSURL_TEXT_DOMAIN );
                if ($type === 2) {
                    $download = site_url( \WPSURL\App\Utility::getPagesSlug( 2 ) . '-download/' . $link_token );
                } elseif($type === 3){
                    $msg = __( 'Done.', WPSURL_TEXT_DOMAIN );
                }
                $result        = array(
                    'msg'       => $msg,
                    'type'      => 'success',
                    'link'      => $link->link,
                    'link_type' => (int) $type,
                    'download'  => $download,
                    'lock'      => false,
                    'is_text' => false
                );
                if ($type === 3){
                    $result['is_text'] = true;
                    $result['text'] = LinkOptions::getSimpleText($unique_id);
                }

                do_action('wpsurl_action_apply_statistics', $unique_id, 'click');
            } else {
                $result = array(
                    'msg'  => __( 'Link is locked, reload...', WPSURL_TEXT_DOMAIN ),
                    'type' => 'error',
                    'lock' => true
                );
            }
        } else {
            $result = array(
                'msg'  => __( 'Link Not Found', WPSURL_TEXT_DOMAIN ),
                'type' => 'error',
                'lock' => false
            );
        }
        wp_send_json( $result );
    }
    
    public static function openLinkByPassword() {
        $link_token = sanitize_text_field($_POST['link_token']);
        $pwd        = sanitize_text_field($_POST['password']);
        $link = Links::get($link_token);
        if ( $link && ! empty( $pwd ) && ! empty( $link_token ) ) {
            $link_pass = $link->password;
            $type      = (int) $link->type;
            $unique_id   = $link->unique_id;

            if ( \WPSURL\App\Options::isActiveWoo() ) {
                if (LinkOptions::isRestrictByWoo($unique_id)) {
                    if(!\WPSURL\App\Woocommerce::isUserCustomer()){
                        $result = array(
                            'msg'  => __( 'Sorry, this link is for customers', WPSURL_TEXT_DOMAIN ),
                            'type' => 'error',
                            'lock' => true
                        );
                        wp_send_json( $result );
                    }
                }
            }
            if ( \WPSURL\App\Options::isActiveWoo() ) {
                if(LinkOptions::isRestrictByEdd($unique_id)){
                    if(!Edd::isUserCustomerProducts()){
                        $result = array(
                            'msg'  => __( 'Sorry, this link is for customers', WPSURL_TEXT_DOMAIN ),
                            'type' => 'error',
                            'lock' => true
                        );
                        wp_send_json( $result );
                    }
                }
            }

            if ( \WPSURL\App\Utility::isEqualPassword( md5( $pwd ), $link_pass ) ) {
                $download = null;
                $msg = __( 'Done, wait...', WPSURL_TEXT_DOMAIN );
                if ($type === 2) {
                    $download = site_url( \WPSURL\App\Utility::getPagesSlug( 2 ) . '-download/' . $link_token . '/?ac=' . base64_encode( md5( $pwd ) ) );
                } elseif($type === 3){
                    $msg = __( 'Done.', WPSURL_TEXT_DOMAIN );
                }
                $result        = array(
                    'msg'       => $msg,
                    'type'      => 'success',
                    'link'      => $link->link,
                    'link_type' => (int) $type,
                    'download'  => $download
                );
                if ($type === 3){
                    $result['is_text'] = true;
                    $result['text'] = LinkOptions::getSimpleText($unique_id);
                }
                do_action('wpsurl_action_apply_statistics', $unique_id, 'click');
                wp_send_json($result);
            } else {
                wp_send_json(array(
                    'msg'  => __( 'Invalid values entered', WPSURL_TEXT_DOMAIN ),
                    'type' => 'error'
                ));
            }

        } else {
            $result = array(
                'msg'  => __( 'Please enter the value', WPSURL_TEXT_DOMAIN ),
                'type' => 'error'
            );
        }
        wp_send_json($result);
    }
    
    public static function reportLinkProblem() {
        $link_data = Links::get( sanitize_text_field($_POST['link_token']) );
        if ( $link_data ) {
            $mailer = new Mailer();
            $unique_id = $link_data->unique_id;
            $content       = '<div class="link-title">' . $link_data->title . '</div><br>';
            $link          = \WPSURL\App\Utility::getHashLink( $unique_id, 'surl' );
            $content       .= '<div class="link"><a href="' . $link . '">' . $link . '</a></div><br>';
            $report_text   = str_replace( PHP_EOL, '<br>', $_POST['description'] );
            $content       .= '<div class="report-des">' . $_POST['email'] . '</div><br>';
            $content       .= '<div class="report-des">' . $report_text . '</div><br>';
            $email_title   = sprintf( __( 'Link report problem %s', WPSURL_TEXT_DOMAIN ), $unique_id );
            $mailer->setToAdmin()->setEmailTemplate($email_title, $content);
            $insert = Reports::insert($unique_id, [
                'user_id' => UserData::getCurrentUserID(),
                'fullname' => $_POST['fullname'] ?? '',
                'email' => $_POST['email'],
                'content' => $_POST['description'],
            ]);
            if ($insert) {
                $result = array(
                    'type' => 'success',
                    'msg'  => __( 'Thank you for your cooperation, the link report will be registered and will be resolved as soon as possible', WPSURL_TEXT_DOMAIN )
                );
                $send = $mailer->send();
            } else {
                $result = array(
                    'type' => 'error',
                    'msg'  => __( 'An error occurred, please try again', WPSURL_TEXT_DOMAIN )
                );
            }
        } else {
            $result = array(
                'type' => 'error',
                'msg'  => __( 'Link Not Found', WPSURL_TEXT_DOMAIN )
            );
        }
        wp_send_json( $result );
    }
}