<?php
namespace WPSURL\App;

class ApiKeys {
    private static $wpdb;

    private static $table;

    protected static $cols = 'id,title,secret,description,permissions,status,created_at,modified_at,last_access';

    use \WPSURL\App\Traits\Database\Connection;

    public static function getResults($params){
        $params['cols'] = self::$cols;
        return self::getDb()->api_keys()->getResults($params);
    }

    public static function insert($params)
    {
        return self::getDb()->api_keys()->insert([
            'title' => $params['title'],
            'secret' => $params['secret'],
            'description' => $params['description'],
            'permissions' => $params['permissions'],
            'status' => isset($params['status']) ? $params['status'] : 'active',
        ]);
    }

    public static function update($id, $fields)
    {
        if(self::get($id)){
            return self::getDb()->api_keys()->update($fields, ['id' => $id]);
        }
        return false;
    }

    public static function get($id){
        return self::getDb()->api_keys()->get(['id' => $id]);
    }

    public static function getBySecret($secret){
        return self::getDb()->api_keys()->get(['secret' => $secret]);
    }

    public static function revoke($id)
    {
        return self::getDb()->api_keys()->delete(['id' => $id]);
    }

    public static function count(){
        return self::getDb()->api_keys()->count();
    }
}