<?php
namespace WPSURL\App;
/**
 * Exit if accessed directly
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use WPSURL\App\DatabaseModel as DB;

class Database {
	protected static $db;
	public static $table_links;
    public static $table_options;
    public static $table_statistics;
    public static $table_reports;
    public static $table_api_keys;
    public static $charset_collate;

    private static $instance = null;

    public static function Instance(){
        if(self::$instance === null){
            self::$instance = new self();
        }

        return self::$instance;
    }
	public function __construct(){
		global $wpdb;
		$prefix = $wpdb->prefix . WPSURL_PREFIX;
        self::$db = $wpdb;
        self::$table_links = $prefix . 'links';
        self::$table_options = $prefix . 'links_options';
        self::$table_statistics = $prefix . 'links_statistics';
        self::$table_reports = $prefix . 'links_reports';
        self::$table_api_keys = $prefix . 'api_keys';
        self::$charset_collate = self::$db->get_charset_collate();
	}

	public function links(){
		return new DB(self::$table_links);
	}

	public function options(){
		return new DB(self::$table_options);
	}

	public function statistics(){
		return new DB(self::$table_statistics);
	}

	public function reports(){
		return new DB(self::$table_reports);
	}

    public function api_keys(){
        return new DB(self::$table_api_keys);
    }

	public function create_table($table_name, $cols){
		if(!function_exists('dbDelta')){
			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		}
        $collate = self::$charset_collate;
		$sql = "CREATE TABLE IF NOT EXISTS $table_name ($cols) {$collate};";
		dbDelta($sql);
	}

	public function create_tables(){
		$this->create_table(self::$table_links, "
			id INT(11) unsigned NOT NULL AUTO_INCREMENT,
			unique_id INT(11) NOT NULL,
			title VARCHAR(255) NOT NULL,
			link LONGTEXT NOT NULL,
			`key` TEXT NOT NULL,
			`password` VARCHAR(255) NULL,
			created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
			modified_at DATETIME DEFAULT CURRENT_TIMESTAMP,
			`type` VARCHAR(30) NOT NULL DEFAULT '1',
			status VARCHAR(30) NOT NULL DEFAULT 'active',
			PRIMARY KEY (id)
		");

		$this->create_table(self::$table_options, '
			id INT(11) unsigned NOT NULL AUTO_INCREMENT,
			object_id INT(11) NOT NULL,
			link_option VARCHAR(255) NOT NULL,
			link_option_value LONGTEXT NOT NULL,
			PRIMARY KEY (id)
		');

		$this->create_table(self::$table_statistics, '
			id INT(11) unsigned NOT NULL AUTO_INCREMENT,
			object_id INT(11) NOT NULL,
			ip VARCHAR(255) NOT NULL,
			visit VARCHAR(255) NULL,
			click VARCHAR(255) NULL,
			first_visit DATETIME DEFAULT CURRENT_TIMESTAMP,
			last_visit DATETIME DEFAULT CURRENT_TIMESTAMP,
			status INT(2) NOT NULL DEFAULT 1,
			PRIMARY KEY (id)
		');

		$this->create_table(self::$table_reports, '
			id INT(11) unsigned NOT NULL AUTO_INCREMENT,
			object_id INT(11) NOT NULL,
			user_id INT(11) NULL,
			fullname VARCHAR(255) NULL,
			email VARCHAR(255) NULL,
			`content` LONGTEXT,
			created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
			status INT(2) NOT NULL DEFAULT 1,
			PRIMARY KEY (id)
		');

        $this->create_table(self::$table_api_keys, '
			id INT(11) unsigned NOT NULL AUTO_INCREMENT,
			title VARCHAR(255) NOT NULL,
			secret TEXT NOT NULL,
			description VARCHAR(200),
			permissions VARCHAR(40),
			status VARCHAR(30) NOT NULL DEFAULT "active",
			created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
			modified_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
			last_access DATETIME,
			PRIMARY KEY (id)
		');
	}
}