<?php
namespace WPSURL\App;

class Edd {
    public static function getUserOrders($user_id = 0)
    {
        $orders = [];
        $customer_orders = edd_get_orders(
            array(
                'customer_id'    => $user_id,
                'number'         => -1,
                'type'           => 'sale',
                'status'         => 'complete'
            )
        );

        if($customer_orders){
            foreach ($customer_orders as $order) {
                foreach ($order->get_items_with_bundles() as $key => $item){
                    $orders[$order->id] = $item->product_id;
                }
            }
        }

        return $orders;
    }

    public static function hasBoughtItems($downloads_id = array(), $user_id = 0)
    {
        $bought = 0;
        $orders = self::getUserOrders($user_id);
        if (is_array($downloads_id) && sizeof($downloads_id) > 0 && is_array($orders) && sizeof($orders) > 0) {
            foreach ($downloads_id as $download_id) {
                if (in_array($download_id, array_values($orders))) {
                    $bought++;
                }
            }
        }
        return $bought === count($downloads_id);
    }

    public static function isUserCustomerProducts($downloads_id = array(), $user_id = 0)
    {
        if (is_array($downloads_id)) {
            if (Options::isActiveEdd()) {
                if (is_user_logged_in()) {
                    if (!$user_id) {
                        $user_id = get_current_user_id();
                    }
                    if (self::hasBoughtItems($downloads_id, $user_id)) {
                        return true;
                    }
                }
            } else {
                return true;
            }
        }

        return false;
    }
}