<?php
namespace WPSURL\App;

class Importer {
    private static $cache_key = 'surl_demo_cache';

    private static $result = [];

    private static function importLinks($links)
    {
        $i = 0;
        if($links){
            foreach ($links as $link){
                $link_key = Links::get($link['key']) ? Utility::generateUniqueLinkKey() : $link['key'];
                $unique_id = Links::get($link['unique_id']) ? Utility::generateUniqueLinkID() : $link['unique_id'];
                self::set_cache_option($link['unique_id'], 'new_id', $unique_id);
                $insert = Links::insert([
                    'unique_id' => $unique_id,
                    'title' => urldecode($link['title']),
                    'link' => $link['link'],
                    'key' => $link_key,
                    'type' => $link['type'],
                    'status' => $link['status'],
                ]);
                if($insert){
                    $i++;
                }
            }
        }
        self::setResult(['imported', 'links'], $i);
    }

    private static function importOptions($options)
    {
        $i = 0;
        if($options){
            foreach ($options as $option){
                $unique_id = self::get_cache_option($option['object_id'], 'new_id');
                if(!Links::get($unique_id))
                    continue;
                $insert = LinkOptions::addOption($unique_id, $option['link_option'], $option['link_option_value']);
                $i++;
            }
        }
        self::setResult(['imported', 'options'], $i);
    }

    private static function importStatistics($items)
    {
        $i = 0;
        if($items){
            foreach ($items as $item){
                $unique_id = self::get_cache_option($item['object_id'], 'new_id');
                $link_data = Links::get($unique_id);

                if(!$link_data)
                    continue;

                $insert = Statistics::insert([
                    'unique_id'=> $link_data->unique_id,
                    'ip' => $item['ip'],
                    'visit' => $item['visit'],
                    'click' => $item['click'],
                ]);
                $i++;
            }
        }
        self::setResult(['imported', 'statistics'], $i);
    }

    private static function importReports($items)
    {
        $i = 0;
        if($items){
            foreach ($items as $item){
                $unique_id = self::get_cache_option($item['object_id'], 'new_id');

                if(!Links::get($unique_id))
                    continue;

                $insert = Reports::insert($unique_id, [
                    'user_id' => $item['user_id'],
                    'fullname' => $item['fullname'],
                    'email' => $item['email'],
                    'content' => $item['content'],
                    'status' => $item['status'],
                ]);
                $i++;
            }
        }
        self::setResult(['imported', 'reports'], $i);
    }

    public static function importData($data)
    {
        if(isset($data['links'])){
            self::importLinks($data['links']);
        }
        if(isset($data['options'])){
            self::importOptions($data['options']);
        }
        if(isset($data['statistics'])){
            self::importStatistics($data['statistics']);
        }
        if(isset($data['reports'])){
            self::importReports($data['reports']);
        }

        $reset_cache = Options::deleteOption(self::$cache_key);

        return self::getImportedCount();
    }

    private static function set_cache_option($item_id, $item_key, $item_value, $type = 'option'){
        $options = Options::getOption(self::$cache_key);
        if (!is_array($options) || empty($options)){
            $options = [];
        }
        $options[$type][$item_id][$item_key] = $item_value;
        Options::updateOption(self::$cache_key, $options);
    }

    private static function get_cache_option($item_id, $item_key, $type = 'option'){
        $options = Options::getOption(self::$cache_key);
        return is_array($options) && isset($options[$type][$item_id]) && isset($options[$type][$item_id][$item_key]) ? $options[$type][$item_id][$item_key] : false;
    }

    private static function setResult($key, $value){
        if(is_array($key) && count($key) == 2){
            self::$result[$key[0]][$key[1]] = $value;
        } else {
            self::$result[$key] = $value;
        }
    }

    private static function getResult(){
        return self::$result;
    }

    private static function getImportedCount(){
        $result = self::getResult();
        $count = 0;
        if($result){
            foreach ($result['imported'] as $key => $value){
                if(intval($value) && $value > 0){
                    $count += $value;
                }
            }
        }
        return $count;
    }
}