<?php
namespace WPSURL\App;
class LinkOptions {
    use \WPSURL\App\Traits\Singleton;

    use \WPSURL\App\Traits\Database\Connection;
    public static function addOption($unique_id, $option, $value){
        return self::getDb()->options()->insert([
            'object_id' => $unique_id,
            'link_option' => $option,
            'link_option_value' => $value
        ]);
    }

    public static function updateOption($unique_id, $option, $value){
        if(self::isExistsOption($unique_id, $option)){
            return self::getDb()->options()->update([
                'link_option_value' => $value
            ], [
                'object_id' => $unique_id,
                'link_option' => $option,
            ]);
        } else {
            return self::addOption($unique_id, $option, $value);
        }
    }

    public static function deleteOption($unique_id, $option){
        return self::getDb()->options()->delete([
            'object_id' => $unique_id,
            'link_option' => $option,
        ]);
    }

    public static function getOption($unique_id, $option){
        $option = self::getDb()->options()->get([
            'object_id' => $unique_id,
            'link_option' => $option,
        ]);

        return $option && is_object($option) ? $option->link_option_value : false;
    }

    public static function isExistsOption($unique_id, $option){
        $option = self::getDb()->options()->get([
            'object_id' => $unique_id,
            'link_option' => $option,
        ]);

        return $option && is_object($option);
    }

    public static function deleteOptions($unique_id){
        return self::getDb()->options()->delete(['object_id' => $unique_id]);
    }

    public static function getOptions($unique_id){
        return self::getDb()->options()->getResults([
            'fields' => [
                'object_id' => $unique_id
            ]
        ]);
    }

    public static function getOptionKeys()
    {
        global $wpdb;
        $table = Database::$table_options;
        $sql = "SELECT DISTINCT(link_option) FROM %i";
        $stmt = $wpdb->get_col($wpdb->prepare($sql, $table));
        return $stmt;
    }

    public static function isRestrictByView($unique_id){
        $value = self::getOption($unique_id, 'view_restrictions_status');
        return $value == true;
    }

    public static function isRestrictByWoo($unique_id){
        $value = Options::isActiveWoo() && self::getOption($unique_id, 'restriction_woo');
        return $value == true;
    }

    public static function isRestrictByEdd($unique_id){
        $value = Options::isActiveEdd() && self::getOption($unique_id, 'restriction_edd');
        return $value == true;
    }

    public static function isAccessForProducts($unique_id){
        return self::getOption($unique_id, 'woo_products');
    }

    public static function isAccessForEddProducts($unique_id){
        return self::getOption($unique_id, 'edd_products');
    }

    public static function getClickLimitNumber($unique_id){
        return self::getOption($unique_id, 'click_limited_num');
    }

    public static function getViewLimitNumber($unique_id){
        return self::getOption($unique_id, 'click_limited_num');
    }

    public static function getClicksCount($unique_id){
        return self::getOption($unique_id, 'clicks_count');
    }

    public static function getViewsCount($unique_id){
        return self::getOption($unique_id, 'views_count');
    }

    public static function isOnlyLoggedUser($unique_id){
        return self::getOption($unique_id, 'only_user_logged') == true;
    }

    public static function isIframePreview($unique_id){
        return self::getOption($unique_id, 'iframe_preview') == true;
    }

    public static function hasSchedule($unique_id){
        return self::getOption($unique_id, 'schedule_status') == true;
    }

    public static function getScheduleStart($unique_id){
        $start_time = self::getOption($unique_id, 'schedule_start');

        if(empty($start_time)){
            $start_time = strtotime(Links::getItem($unique_id, 'created_at'));
        }

        return $start_time;
    }

    public static function getScheduleEnd($unique_id){
        return self::getOption($unique_id, 'schedule_end');
    }

    public static function getRemainingDays($unique_id)
    {
        $end_time = (int) self::getScheduleEnd($unique_id);
        $current_time = time();

        if (empty($end_time))
            return false;

        $remaining_seconds = $end_time - $current_time;

        return floor($remaining_seconds / (60 * 60 * 24));
    }

    public static function isStartSchedule($unique_id){
        $start_time = (int) self::getScheduleStart($unique_id);

        $timezone = Utility::getTimeZone();
        $current_time = new \DateTime('now', $timezone);
        $start_time = new \DateTime(date('Y-m-d H:i', $start_time), $timezone);

        return !empty($start_time) && self::hasSchedule($unique_id) && $current_time >= $start_time;
    }

    public static function isExpired($unique_id)
    {
        $end_time = (int) self::getScheduleEnd($unique_id);

        $timezone = Utility::getTimeZone();
        $current_time = new \DateTime('now', $timezone);
        $end_time = new \DateTime(date('Y-m-d H:i', $end_time), $timezone);

        return !empty($end_time) && self::hasSchedule($unique_id) && $current_time > $end_time;
    }

    public static function isVerifyPassword($unique_id, $user_password){
        $link = Links::get($unique_id);
        return $link && $link->password === $user_password;
    }

    public static function getSimpleText($unique_id){
        return self::getOption($unique_id, 'simple_text_content');
    }
}