<?php
namespace WPSURL\App\Elementor\Widgets;

use Elementor\Controls_Manager;
use WPSURL\App\Assets;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class AlertBox extends \Elementor\Widget_Base
{
    public function __construct($data=[], $args=[])
    {
        parent::__construct($data, $args);
        Assets::registerStyle('wpsurl.bulma.css', WPSURL_CSS_URL . 'bulma.min.css', null, WPSURL_VERSION);
        Assets::registerStyle('alert.box.css', WPSURL_ELEMENTOR_CSS_URL . 'alert-box.css');
    }

    public function get_style_depends()
    {
        return [Assets::getHandleName('wpsurl.bulma.css'), Assets::getHandleName('alert.box.css')];
    }

    public function get_name()
    {
        return 'wpsurl_alert_box';
    }

    public function get_title()
    {
        return esc_html__('Alert Box', WPSURL_TEXT_DOMAIN);
    }

    public function get_icon() {
        return 'eicon-alert';
    }

    public function get_categories() {
        return ['wpsurl_elements'];
    }

    public function get_keywords()
    {
        return ['alert_box', 'alertbox', esc_html__('Alert Box' , WPSURL_TEXT_DOMAIN)];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', WPSURL_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'alert_text',
            [
                'label' => esc_html__('Text', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Write the alert text...', WPSURL_TEXT_DOMAIN)
            ]
        );

        $this->add_control(
            'close_btn',
            [
                'label' => esc_html__('Close Button', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', WPSURL_TEXT_DOMAIN),
                'label_off' => esc_html__('Hide', WPSURL_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes'
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content_styles',
            [
                'label' => esc_html__('Content', WPSURL_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'box_height',
            [
                'label' => esc_html__('Height', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 500,
                    ]
                ],
                'default' => [
                  'unit' => 'px',
                  'size' => 50
                ],
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-alert-box' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $alignment = [
            'left' => [
                'title' => __('Left', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-left'
            ],
            'center' => [
                'title' => __('Center', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-center'
            ],
            'right' => [
                'title' => __('Right', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-right'
            ]
        ];

        $this->add_responsive_control(
            'box_text_alignment',
            [
                'label' => esc_html__('Alignment', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $alignment : array_reverse($alignment),
                'default' => is_rtl() ? 'right' : 'left',
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-alert-box-content' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_bg',
                'label' => esc_html__('Background', WPSURL_TEXT_DOMAIN),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .wpsurl-alert-box',
                'fields_options' => [
                    'background' => ['default' => 'gradient'],
                    'color' => ['default' => '#6600ff'],
                    'color_b' => ['default' => '#e200ff'],
                    'gradient_angle' => ['default' => [
                        'unit' => 'deg',
                        'size' => 90,
                    ]],
                ]
            ]
        );

        $this->add_control(
            'box_text_color',
            [
                'label' => esc_html__('Text color', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-alert-box-content' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'box_content_typo',
                'selector' => '{{WRAPPER}} .wpsurl-alert-box-content',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16'
                        ]
                    ],
                ]
            ]
        );

        $this->add_responsive_control(
            'box_border_radius',
            [
                'label' => esc_html__('Border Radius', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-alert-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'label' => esc_html__('Border', WPSURL_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .wpsurl-alert-box',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_wrap_shadow',
                'label' => esc_html__('Box Shadow', WPSURL_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .wpsurl-alert-box',
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $close_btn = $settings['close_btn'] == 'yes';
        $content = $settings['alert_text'];
        ?>
        <div class="wpsurl-alert-box wpsurl-alert-box-<?php echo $wid ?> <?php echo !$close_btn ? ' without-close' : '' ?>">
            <?php if($close_btn): ?>
                <span class="close-alert-box delete remove-parent"></span>
            <?php endif; ?>
            <div class="wpsurl-alert-box-content"><?php echo $content; ?></div>
        </div>
        <?php
    }
}