<?php
namespace WPSURL\App\Elementor\Widgets;

use Elementor\Controls_Manager;
use WPSURL\App\Assets;
use WPSURL\App\Utility;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class ReportForm extends \Elementor\Widget_Base
{
    public function __construct($data=[], $args=[])
    {
        parent::__construct($data, $args);
        Assets::registerStyle('wpsurl.hystmodal.css', WPSURL_CSS_URL . 'hystmodal.min.css', null, WPSURL_VERSION);
        Assets::registerScript('wpsurl.hystmodal.js', WPSURL_JS_URL . 'hystmodal.min.js', null, WPSURL_VERSION, true);
    }

    public function get_style_depends()
    {
        return [Assets::getHandleName('wpsurl.hystmodal.css')];
    }

    public function get_script_depends()
    {
        return [Assets::getHandleName('wpsurl.hystmodal.js')];
    }

    public function get_name()
    {
        return 'wpsurl_report_form';
    }

    public function get_title()
    {
        return esc_html__('Report Form', WPSURL_TEXT_DOMAIN);
    }

    public function get_icon() {
        return 'eicon-form-horizontal';
    }

    public function get_categories() {
        return ['wpsurl_elements'];
    }

    public function get_keywords()
    {
        return ['report_form', 'reportform', esc_html__('Report Form' , WPSURL_TEXT_DOMAIN)];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_settings',
            [
                'label' => esc_html__('Content', WPSURL_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'show_text',
            [
                'label' => esc_html__( 'Show Text', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', WPSURL_TEXT_DOMAIN ),
                'label_off' => esc_html__( 'Hide', WPSURL_TEXT_DOMAIN ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => esc_html__( 'Text', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'If there is a problem, be sure to report it.', WPSURL_TEXT_DOMAIN ),
                'condition' => [
                        'show_text' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label' => esc_html__( 'Button Text', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Report a problem', WPSURL_TEXT_DOMAIN ),
            ]
        );

        $this->end_controls_section();

        /**
         *
         * Styles
         *
         *
         */

        $this->start_controls_section(
            'btn_styles',
            [
                'label' => esc_html__('Button', WPSURL_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->start_controls_tabs(
            'style_tabs'
        );
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', WPSURL_TEXT_DOMAIN ),
            ]
        );

        $this->add_control(
            'btn_text_color',
            [
                'label' => esc_html__( 'Color', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'default' => '#f44336',
                'selectors' => [
                    '{{WRAPPER}} a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '14',
                        ]
                    ]
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg',
                'selector' => '{{WRAPPER}} a',
                'exclude' => ['image'],
            ]
        );

        $this->add_control(
            'btn_padding',
            [
                'label' => esc_html__( 'Padding', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'btn_margin',
            [
                'label' => esc_html__( 'Margin', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} a',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_box_shadow',
                'label' => esc_html__('Box Shadow', WPSURL_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} a',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__( 'Hover', WPSURL_TEXT_DOMAIN ),
            ]
        );

        $this->add_control(
            'btn_text_color_hover',
            [
                'label' => esc_html__( 'Color', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_hover',
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} a:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_hover',
                'selector' => '{{WRAPPER}} a:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_box_shadow_hover',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} a:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'content_styles',
            [
                'label' => esc_html__('Content', WPSURL_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $alignment = [
            'left' => [
                'title' => __('Left', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-left'
            ],
            'center' => [
                'title' => __('Center', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-center'
            ],
            'right' => [
                'title' => __('Right', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-right'
            ]
        ];

        $this->add_responsive_control(
            'box_text_alignment',
            [
                'label' => esc_html__('Alignment', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $alignment : array_reverse($alignment),
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-report-form-element' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__('Text color', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} p' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_text' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'box_content_typo',
                'selector' => '{{WRAPPER}} p',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '14'
                        ]
                    ],
                ],
                'condition' => [
                    'show_text' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();

        ?>
        <div class="wpsurl-report-form-element wpsurl-report-form-element-<?php echo $wid; ?>">
            <p>
                <?php if ($settings['show_text'] == 'yes'): ?>
                <span><?php echo $settings['text'] ?></span>
                <?php endif; ?>
                <a href="" class="report-form-modal-btn" data-hystmodal="#link-report-modal"><?php echo $settings['btn_text'] ?></a>
            </p>
        </div>
        <?php
    }
}