<?php
namespace WPSURL\App\Thirdparty;

use Google\Exception;

class GoogleDriveFileList
{
    protected $client;

    public function __construct($apiKey) {
        $this->client = new \Google\Client();
        $this->client->setDeveloperKey($apiKey);
    }

    public function getFileList() {
        $driveService = new \Google\Service\Drive($this->client);

        if(!$this->checkRequirements()){
            return false;
        }

        try {
            $results = $driveService->files->listFiles();

            $files = [];
            foreach ($results->getFiles() as $file) {
                $files[] = [
                    'id' => $file->getId(),
                    'name' => $file->getName(),
                    'link' => $file->getWebContentLink(),
                    'mimeType' => $file->getMimeType(),
                    'createdTime' => $file->getCreatedTime(),
                    'modifiedTime' => $file->getModifiedTime()
                ];
            }

            return $files;
        } catch (\Exception $e){
            return $e->getMessage();
        }
    }

    public function checkRequirements(){
        return is_ssl();
    }
}