<?php
namespace WPSURL\App\Traits;

trait ElementorWidgetMethods
{
    public function render_url_attributes($params, $replacements = []){
        $url = $params['url'];
        $nofollow = isset($params['nofollow']) && $params['nofollow'] === 'on' ? ' rel="nofollow"' : '';
        $target = isset($params['is_external']) && $params['is_external'] === 'on' ? ' target="_blank"' : '';
        $custom_attributes = isset($params['custom_attributes']) && !empty($params['custom_attributes']) ? $params['custom_attributes'] : false;
        $atts = '';

        if($custom_attributes){
            $custom_attributes = explode(',', $custom_attributes);
            foreach ($custom_attributes as $attr) {
                $attr = explode('|', $attr);
                if(isset($attr[0]) && !empty($attr[0])){
                    $atts .= sprintf(' %s="%s"', $attr[0], (isset($attr[1]) && !empty($attr[1]) ? $attr[1] : ''));
                }
            }
        }

        if(is_array($replacements) && !empty($replacements)){
            $url = str_replace(array_keys($replacements), array_values($replacements), $url);
        }

        $str = "href='{$url}' {$atts} {$target} {$nofollow}";
        echo $str;
    }
}