jQuery(document).ready(function($){
    var body = $('body');

    $('.wpsurl-header-nav > a').click(function (e) {
        e.preventDefault();
        let navWrap = $('.wpsurl-header-nav');
        let tabsWrap = $('.wpsurl-content');
        let currentLink = $(this);
        let currentTabID = currentLink.attr('href');
        let currentTab = $(currentTabID);
        navWrap.find('.wpsurl-menu-item').removeClass('is-active');
        currentLink.addClass('is-active');
        tabsWrap.find('.wpsurl-tab-content').hide();
        currentTab.show();
    });

    body.on("click", ".wpsurl-parent-close", function (e) {
        e.preventDefault();
        let $this = $(this);
        $this.parent().slideUp();
    });

    body.on("click", ".wpsurl-link-open-more", function (e) {
        e.preventDefault();
        let $this = $(this);
        let uniqueID = $this.data('wpsurl-unique-id');
        let el = $('.link-item-' + uniqueID + ' .link-push-options');
        el.slideToggle();
    });

    body.on("click", ".link-option-copy", function (e) {
        e.preventDefault();
        let $this = $(this),
            wrap = $this.parent().parent(),
            text = wrap.data('value');

        navigator.clipboard.writeText(text);

        surlMessager.success(wpsurl_data.txt_copy_success, 7000);
    });

    body.on("click", ".wpsurl-copy-to-clipboard", function (e) {
        e.preventDefault();
        let btn = $(this),
            text = btn.data('value');

        navigator.clipboard.writeText(text);

        surlMessager.success(wpsurl_data.txt_copy_success, 4000);
    });

    body.on("click", ".link-option-open", function (e) {
        e.preventDefault();
        let $this = $(this),
            wrap = $this.parent().parent(),
            link = wrap.data('value');
        if (wpsurlValidUrl(link)) {
            window.open(link);
        } else {
            surlMessager.fire(wpsurl_data.txt_link_invalid, "error");
        }
    });

    body.on("click", ".wpsurl-upload-button", function (e) {
        e.preventDefault();
        let field_cls = $(this).data('wpsurl-field');
        let field = $('.' + field_cls);
        let custom_uploader = wp.media({
            title: 'Upload file',
            button: {
                text: 'Select file'
            },
            multiple: false
        }).on('select', function () {
            let attachment = custom_uploader.state().get('selection').first().toJSON();
            field.val(attachment.url);
        }).open();
    });

    body.on('change', ".wpsurl-file-input-control", function (e) {
        e.preventDefault();
        let field = $(this);
        let fieldVal = field.val();
        let fieldID = field.attr('id');
        let fieldLabel = $('label[for=' + fieldID + ']');
        if (fieldVal !== '' || fieldVal !== undefined) {
            fieldLabel.addClass('file-selected');
        }
    });

    /*
    *
    * Ajax requests
    *
    */
    body.on("click", ".wpsurl-add-new-link", function (e) {
        e.preventDefault();
        let $this = $(this);
        let modal = $(".wpsurl-modal.create-new-link");
        if (modal.length > 0) {
            modal.fadeIn(300);
        }
    });

    $('.wpsurl-link-checkbox #only-user-logged').change(function (e) {
        e.preventDefault();
        let $this = jQuery(this);
        if ($this.prop('checked')) {
            $this.prop('value', true);
            $this.attr('checked', 'checked');
        } else {
            $this.prop('value', false);
            $this.removeAttr('checked');
        }
    });

    $("#wpsurl-new-link-form").submit(function (e) {
        e.preventDefault();
        let loader = $('.wpsurl-modal.create-new-link .wpsurl-button.save');
        let $this = $(this);
        let multiSelect = $("#link-access-for-products").val() || [];
        let eddSelect = $("#link-access-for-edd-products").val() || [];
        let formData = wpsurlGetFormData(this);

        formData['action'] = 'wpsurl_action_insert_link';
        formData['nonce'] = wpsurl_data.nonce;

        $.ajax({
            url: wpsurl_data.ajax_url,
            data: formData,
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                loader.addClass('loading');
            },
            success: function (response) {
                surlMessager.fire(response.msg, response.type);
                if (response.type === 'success') {
                    if (response.links_count > 0) {
                        setTimeout(function () {
                            location.reload();
                        }, 2000)
                    }
                } else {
                    loader.removeClass('loading');
                }
            },
            error: function () {
                loader.removeClass('loading');
                surlMessager.fire(wpsurl_data.txt_unknown_err, 'error');
            },
        });
        return false;
    });

    body.on("click", ".link-status", function (e) {
        e.preventDefault();
        let $this = $(this);
        let uniqueID = $this.data('wpsurl-unique-id');
        let el = $('.link-item-' + uniqueID);
        let loader = $('.link-item-' + uniqueID + ' .wpsurl-link-item-loader');
        surlMessager.info({
            timeout: 20000,
            displayMode: 'once',
            id: 'inputs',
            zindex: 999,
            message: wpsurl_data.txt_chng_status,
            position: window.innerWidth < 768 ? 'bottomCenter' : 'center',
            drag: false,
            buttons: [
                [`<button><b>${wpsurl_data.txt_yes}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'cbutton');
                }, true],
                [`<button><b>${wpsurl_data.txt_no}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'nobutton');
                }, true],
            ],
            onClosing: function(instance, toast, closedBy){
                if(closedBy !== 'cbutton')
                    return false;

                $.ajax({
                    url: wpsurl_data.ajax_url,
                    data: {
                        'action': 'wpsurl_action_change_link_status',
                        'unique_id': uniqueID,
                        'nonce': wpsurl_data.nonce
                    },
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        loader.show();
                    },
                    success: function (response) {
                        loader.hide();
                        surlMessager.fire(response.msg, response.type);
                        if (response.type === 'success') {
                            if (response.status === 'active') {
                                $this.removeClass('inactive').addClass('active');
                            } else {
                                $this.removeClass('active').addClass('inactive');
                            }
                        }
                    },
                    error: function () {
                        surlMessager.fire(wpsurl_data.txt_unknown_err, 'error');
                    },
                });
            },
        });
    });

    body.on("click", ".link-lock", function (e) {
        e.preventDefault();
        let $this = $(this),
            uniqueID = $this.data('wpsurl-unique-id'),
            $locked = $this.data('wpsurl-link-locked'),
            el = $('.link-item-' + uniqueID),
            loader = $('.link-item-' + uniqueID + ' .wpsurl-link-item-loader'),
            enteredPass = null,
            msg;

        msg = {
            timeout: 20000,
            displayMode: 'once',
            id: 'inputs',
            zindex: 999,
            message: $locked ? wpsurl_data.txt_inactive_lock : wpsurl_data.txt_pls_entr_pwd,
            position: 'center',
            drag: false,
            buttons: [
                [`<button><b>${wpsurl_data.txt_confirm}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'cbutton');
                }, true],
            ],
            onClosing: function(instance, toast, closedBy){
                if(closedBy !== 'cbutton')
                    return false;

                if(!$locked){
                    if(enteredPass === null || enteredPass === ''){
                        surlMessager.error(wpsurl_data.txt_pls_entr_value);
                        return false;
                    }
                }

                $.ajax({
                    url: wpsurl_data.ajax_url,
                    data: {
                        'action': 'wpsurl_action_active_link_lock',
                        'unique_id': uniqueID,
                        'password': enteredPass,
                        'unlock': $locked ? true : false,
                        'nonce': wpsurl_data.nonce
                    },
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        loader.show();
                    },
                    success: function (response) {
                        loader.hide();
                        surlMessager.fire(response.msg, response.type);
                        if (response.type === 'success') {
                            if (typeof response.lock !== "undefined") {
                                $this.removeClass('inactive').addClass('active');
                                $this.attr('data-wpsurl-link-locked', true);
                                $this.data('wpsurl-link-locked', true);
                            } else {
                                $this.removeClass('active').addClass('inactive');
                                $this.attr('data-wpsurl-link-locked', false);
                                $this.data('wpsurl-link-locked', false);
                            }
                        }
                    },
                    error: function () {
                        surlMessager.fire(wpsurl_data.txt_unknown_err, 'error');
                    },
                })
            },
        };

        if(!$locked){
            msg['inputs'] = [
                ['<input type="text">', 'keyup', function (instance, toast, input, e) {
                    enteredPass = input.value;
                }, true]
            ];
        }

        surlMessager.info(msg);
    });

    body.on("click", ".link-delete", function (e) {
        e.preventDefault();
        let $this = $(this);
        let uniqueID = $this.data('wpsurl-unique-id');
        let el = $('.link-item-' + uniqueID);
        let loader = $('.link-item-' + uniqueID + ' .wpsurl-link-item-loader');
        surlMessager.info({
            timeout: 20000,
            displayMode: 'once',
            id: 'inputs',
            zindex: 999,
            message: wpsurl_data.txt_delete,
            position: window.innerWidth < 768 ? 'bottomCenter' : 'center',
            drag: false,
            buttons: [
                [`<button><b>${wpsurl_data.txt_yes}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'cbutton');
                }, true],
                [`<button><b>${wpsurl_data.txt_no}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'nobutton');
                }, true],
            ],
            onClosing: function(instance, toast, closedBy){
                if(closedBy !== 'cbutton')
                    return false;

                $.ajax({
                    url: wpsurl_data.ajax_url,
                    data: {
                        'action': 'wpsurl_action_delete_link',
                        'unique_id': uniqueID,
                        'nonce': wpsurl_data.nonce
                    },
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        loader.show();
                        el.css('opacity', 0.3);
                    },
                    success: function (response) {
                        loader.hide();
                        surlMessager.fire(response.msg, response.type);
                        if (response.type === 'success') {
                            $('.wpsurl-links-counter .count').text(response.links_count);
                            el.remove().slideUp();
                            setTimeout(function () {
                                location.reload();
                            }, 2000);
                        } else {
                            el.css('opacity', 1);
                        }
                    },
                    error: function () {
                        surlMessager.fire(wpsurl_data.txt_unknown_err, 'error');
                    },
                });
            },
        });
    });

    body.on("click", ".link-edit", function (e) {
        e.preventDefault();
        let $this = $(this);
        let uniqueID = $this.data('wpsurl-unique-id');
        let loader = $('.link-item-' + uniqueID + ' .wpsurl-link-item-loader');
        body.append(
            $('<div/>', {'class': 'wpsurl-modal edit-link remove-close'}).append(
                $('<div/>', {'class': 'wpsurl-modal-overly'})
            ).append(
                $('<div/>', {'class': 'wpsurl-modal-wrapper'}).append(
                    $('<div/>', {'class': 'wpsurl-modal-title'}).append(
                        $('<span/>', {'class': 'wpsurl-close-modal'}).append(
                            $('<i/>', {'class': 'wpsurl-icon-close'})
                        ),
                        $('<span/>', {'class': 'title', text: wpsurl_data.txt_link_edit})
                    ),
                    $('<div/>', {'class': 'wpsurl-modal-content'}).append(
                        $('<div/>', {'class': 'wpsurl-edit-link-loader'}).append(
                            $('<div/>', {'class': 'wpsurl-svg-loader dark'}).append(
                                $('<svg width="38" height="38" viewBox="0 0 38 38" xmlns="http://www.w3.org/2000/svg"><g fill="none" fill-rule="evenodd"> <g transform="translate(1 1)" stroke-width="2"> <circle stroke-opacity=".5" cx="18" cy="18" r="18"></circle> <path d="M36 18c0-9.94-8.06-18-18-18" transform="rotate(242.643 18 18)"> <animateTransform attributeName="transform" type="rotate" from="0 18 18" to="360 18 18" dur="1s" repeatCount="indefinite"></animateTransform> </path> </g> </g><svg/>'),
                            ),
                        ),
                    )
                )
            )
        );
        if ($('.wpsurl-modal').length > 0) {
            $.ajax({
                url: wpsurl_data.ajax_url,
                data: {
                    'action': 'wpsurl_action_edit_html',
                    'unique_id': uniqueID,
                    'nonce': wpsurl_data.nonce
                },
                type: 'POST',
                beforeSend: function () {
                    loader.show();
                },
                success: function (response) {
                    loader.hide();
                    if (response.length > 0) {
                        $(".wpsurl-modal.edit-link .wpsurl-modal-content").html(response);
                        $('.editor-wpsurl-js-select').selectize({
                            searchField: ['text'],
                            plugins: ['remove_button']
                        });
                    } else {
                        body.find(".wpsurl-modal.edit-link").remove();
                    }
                },
                error: function () {
                    loader.hide();
                    surlMessager.fire(wpsurl_data.txt_unknown_err, 'error');
                    body.find(".wpsurl-modal.edit-link").remove();
                },
            });
        }
    });

    body.on("click", ".clear-link-data", function (e) {
        e.preventDefault();
        let $this = $(this);
        let uniqueID = $this.data('wpsurl-unique-id');
        let clearType = $this.data('wpsurl-clear-type');
        let el = $('.link-item-' + uniqueID);
        let loader = $('.link-item-' + uniqueID + ' .wpsurl-link-item-loader');
        let viewsWrap = $('.link-item-' + uniqueID + ' .link-views-count span');
        let clicksWrap = $('.link-item-' + uniqueID + ' .link-clicks-count span');
        let modalTitle = '';
        if (clearType === 'views') {
            modalTitle = wpsurl_data.txt_views_count;
        } else if (clearType === 'clicks') {
            modalTitle = wpsurl_data.txt_clicks_count;
        }

        surlMessager.info({
            timeout: 20000,
            displayMode: 'once',
            id: 'inputs',
            zindex: 999,
            title: wpsurl_data.txt_delete,
            message: modalTitle,
            position: window.innerWidth < 768 ? 'bottomCenter' : 'center',
            drag: false,
            buttons: [
                [`<button><b>${wpsurl_data.txt_yes}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'cbutton');
                }, true],
                [`<button><b>${wpsurl_data.txt_no}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'nobutton');
                }, true],
            ],
            onClosing: function(instance, toast, closedBy){
                if(closedBy !== 'cbutton')
                    return false;

                $.ajax({
                    url: wpsurl_data.ajax_url,
                    data: {
                        'action': 'wpsurl_action_clear_link_data',
                        'unique_id': uniqueID,
                        'clear_type': clearType,
                        'nonce': wpsurl_data.nonce
                    },
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        loader.show();
                        el.css('opacity', 0.3);
                    },
                    success: function (response) {
                        loader.hide();
                        el.css('opacity', 1);
                        surlMessager.fire(response.msg, response.type);
                        if (response.type === 'success') {
                            if (clearType === 'views') {
                                viewsWrap.text(response.count);
                            } else if (clearType === 'clicks') {
                                clicksWrap.text(response.count);
                            }
                            
                            if(response.count <= 0){
                                $this.remove();
                            }
                        }
                    },
                    error: function () {
                        surlMessager.fire(wpsurl_data.txt_unknown_err, 'error');
                    },
                });
            },
        });
    });

    body.on("click", ".wpsurl-empty-table", function (e) {
        e.preventDefault();
        let $this = $(this);
        let tableWrap = $('.wp-list-table');
        let table = $this.data('table');

        surlMessager.info({
            timeout: 20000,
            displayMode: 'once',
            id: 'inputs',
            zindex: 999,
            message: wpsurl_data.txt_are_clear_data,
            position: window.innerWidth < 768 ? 'bottomCenter' : 'center',
            drag: false,
            buttons: [
                [`<button><b>${wpsurl_data.txt_yes}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'cbutton');
                }, true],
                [`<button><b>${wpsurl_data.txt_no}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'nobutton');
                }, true],
            ],
            onClosing: function(instance, toast, closedBy){
                if(closedBy !== 'cbutton')
                    return false;

                $.ajax({
                    url: wpsurl_data.ajax_url,
                    data: {
                        'action': 'wpsurl_action_empty_table',
                        table: table,
                        nonce: wpsurl_data.nonce
                    },
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        tableWrap.css('opacity', 0.4);
                    },
                    success: function (response) {
                        tableWrap.css('opacity', 1);
                        surlMessager.fire(response.msg, response.type);
                        if (response.type === 'success') {
                            location.reload();
                        }
                    },
                    error: function () {
                        tableWrap.css('opacity', 1);
                        surlMessager.fire(wpsurl_data.txt_unknown_err, 'error');
                    },
                });
            },
        });
    });

    $(document).on('change', '.link-type-selection', function(){
        let select = $(this),
            selected = select.val(),
            parent = select.parent(),
            allDes = $('.des-link-type'),
            target = $('.des-link-type-' + selected);
        if (target.length) {
            allDes.slideUp();
            target.slideDown();
        } else {
            allDes.slideUp();
        }
    })

    body.on("change", "#link-checked-all", function (e) {
        e.preventDefault();
        let input = $(this),
            checkboxes = document.querySelectorAll('.wpsurl-links-list input[type="checkbox"]');
        if (input.is(':checked')) {
            for (var i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].type === 'checkbox') {
                    checkboxes[i].checked = true;
                }
            }
        } else {
            for (var i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].type === 'checkbox') {
                    checkboxes[i].checked = false;
                }
            }
        }
    });

    body.on("change", '.wpsurl-links-list .link-affected-chckbox input[type="checkbox"]', function (e) {
        e.preventDefault();
        let input = $(this),
            checkboxes = document.querySelectorAll('.wpsurl-links-list .link-affected-chckbox input[type="checkbox"]'),
            checkAllBtn = document.getElementById('link-checked-all');
        if (!input.is(':checked') && checkAllBtn.checked === true) {
            checkAllBtn.checked = false;
        } else {
            let allChecked = true;
            for (var i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].type === 'checkbox' && (checkboxes[i].id).search('all') < 0) {
                    if (!checkboxes[i].checked) {
                        allChecked = false;
                        break;
                    }
                }
            }
            if (allChecked){
                checkAllBtn.checked = true;
            }
        }
    });

    $('#wpsurl-import-form').submit(function (e) {
        let form = $(this);
        let input = $('#import_links_file').val();
        if (input === '' || input === undefined) {
            surlMessager.fire(wpsurl_data.txt_pls_select_file, 'error');
            return false;
        }
    });

    body.on("click", ".wpsurl-modal-overly, .wpsurl-close-modal", function (e) {
        e.preventDefault();
        if ($(".wpsurl-modal.remove-close").length > 0) {
            body.find(".wpsurl-modal.remove-close").remove();
        } else {
            body.find(".wpsurl-modal").fadeOut(300);
        }
    });

    body.on("change", ".checkbox-affected-toggle-elements", function (e) {
        e.preventDefault();
        let $this = $(this),
            reverse = $this.data('reverse'),
            target = $($this.data('elements'));
        if(target.length){
            if(typeof reverse !== 'undefined' && reverse === true){
                if(!$this.is(':checked')){
                    target.slideDown();
                } else {
                    target.slideUp();
                }
            } else {
                if($this.is(':checked')){
                    target.slideDown();
                } else {
                    target.slideUp();
                }
            }
        }
    });

    body.on("change", ".select-affected-toggle-elements", function (e) {
        e.preventDefault();
        let item = $(this),
            itemVal = item.val(),
            allTargets = $(item.data('option-targets')),
            target = $(item.data('option-target-' + itemVal));
        if(target.length){
            if(target.is(':visible')){
                target.slideUp();
            } else {
                target.slideDown();
            }
        } else {
            if(allTargets.length){
                allTargets.slideUp();
            }
        }
    });

    body.on("change", ".affected-toggle-elements", function (e) {
        e.preventDefault();
        let $this = $(this),
            target = $($this.data('elements'));
        if(target.length){
            if(target.is(':visible')){
                target.slideUp();
            } else {
                target.slideDown();
            }
        }
    });

    body.on("change", ".checkbox-affected-reverse-toggle-elements", function (e) {
        e.preventDefault();
        let $this = $(this),
            showEl = $($this.data('show')),
            hideEl = $($this.data('hide'));
        if($this.is(':checked')){
            showEl.slideDown();
            hideEl.slideUp();
        } else {
            showEl.slideUp();
            hideEl.slideDown();
        }
    });

    body.on("click", ".report-item-action-btn", function (e) {
        e.preventDefault();
        let btn = $(this),
            itemID = btn.data('id'),
            action = btn.data('action');

        $.ajax({
            url: wpsurl_data.ajax_url,
            data: {
                'action': 'wpsurl_report_item_action',
                id: itemID,
                item_action: action,
                nonce: wpsurl_data.nonce
            },
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                btn.attr('disabled', true);
            },
            complete: function (res) {
                res = res.responseJSON;
                surlMessager.fire(res.msg, res.type);
                if(res.type === 'success'){
                    location.reload();
                } else {
                    btn.attr('disabled', false);
                }
            },
            error: function () {
                btn.attr('disabled', false);
            }
        });
    });

    body.on("click", ".export-action-btn", function (e) {
        e.preventDefault();
        let btn = $(this);

        $.ajax({
            url: wpsurl_data.ajax_url,
            data: {
                'action': 'wpsurl_export_links_action',
                nonce: wpsurl_data.nonce
            },
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                btn.attr('disabled', true);
            },
            complete: function (res) {
                btn.attr('disabled', false);

                res = res.responseJSON;

                if(res && res.success === true){
                    if(wpsurlJson(res.data.json)){
                        const blob = new Blob([res.data.json], { type: 'application/json' });
                        const url = URL.createObjectURL(blob);
                        const link = document.createElement('a');

                        link.href = url;
                        link.download = res.data.file_name;

                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                        URL.revokeObjectURL(url);
                    }
                }
            },
            error: function () {
                btn.attr('disabled', false);
            }
        });
    });

    const nlForm = document.querySelector('#wpsurl-new-link-form');
    const submitBtn = document.querySelector('.wpsurl-button.save');

    if(nlForm){
        nlForm.addEventListener('input', function() {
            const requiredFields = nlForm.querySelectorAll('input[required], select[required], textarea[required]');
            let isFormValid = true;

            requiredFields.forEach(function(field) {
                const isFieldVisible = $(field).is(':visible');

                if(isFieldVisible){
                    if (!field.value || field.value === 0 || field.value === '0') {
                        isFormValid = false;
                    }
                }
            })

            submitBtn.disabled = !isFormValid;
        });
    }

    body.on('change keyup', '.wpsurl-settings-page .realtime-save-field', function(){
        let input = $(this),
            type = input.attr('type'),
            inputVal = type === 'checkbox' ? input.is(':checked') : input.val();

        $.ajax({
            url: wpsurl_data.ajax_url,
            data: {
                action: 'wpsurl_realtime_save_field',
                nonce: wpsurl_data.nonce,
                name: input.attr('name'),
                type: type,
                value: inputVal
            },
            type: 'POST',
            dataType: 'json',
            beforeSend: function(){
                input.parent().addClass('in-progress');
            },
            complete: function(res){
                input.parent().removeClass('in-progress');
            },
            error: function(){
                input.parent().removeClass('in-progress');
            }
        });
    });

    let formID = $("#wpsurl-link-edit-form").data('wpsurl-unique-id');

    $(document).on('change', "#only-user-logged-" + formID, function(e) {
        e.preventDefault();
        let $this = $(this);
        if ($this.prop('checked')) {
            $this.prop('value', true);
            $this.attr('checked', 'checked');
        } else {
            $this.prop('value', false);
            $this.removeAttr('checked');
        }
    });

    $(document).on('change', '.link-type', function(e) {
        e.preventDefault();
        let select = $(this);
        let selected = select.val();
        let parent = select.parent();
        if (selected === '3') {
            if (!parent.hasClass('wpsurl-selected')) {
                parent.addClass('wpsurl-selected');
            }
        } else {
            if (parent.hasClass('wpsurl-selected')) {
                parent.removeClass('wpsurl-selected');
            }
        }
    });

    $(document).on('submit', "#wpsurl-link-edit-form", function(e) {
        e.preventDefault();
        let $this = $(this);
        let uniqueID = $this.data('wpsurl-unique-id');
        let formData = wpsurlGetFormData(this);
        formData['id'] = uniqueID;
        formData['action'] = 'wpsurl_action_edit_link';
        formData['nonce'] = wpsurl_data.nonce;

        $.ajax({
            url: wpsurl_data.ajax_url,
            data: formData,
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                $('.wpsurl-modal.edit-link .wpsurl-button.save').addClass('loading');
            },
            success: function (response) {
                surlMessager.fire(response.msg, response.type);
                if (response.type === 'success') {
                    setTimeout(function () {
                        location.reload();
                    }, 1000)
                } else {
                    $('.wpsurl-modal.edit-link .wpsurl-button.save').removeClass('loading');
                }
            },
        });
    });

    $(document).on('click', "form .reset-form", function(e) {
        let btn = $(this),
            formID = btn.closest('form').attr('id'),
            form = $('#' + formID);

        if(form.length){
            form.find('.wpsurl-button.save').attr('disabled', true);
            setTimeout(() => {
                $(`#${formID} input, #${formID} select, #${formID} textarea`).trigger('change');
            }, 400);
        }
    });

    $(document).on('submit', "#wpsurl-replacement-form", function(e) {
        e.preventDefault();
        let $this = $(this);
        let formData = wpsurlGetFormData(this);
        formData['action'] = 'wpsurl_action_replacement';
        formData['nonce'] = wpsurl_data.nonce;

        surlMessager.question({
            timeout: 20000,
            displayMode: 'once',
            id: 'inputs',
            zindex: 999,
            title: wpsurl_data.txt_are_sure,
            message: wpsurl_data.txt_not_returned + ' ' + wpsurl_data.txt_pls_db_backup,
            position: window.innerWidth < 768 ? 'bottomCenter' : 'center',
            drag: false,
            buttons: [
                [`<button><b>${wpsurl_data.txt_yes}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'cbutton');
                }, true],
                [`<button><b>${wpsurl_data.txt_cancel}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'nobutton');
                }, true],
            ],
            onClosing: function(instance, toast, closedBy){
                if(closedBy !== 'cbutton')
                    return false;

                $.ajax({
                    url: wpsurl_data.ajax_url,
                    data: formData,
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        wpsurlGenerateLoader($this);
                    },
                    success: function (response) {
                        wpsurlRemoveLoader($this);
                        if(response){
                            surlMessager.fire(response.msg, response.type);
                            if(response.type === 'success'){
                                $this[0].reset();
                                location.reload();
                            }
                        }
                    },
                    error: function (){
                        wpsurlRemoveLoader($this);
                    }
                });
            },
        });
    });

    $(document).on('submit', "#wpsurl-add-api-key-form", function(e) {
        e.preventDefault();
        let $this = $(this);
        let formData = wpsurlGetFormData(this);
        formData['action'] = 'wpsurl_action_add_api_key';
        formData['nonce'] = wpsurl_data.nonce;

        $.ajax({
            url: wpsurl_data.ajax_url,
            data: formData,
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                wpsurlGenerateLoader($this);
            },
            success: function (response) {
                wpsurlRemoveLoader($this);
                if(response){
                    surlMessager.fire(response.msg, response.type);
                    if(response.type === 'success'){
                        $this[0].reset();
                        location.reload();
                    }
                }
            },
            error: function (){
                wpsurlRemoveLoader($this);
            }
        });
    });

    $(document).on('click', ".wpsurl-revoke-api-key-btn", function(e) {
        e.preventDefault();
        let btn = $(this),
            itemID = btn.data('id');

        $.ajax({
            url: wpsurl_data.ajax_url,
            data: {
                action: 'wpsurl_action_revoke_api_key',
                nonce: wpsurl_data.nonce,
                id: itemID
            },
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                wpsurlGenerateLoader(btn);
            },
            success: function (response) {
                wpsurlRemoveLoader(btn);
                if(response){
                    surlMessager.fire(response.msg, response.type);
                    if(response.type === 'success'){
                        location.reload();
                    }
                }
            },
            error: function (){
                wpsurlRemoveLoader(btn);
            }
        });
    });

    if ($('.html-editor').length > 0) {
        wp.codeEditor.initialize($('.html-editor'), wpsurl_data);
    }

    if ($('.wpsurl-js-select').length > 0) {
        $('.wpsurl-js-select').selectize({
            searchField: ['text'],
            plugins: ['remove_button'],
        });
    }

    setTimeout(() => {
        $('.wp-editor-html-code').css('display', ($('#use_html_code').is(':checked') ? 'block' : 'none'));
    }, 500);
})