'use strict'

let wpsurlCaptchaElements = [
    'report-problem-captcha',
    'password-form-captcha',
];

function wpsurlGenerateCatptcha(elementID = 'captcha', type = 'number'){
    if(document.getElementById(elementID)){
        document.getElementById(elementID).innerHTML = "";
        let charsArray ="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ@!#$%^&*";
        if(type == 'number'){
            charsArray ="0123456789";
        }
        let lengthOtp = 6;
        let captcha = [];
        for (let i = 0; i < lengthOtp; i++) {
            let index = Math.floor(Math.random() * charsArray.length + 1);
            if (captcha.indexOf(charsArray[index]) == -1)
                captcha.push(charsArray[index]);
            else i--;
        }
        let canv = document.createElement("canvas");
        canv.id = elementID;
        canv.width = 100;
        canv.height = 50;
        let ctx = canv.getContext("2d");
        ctx.font = "25px Georgia";
        ctx.strokeText(captcha.join(""), 0, 30);
        wpsurlCaptchaElements[elementID] = captcha.join("");
        document.getElementById(elementID).appendChild(canv);
    }
}
function wpsurlReGenerateCaptchaCodes(){
    if(typeof wpsurlCaptchaElements !== "undefined" && wpsurlCaptchaElements.length){
        jQuery.each(wpsurlCaptchaElements, function(i, val){
            wpsurlGenerateCatptcha(val);
        });
    }
}

function wpsurlGetCaptchaCode(key){
    return typeof wpsurlCaptchaElements !== "undefined" && typeof wpsurlCaptchaElements[key] !== "undefined" && wpsurlCaptchaElements.length ? wpsurlCaptchaElements[key] : null;
}

function wpsurlElement(selector){
    return typeof selector === 'function' ? selector : jQuery(selector);
}

function wpsurlDocumentReady(fn) {
    if (document.readyState != 'loading'){
        fn();
    } else {
        document.addEventListener('DOMContentLoaded', fn);
    }
}

function wpsurlNumberArToEn(num){
    return document.body.classList.contains('rtl') ? ArabicTools.digitsEnToAr(num) : num;
}

class SurlMyMessager {
    static overlayColor = 'rgba(0,0,0,0.15)';
    static params(params){
        let is_rtl = document.body.classList.contains('rtl');
        let options = {
            overlay: true,
            overlayClose: true,
            overlayColor: this.overlayColor,
            rtl: is_rtl,
            position: 'bottom' + (is_rtl ? 'Right' : 'Left'),
        };
        if(params){
            for ( let index in params ) {
                options[index] = params[index];
            }
        }
        return options;
    }
    static success(msg, timeout = 20000){
        msg = typeof msg === 'object' ? msg : {
            message: msg,
            timeout: timeout
        };
        iziToast.success(this.params(msg));
    }

    static error(msg, timeout = 20000){
        msg = typeof msg === 'object' ? msg : {
            message: msg,
            timeout: timeout
        };
        iziToast.error(this.params(msg));
    }

    static warning(msg, timeout = 20000){
        msg = typeof msg === 'object' ? msg : {
            message: msg,
            timeout: timeout
        };
        iziToast.warning(this.params(msg));
    }

    static info(msg, timeout = 20000){
        msg = typeof msg === 'object' ? msg : {
            message: msg,
            timeout: timeout,
        };
        iziToast.info(this.params(msg));
    }

    static question(msg, timeout = 20000){
        msg = typeof msg === 'object' ? msg : {
            message: msg,
            timeout: timeout,
        };
        iziToast.question(this.params(msg));
    }

    static fire(msg = '', type = 'success'){
        if(type === 'error'){
            this.error(msg);
        } else if(type === 'warning'){
            this.warning(msg);
        } else if(type === 'info'){
            this.info(msg);
        } else {
            this.success(msg);
        }
    }
}

let surlMessager = SurlMyMessager;

function wpsurlGenerateLoader(element){
    let el = wpsurlElement(element),
        loaderContent = wpsurlElement(`<div class="is-loader loader-line"></div>`);
    el.css('position', 'relative');
    loaderContent.hide();
    el.append(loaderContent);
    el.find('.is-loader').slideDown();
    el.addClass('has-loader');
}

function wpsurlRemoveLoader(element){
    let el = wpsurlElement(element);
    el.find('.is-loader').slideUp(function(){
        wpsurlElement(this).remove();
    });
    el.removeClass('has-loader');
}

function wpsurlValidUrl(url) {
    return /(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/.test(url);
}

function wpsurlRewriteInputFetch(id) {
    let $this = jQuery(this);
    let field = jQuery('#' + id);
    let rewrite = field.val();
    let saveBtn = jQuery('.save-settings-btn');
    if (rewrite.length <= 3 || rewrite.length === 0) {
        return false
    }
    jQuery.ajax({
        url: wpsurl_data.ajax_url,
        type: 'post',
        data: {
            action: 'wpsurl_action_rewrite_exists',
            'rewrite': rewrite
        },
        beforeSend: function () {
            field.css({'opacity': 0.6, 'pointer-events': 'none'});
            saveBtn.css({'opacity': 0.6, 'pointer-events': 'none'});
        },
        success: function (data) {
            field.css({'opacity': 1, 'pointer-events': 'all'});
            if (data.type === 'success') {
                field.css('border-color', 'green');
                saveBtn.css({'opacity': 1, 'pointer-events': 'all'});
            } else {
                field.css('border-color', 'red');
            }
        },
        complete: function () {
            field.css({'opacity': 1, 'pointer-events': 'all'});
        },
        error: function () {
            saveBtn.css({'opacity': 0.6, 'pointer-events': 'none'});
            surlMessager.fire(wpsurl_data.txt_unknown_err, 'error');
        },
    });
}

function wpsurlSetCookie(name, value, exdays = 30) {
    const d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    let expires = "expires=" + d.toUTCString();
    document.cookie = name + "=" + value + ";" + expires + ";path=/";
}

function wpsurlDeleteCookie(name, exdays = 100) {
    const d = new Date();
    d.setTime(d.getTime() + (-exdays * 24 * 60 * 60 * 1000));
    let expires = "expires=" + d.toUTCString();
    document.cookie = name + "=;" + expires + ";path=/";
}

function wpsurlGetCookie(cname) {
    let name = cname + "=";
    let ca = document.cookie.split(';');
    for(let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

function wpsurlCheckCookie(name) {
    let data = wpsurlGetCookie(name);
    if (data != "") {
        return true;
    }

    return false;
}

function wpsurlGetFormData(form){
    let formData = {},
        fields = form.elements;
    for (let i = 0; i < fields.length; i++) {
        let field = fields[i],
            fieldType = field.type.toLowerCase(),
            fieldName = field.name,
            fieldValue = field.value;

        switch (fieldType) {
            case 'text':
            case 'date':
            case 'time':
            case 'datetime-local':
            case 'email':
            case 'password':
            case 'textarea':
            case 'number':
            case 'search':
            case 'url':
            case 'hidden':
            case 'radio':
            case 'select':
            case 'select-one':
            case 'select-multiple':
                if(field.multiple || fieldType.search('multiple') >= 0){
                    fieldValue = jQuery(field).val() || [];
                    fieldValue = fieldValue.join(',');
                }
                formData[fieldName || field.id] = fieldValue;
                break;
            case 'checkbox':
                if (field.checked) {
                    formData[fieldName || field.id] = field.checked;
                }
                break;
        }
    }
    formData = new Object(formData);
    return formData;
}

function wpsurlGetQueryParam(key) {
    const queryString = window.location.search.substring(1);
    if (!queryString) {
        return null;
    }

    const params = new URLSearchParams(queryString);
    const value = params.get(key);
    if (!value) {
        return null;
    }

    return decodeURIComponent(value);
}

function wpsurlJson(str) {
    try {
        JSON.parse(str);
        return true;
    } catch (e) {
        return false;
    }
}

jQuery(document).ready(function($){
    let body = $('body');
    if(typeof HystModal !== 'undefined'){
        const myModal = new HystModal({
            linkAttributeName: "data-hystmodal",
        });
    }

    wpsurlReGenerateCaptchaCodes();

    body.on('click', '.reload-captcha', function (e){
        e.preventDefault();
        let btn = $(this),
            captchaID = btn.attr('id');
        wpsurlGenerateCatptcha(captchaID);
    })
});