<?php
use WPSURL\App\Utility;

$is_active_woo = \WPSURL\App\Options::isActiveWoo();
$is_active_edd = \WPSURL\App\Options::isActiveEdd();
$types = \WPSURL\App\Links::getTypes();
?>
<form action="<?php echo add_query_arg(['']) ?>" method="post" data-wpsurl-unique-id="<?php echo esc_attr($unique_id) ?>" id="wpsurl-link-edit-form" novalidate>
    <div class="form-fields-group">
        <div class="form-field-group">
            <label class="input-label"><?php _e('Title', WPSURL_TEXT_DOMAIN) ?></label>
            <div class="form-field-box">
                <input type="text" id="link-title-<?php echo esc_attr($unique_id) ?>" value="<?php echo esc_attr($link_title) ?>" name="title" required>
            </div>
        </div>
        <div class="form-field-group des-link-type des-link-type-1 des-link-type-2" style="display:<?php echo $link_type !== 3 ? 'block' : 'none' ?>">
            <label class="input-label"><?php _e('Link', WPSURL_TEXT_DOMAIN) ?></label>
            <div class="form-field-box">
                <input type="text" dir="ltr" id="link-<?php echo esc_attr($unique_id) ?>" value="<?php echo esc_attr($link) ?>" name="link" required>
            </div>
            <div class="field-des des-link-type des-link-type-2" style="display:<?php echo $link_type == '2' ? 'block' : 'none' ?>">
                <p><?php echo __('Tip: Remove extra characters from the link.', WPSURL_TEXT_DOMAIN) ?></p>
                <p><span class="success-note">https://domain.com/video.mp4</span><span class="important-note">?794325694&query=true</span></p>
            </div>
        </div>
        <div class="form-field-group w-100">
            <label class="input-label"><?php _e('Type', WPSURL_TEXT_DOMAIN) ?></label>
            <div class="form-field-box">
                <select id="link-type-<?php echo esc_attr($unique_id) ?>" class="link-type-selection" name="type" required>
                    <?php foreach ($types as $key => $value): ?>
                        <option<?php echo $link_type == $key ? ' selected ' : '' ?> value="<?php echo esc_attr($key) ?>"><?php echo $value; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
        <div class="form-field-group des-link-type des-link-type-3 w-100" style="display:<?php echo $link_type === 3 ? 'block' : 'none' ?>">
            <label class="input-label"><?php _e('Text', WPSURL_TEXT_DOMAIN) ?></label>
            <div class="form-field-box">
                <textarea name="simple_text_content" id="link-text-<?php echo esc_attr($unique_id) ?>" class="w-100" required><?php echo $link_text ?></textarea>
            </div>
        </div>
        <hr class="w-100">
        <div class="form-field-group des-link-type des-link-type-1 w-100" style="display:<?php echo $link_type == '1' ? 'block' : 'none' ?>">
            <div class="form-field-box">
                <div class="wpsurl-link-checkbox">
                    <input type="checkbox" id="iframe-preview-<?php echo esc_attr($unique_id) ?>" name="iframe_preview" <?php echo $is_preview ? ' checked' : '' ?>>
                    <label for="iframe-preview-<?php echo esc_attr($unique_id) ?>">
                        <i class="wpsurl-icon-check"></i>
                    </label>
                </div>
                <label for="iframe-preview-<?php echo esc_attr($unique_id) ?>"><?php _e('Preview in Iframe', WPSURL_TEXT_DOMAIN) ?></label>
            </div>
        </div>
        <div class="form-field-group">
            <div class="wpsurl-link-checkbox">
                <input type="checkbox" value="<?php echo esc_attr($restriction_woo) ?>" id="restriction-woo-<?php echo esc_attr($unique_id) ?>" name="restriction_woo" class="checkbox-affected-toggle-elements" data-elements=".edit-woo-products-list" <?php echo $is_active_woo && $restriction_woo ? ' checked' : '' ?>  <?php echo !$is_active_woo ? ' disabled' : '' ?>>
                <label for="restriction-woo-<?php echo esc_attr($unique_id) ?>">
                    <i class="wpsurl-icon-check"></i>
                </label>
            </div>
            <label for="restriction-woo-<?php echo esc_attr($unique_id) ?>">
                <?php _e('Restriction woocommerce customers', WPSURL_TEXT_DOMAIN) ?>
                <?php if (!$is_active_woo): ?>
                    <span class="is-not-active"><?php _e('Woo is not active.', WPSURL_TEXT_DOMAIN) ?></span>
                <?php endif; ?>
            </label>
            <?php if ($is_active_woo): ?>
            <div class="form-field-box-wrap edit-woo-products-list" style="display:<?php echo $is_active_woo && $restriction_woo ? 'block' : 'none' ?>">
                <label class="input-label"><?php _e('WooCommerce products', WPSURL_TEXT_DOMAIN) ?></label>
                <div class="form-field-box">
                    <?php
                    $products_count = wp_count_posts('product');
                    if (isset($products_count->publish) && $products_count->publish > 0) {
                        \WPSURL\App\Utility::dropDownPosts(array(
                            'post_type' => 'product',
                            'multi' => true,
                            'class' => 'editor-wpsurl-js-select',
                            'id' => 'woo-products-' . $unique_id,
                            'select_name' => 'woo_products',
                            'selected' => explode(',', \WPSURL\App\LinkOptions::getOption($unique_id, 'woo_products'))
                        ));
                    } else { ?>
                        <div class="not-found"><?php echo __('Product Not Found.', WPSURL_TEXT_DOMAIN); ?></div>
                    <?php } ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <div class="form-field-group">
            <div class="wpsurl-link-checkbox">
                <input type="checkbox" value="<?php echo esc_attr($restriction_edd) ?>" id="restriction-edd-<?php echo esc_attr($unique_id) ?>" name="restriction_edd" class="checkbox-affected-toggle-elements" data-elements=".edit-edd-products" <?php echo $is_active_edd && $restriction_edd ? ' checked' : '' ?>  <?php echo !$is_active_edd ? ' disabled' : '' ?>>
                <label for="restriction-edd-<?php echo esc_attr($unique_id) ?>">
                    <i class="wpsurl-icon-check"></i>
                </label>
            </div>
            <label for="restriction-edd-<?php echo esc_attr($unique_id) ?>">
                <?php _e('Restriction edd customers', WPSURL_TEXT_DOMAIN) ?>
                <?php if (!$is_active_edd): ?>
                    <span class="is-not-active"><?php _e('Edd is not active.', WPSURL_TEXT_DOMAIN) ?></span>
                <?php endif; ?>
            </label>
            <?php if ($is_active_edd): ?>
            <div class="form-field-box-wrap edit-edd-products" style="display:<?php echo $is_active_edd && $restriction_edd ? 'block' : 'none' ?>">
                <label class="input-label"><?php _e('Edd products', WPSURL_TEXT_DOMAIN) ?></label>
                <div class="form-field-box">
                    <?php
                    $products_count = wp_count_posts('download');
                    if (isset($products_count->publish) && $products_count->publish > 0) {
                        \WPSURL\App\Utility::dropDownPosts(array(
                            'post_type' => 'download',
                            'multi' => true,
                            'class' => 'editor-wpsurl-js-select',
                            'id' => 'edd-products-' . $unique_id,
                            'select_name' => 'edd_products',
                            'selected' => explode(',', \WPSURL\App\LinkOptions::getOption($unique_id, 'edd_products'))
                        ));
                    } else { ?>
                        <div class="not-found"><?php echo __('Product Not Found.', WPSURL_TEXT_DOMAIN); ?></div>
                    <?php } ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <div class="form-field-group w-100">
            <div class="form-field-box">
                <div class="wpsurl-link-checkbox">
                    <input type="checkbox" id="view-restrictions-<?php echo esc_attr($unique_id) ?>" name="view_restrictions" value="<?php echo esc_attr($restrictions_status) ?>" class="checkbox-affected-toggle-elements" data-elements=".edit-views-limit-box,.edit-click-limit-box" <?php echo ($restrictions_status) ? ' checked' : ''; ?>>
                    <label for="view-restrictions-<?php echo esc_attr($unique_id) ?>">
                        <i class="wpsurl-icon-check"></i>
                    </label>
                </div>
                <label for="view-restrictions-<?php echo esc_attr($unique_id) ?>"><?php _e('Visit restrictions', WPSURL_TEXT_DOMAIN) ?></label>
            </div>
        </div>
        <div class="form-field-group edit-views-limit-box" style="display:<?php echo ($restrictions_status) ? 'inline-block' : 'none'; ?>">
            <label class="input-label"><?php _e('View limit', WPSURL_TEXT_DOMAIN) ?></label>
            <div class="form-field-box">
                <input type="number" id="link-views-limit-<?php echo esc_attr($unique_id) ?>" value="<?php echo \WPSURL\App\LinkOptions::getOption($unique_id, 'view_limited_num') ?>" name="view_limited_num" min="0">
            </div>
        </div>
        <div class="form-field-group edit-click-limit-box" style="display:<?php echo ($restrictions_status) ? 'inline-block' : 'none'; ?>">
            <label class="input-label"><?php _e('Click limit', WPSURL_TEXT_DOMAIN) ?></label>
            <div class="form-field-box">
                <input type="number" id="link-clicks-limit-<?php echo esc_attr($unique_id) ?>" value="<?php echo \WPSURL\App\LinkOptions::getOption($unique_id, 'click_limited_num') ?>" name="click_limited_num" min="0">
            </div>
        </div>
        <div class="form-field-group">
            <div class="form-field-box">
                <div class="wpsurl-link-checkbox">
                    <input type="checkbox" value="<?php echo esc_attr($only_logged) ?>" name="only_user_logged" id="only-user-logged-<?php echo esc_attr($unique_id) ?>" <?php echo ($only_logged) ? ' checked' : ''; ?>>
                    <label for="only-user-logged-<?php echo esc_attr($unique_id) ?>">
                        <i class="wpsurl-icon-check"></i>
                    </label>
                </div>
                <label for="only-user-logged-<?php echo esc_attr($unique_id) ?>"><?php _e('Only the logged in user', WPSURL_TEXT_DOMAIN) ?></label>
            </div>
        </div>
        <div class="form-field-group w-100">
            <div class="form-field-box">
                <div class="wpsurl-link-checkbox">
                    <input type="checkbox" value="false" id="schedule-status-<?php echo esc_attr($unique_id) ?>" name="schedule_status" class="checkbox-affected-toggle-elements" data-elements=".edit-schedule-start,.edit-schedule-end" <?php echo ($schedule_status) ? ' checked' : ''; ?>>
                    <label for="schedule-status-<?php echo esc_attr($unique_id) ?>">
                        <i class="wpsurl-icon-check"></i>
                    </label>
                </div>
                <label for="schedule-status-<?php echo esc_attr($unique_id) ?>"><?php _e('Schedule', WPSURL_TEXT_DOMAIN) ?></label>
            </div>
        </div>
        <div class="form-field-group edit-schedule-start" style="display:<?php echo ($schedule_status) ? 'block' : 'none'; ?>">
            <label class="input-label" for="schedule-start-<?php echo esc_attr($unique_id) ?>"><?php _e('Start Time', WPSURL_TEXT_DOMAIN) ?></label>
            <div class="form-field-box">
                <input type="datetime-local" id="schedule-start-<?php echo esc_attr($unique_id) ?>" name="schedule_start" value="<?php echo !empty($schedule_start) ? date("Y-m-d\TH:i", $schedule_start) : '' ?>">
            </div>
        </div>
        <div class="form-field-group edit-schedule-end" style="display:<?php echo ($schedule_status) ? 'block' : 'none'; ?>">
            <label class="input-label" for="schedule-end-<?php echo esc_attr($unique_id) ?>"><?php _e('End Time', WPSURL_TEXT_DOMAIN) ?></label>
            <div class="form-field-box">
                <input type="datetime-local" id="schedule-end-<?php echo esc_attr($unique_id) ?>" name="schedule_end" min="<?php echo date("Y-m-d\TH:i", time()) ?>" value="<?php echo !empty($schedule_end) ? date("Y-m-d\TH:i", $schedule_end) : '' ?>">
            </div>
        </div>
        <?php do_action('wpsurl_edit_link_fields', $unique_id); ?>
    </div>
    <div class="wpsurl-form-footer">
        <button type="submit" class="wpsurl-button form-btn save">
            <img src="<?php echo WPSURL_IMG_URL . 'loader.svg' ?>" alt="loader" style="display: none">
            <?php _e('Save Changes', WPSURL_TEXT_DOMAIN) ?>
        </button>
    </div>
</form>