<?php
$is_active_woo = \WPSURL\App\Options::isActiveWoo();
$is_active_edd = \WPSURL\App\Options::isActiveEdd();
$types = \WPSURL\App\Links::getTypes();
?>
<!-- Modal Create New Link -->
<div class="wpsurl-modal create-new-link" style="display: none">
    <div class="wpsurl-modal-overly"></div>
    <div class="wpsurl-modal-wrapper">
        <div class="wpsurl-modal-title">
            <span class="wpsurl-close-modal"><i class="wpsurl-icon-close"></i></span>
            <span class="title"><?php _e('Add New Link', WPSURL_TEXT_DOMAIN) ?></span>
        </div>
        <div class="wpsurl-modal-content">
            <div class="wpsurl-loader-done" style="display: none">
                <?php \WPSURL\App\Utility::showLoader(null, 'svg', 'dark') ?>
            </div>
            <form action="<?php echo add_query_arg(['']) ?>" method="post" id="wpsurl-new-link-form" novalidate>
                <div class="form-fields-group">
                    <div class="form-field-group">
                        <label class="input-label"><?php _e('Title', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <input type="text" id="link-title" name="title" required>
                        </div>
                    </div>
                    <div class="form-field-group">
                        <label class="input-label"><?php _e('Type', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <select id="link-type" class="link-type-selection" name="type" required>
                                <option value="0"><?php _e('Select Type...', WPSURL_TEXT_DOMAIN); ?></option>
                                <?php foreach ($types as $key => $value): ?>
                                    <option value="<?php echo esc_attr($key) ?>"><?php echo $value; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-field-group des-link-type des-link-type-1 des-link-type-2" style="display:none;">
                        <label class="input-label"><?php _e('Link', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <input type="text" dir="ltr" id="link-value" name="link" required>
                        </div>
                        <div class="field-des des-link-type des-link-type-2" style="display:none">
                            <p><?php echo __('Tip: Remove extra characters from the link.', WPSURL_TEXT_DOMAIN) ?></p>
                            <p><span class="success-note">https://domain.com/video.mp4</span><del class="important-note">?794325694&query=true</del></p>
                        </div>
                    </div>
                    <div class="form-field-group">
                        <label class="input-label"><?php _e('Password', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <input type="text" dir="ltr" id="link-password" name="password">
                        </div>
                    </div>
                    <div class="form-field-group des-link-type des-link-type-3 w-100" style="display:none">
                        <label class="input-label"><?php _e('Text', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <textarea name="simple_text_content" id="link-text" class="w-100" required></textarea>
                        </div>
                    </div>
                    <hr class="w-100">
                    <div class="form-field-group des-link-type des-link-type-1 w-100" style="display:none">
                        <div class="form-field-box">
                            <div class="wpsurl-link-checkbox">
                                <input type="checkbox" value="false" id="iframe-preview" name="iframe_preview">
                                <label for="iframe-preview">
                                    <i class="wpsurl-icon-check"></i>
                                </label>
                            </div>
                            <label for="iframe-preview"><?php _e('Preview in Iframe', WPSURL_TEXT_DOMAIN) ?></label>
                        </div>
                    </div>
                    <div class="form-field-group">
                        <div class="wpsurl-link-checkbox">
                            <input type="checkbox" value="false" id="restriction-woo" name="restriction_woo" class="checkbox-affected-toggle-elements" data-elements=".woo-products-list" <?php echo !$is_active_woo ? ' disabled' : '' ?>>
                            <label for="restriction-woo">
                                <i class="wpsurl-icon-check"></i>
                            </label>
                        </div>
                        <label for="restriction-woo">
                            <?php _e('Restriction woocommerce customers', WPSURL_TEXT_DOMAIN) ?>
                            <?php if (!$is_active_woo): ?>
                                <span class="is-not-active"><?php _e('Woo is not active.', WPSURL_TEXT_DOMAIN) ?></span>
                            <?php endif; ?>
                        </label>
                        <?php if ($is_active_woo): ?>
                        <div class="form-field-box-wrap woo-products-list" style="display:none">
                            <label class="input-label"><?php _e('WooCommerce products', WPSURL_TEXT_DOMAIN) ?></label>
                            <div class="form-field-box">
                                <?php
                                $products_count = wp_count_posts('product');
                                if (isset($products_count->publish) && $products_count->publish > 0) {
                                    \WPSURL\App\Utility::dropDownPosts(array(
                                        'post_type' => 'product',
                                        'multi' => true,
                                        'class' => 'wpsurl-js-select',
                                        'id' => 'woo-products',
                                        'select_name' => 'woo_products',
                                        'selected' => 0
                                    ));
                                } else { ?>
                                    <div class="not-found"><?php echo __('Product Not Found.', WPSURL_TEXT_DOMAIN); ?></div>
                                <?php } ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="form-field-group">
                        <div class="wpsurl-link-checkbox">
                            <input type="checkbox" value="false" id="restriction-edd" name="restriction_edd" class="checkbox-affected-toggle-elements" data-elements=".edd-products" <?php echo !$is_active_edd ? ' disabled' : '' ?>>
                            <label for="restriction-edd">
                                <i class="wpsurl-icon-check"></i>
                            </label>
                        </div>
                        <label for="restriction-edd">
                            <?php _e('Restriction edd customers', WPSURL_TEXT_DOMAIN) ?>
                            <?php if (!$is_active_edd): ?>
                                <span class="is-not-active"><?php _e('Edd is not active.', WPSURL_TEXT_DOMAIN) ?></span>
                            <?php endif; ?>
                        </label>
                        <?php if ($is_active_edd): ?>
                        <div class="form-field-box-wrap edd-products" style="display:none">
                            <label class="input-label"><?php _e('Edd products', WPSURL_TEXT_DOMAIN) ?></label>
                            <div class="form-field-box">
                                <?php
                                $products_count = wp_count_posts('download');
                                if (isset($products_count->publish) && $products_count->publish > 0) {
                                    \WPSURL\App\Utility::dropDownPosts(array(
                                        'post_type' => 'download',
                                        'multi' => true,
                                        'class' => 'wpsurl-js-select',
                                        'id' => 'edd-products',
                                        'select_name' => 'edd_products',
                                        'selected' => 0
                                    ));
                                } else { ?>
                                    <div class="not-found"><?php echo __('Product Not Found.', WPSURL_TEXT_DOMAIN); ?></div>
                                <?php } ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="form-field-group w-100">
                        <div class="form-field-box">
                            <div class="wpsurl-link-checkbox">
                                <input type="checkbox" value="false" id="view-restrictions" name="view_restrictions" class="checkbox-affected-toggle-elements" data-elements=".views-limit-box,.click-limit-box">
                                <label for="view-restrictions">
                                    <i class="wpsurl-icon-check"></i>
                                </label>
                            </div>
                            <label for="view-restrictions"><?php _e('Visit restrictions', WPSURL_TEXT_DOMAIN) ?></label>
                        </div>
                    </div>
                    <div class="form-field-group views-limit-box" style="display:none">
                        <label class="input-label"><?php _e('View limit', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <input type="number" id="link-views-limit" name="view_limited_num" min="0">
                        </div>
                    </div>
                    <div class="form-field-group click-limit-box" style="display:none">
                        <label class="input-label"><?php _e('Click limit', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <input type="number" id="link-clicks-limit" name="click_limited_num" min="0">
                        </div>
                    </div>
                    <div class="form-field-group">
                        <div class="form-field-box">
                            <div class="wpsurl-link-checkbox">
                                <input type="checkbox" value="false" id="only-user-logged" name="only_user_logged">
                                <label for="only-user-logged">
                                    <i class="wpsurl-icon-check"></i>
                                </label>
                            </div>
                            <label for="only-user-logged"><?php _e('Only the logged in user', WPSURL_TEXT_DOMAIN) ?></label>
                        </div>
                    </div>
                    <div class="form-field-group w-100">
                        <div class="form-field-box">
                            <div class="wpsurl-link-checkbox">
                                <input type="checkbox" value="false" id="schedule-status" name="schedule_status" class="checkbox-affected-toggle-elements" data-elements=".schedule-start,.schedule-end">
                                <label for="schedule-status">
                                    <i class="wpsurl-icon-check"></i>
                                </label>
                            </div>
                            <label for="schedule-status"><?php _e('Schedule', WPSURL_TEXT_DOMAIN) ?></label>
                        </div>
                    </div>
                    <div class="form-field-group schedule-start" style="display:none">
                        <label class="input-label" for="schedule-start"><?php _e('Start Time', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <input type="datetime-local" id="schedule-start" name="schedule_start">
                        </div>
                    </div>
                    <div class="form-field-group schedule-end" style="display:none">
                        <label class="input-label" for="schedule-end"><?php _e('End Time', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <input type="datetime-local" id="schedule-end" name="schedule_end" min="<?php echo date("Y-m-d\TH:i", time()) ?>">
                        </div>
                    </div>
                    <?php do_action('wpsurl_new_link_fields'); ?>
                </div>
                <div class="wpsurl-form-footer">
                    <button type="submit" class="wpsurl-button form-btn save" disabled>
                        <img src="<?php echo WPSURL_IMG_URL . 'loader.svg' ?>" alt="loader" style="display: none">
                        <?php _e('Create', WPSURL_TEXT_DOMAIN) ?>
                    </button>
                    <button type="reset" class="wpsurl-button form-btn reset-form">
                        <?php _e('Clear', WPSURL_TEXT_DOMAIN) ?>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>