<?php
use WPSURL\App\{Links, Options, LinkOptions, Settings, Statistics};

$message      = Settings::getOption( 'view_alert_text' );
$message_type = Settings::getOption( 'view_alert_type' );
$col          = ( \WPSURL\App\Utility::hasNavMenu( 'wpsurl_view_menu' ) ) ? 6 : 12;
$val = \WPSURL\App\Utility::getQueryVarsValue();

$link_data = Links::get($val);

$extra = \WPSURL\App\GlobalData::loadedExtraLinkData($link_data->unique_id);

$btn_cls = (empty($extra->pwd) || $extra->pwd == null || $extra->pwd == '') ? 'button' : 'by-pass';
$time = Settings::getOption( 'view_timer_second_value' );
$timer_status = Settings::getOption( 'view_timer_status' );
$transfer_status = Settings::getOption('transfer_end_timer_status');
$use_html = Options::useHtmlCode();
$link_type = (int) $extra->type;
if ( ! empty( $message ) ):?>
 <div class="wpsurl-view-alert <?php echo esc_attr($message_type) ?>">
     <?php echo $message; ?>
  <span class="wpsurl-toggle wpsurl-alert-close" data-wpsurl-toggle="wpsurl-view-alert"><i class="wpsurl-icon-close"></i></span>
 </div>
<?php endif; ?>
<?php
if(LinkOptions::isIframePreview($extra->unique_id)):
    require_once WPSURL_VIEW_PAGES . 'iframe.php';
else: ?>
<header id="wpsurl-header">
 <div class="wpsurl-container">
  <div class="wpsurl-row">
   <div class="wpsurl-col-lg-<?php echo esc_attr($col); ?> wpsurl-col-md-<?php echo esc_attr($col); ?> wpsurl-col-sm-12 wpsurl-col-xs-12">
    <div class="wpsurl-view-page-logo">
       <div class="wpsurl-logo">
           <a href="<?php echo esc_attr(site_url()) ?>" target="_blank">
            <img src="<?php echo esc_attr(Settings::getLogoUrl()); ?>" alt="<?php echo esc_attr(get_bloginfo( 'name' )) ?>">
           </a>
       </div>
   </div>
   </div>
	  <?php if ( \WPSURL\App\Utility::hasNavMenu( 'wpsurl_view_menu' ) ): ?>
       <div class="wpsurl-col-lg-6 wpsurl-col-md-6 wpsurl-col-sm-12 wpsurl-col-xs-12">
       <?php wp_nav_menu( array( 'theme_location' => 'wpsurl_view_menu', 'container_class' => 'wpsurl-view-nav' ) ); ?>
   </div>
	  <?php endif; ?>
  </div>
 </div>
</header>
<div class="title">
 <div class="wpsurl-container">
  <div class="wpsurl-row">
   <div class="wpsurl-col-lg-6 wpsurl-col-md-6 wpsurl-col-sm-12 wpsurl-col-xs-12">
        <?php
        $title = '';
        if ( ! Settings::getOption( 'links_title_status' ) ) {
	        $title .= '<h1><a class="wpsurl-redirect-by-pass" href="' . \WPSURL\App\Utility::getCurrentViewPageUrl() . '">';
	        $title .= \WPSURL\App\Utility::getCurrentViewPageTitle();
	        $title .= '</a></h1>';
        } else {
	        $title .= '<p>';
	        $title .= __( 'Share Link', WPSURL_TEXT_DOMAIN );
	        $title .= '</p>';
        }
        echo $title;
        ?>
   </div>
   <div class="wpsurl-col-lg-6 wpsurl-col-md-6 wpsurl-col-sm-12 wpsurl-col-xs-12">
    <div class="share">
        <a href="https://twitter.com/share?text=<?php echo esc_attr(\WPSURL\App\Utility::getCurrentViewPageTitle()) ?>&url=<?php echo esc_attr(\WPSURL\App\Utility::getCurrentViewPageUrl()) ?>" target="_blank" class="twitter" title="<?php _e( 'Twitter', WPSURL_TEXT_DOMAIN ); ?>"><i class="wpsurl-icon-twitter"></i></a>
        <a href="https://wa.me/?text=<?php echo esc_attr(\WPSURL\App\Utility::getCurrentViewPageUrl()) ?>" target="_blank" class="whatsapp" title="<?php _e( 'Whatsapp', WPSURL_TEXT_DOMAIN ); ?>"><i class="wpsurl-icon-whatsapp"></i></a>
        <a href="https://telegram.me/share/url?url=<?php echo esc_attr(\WPSURL\App\Utility::getCurrentViewPageUrl()) ?>" target="_blank" class="telegram" title="<?php _e( 'Telegram', WPSURL_TEXT_DOMAIN ); ?>"><i class="wpsurl-icon-telegram"></i></a>
    </div>
   </div>
  </div>
 </div>
</div>
 <div class="wpsurl-container">
  <div class="wpsurl-downloader-wrapper">
     <div class="wpsurl-row">
      <div class="wpsurl-col-lg-<?php echo $use_html ? 6 : 12; ?> wpsurl-col-md-<?php echo $use_html ? 6 : 12; ?> wpsurl-col-sm-12 wpsurl-col-xs-12">
       <div class="wpsurl-downloader-content">
        <div class="wpsurl-report-problem-form">
            <div class="wpsurl-toggle" data-wpsurl-toggle="wpsurl-report-problem-form"><i class="wpsurl-icon-close"></i></div>
            <label for="wpsurl-report-link-problem-email"><?php _e( 'Email', WPSURL_TEXT_DOMAIN ) ?></label>
            <input type="email" dir="ltr" name="wpsurl_report_link_problem_email" id="wpsurl-report-link-problem-email">
            <label for="wpsurl-report-link-problem-des"><?php _e( 'Problem description', WPSURL_TEXT_DOMAIN ) ?></label>
            <textarea name="wpsurl_report_link_problem_des" id="wpsurl-report-link-problem-des"></textarea>
            <button class="wpsurl-button wpsurl-report-problem" data-wpsurl-link-token="<?php echo esc_attr(\WPSURL\App\Utility::getQueryVarsValue()); ?>"><i class="wpsurl-icon-paper-plane-empty"></i><?php _e( 'Report submit', WPSURL_TEXT_DOMAIN ) ?></button>
        </div>
	       <?php if ( ! $timer_status ): ?>
            <div class="wpsurl-timer-container">
                <div id="timer-app" data-time="<?php echo ($time >= 5) ? $time : '5'; ?>"></div>
             </div>
	       <?php endif; ?>
        <?php include WPSURL_VIEW_PATH . 'templates/redirect-button.php'; ?>
        <div class="footer">
         <?php
         $page  = \WPSURL\App\Utility::getCurrentViewPageUrl();
         $token = \WPSURL\App\Utility::getQueryVarsValue();
         $link  = '<a href="#" class="report-form-modal-btn" data-hystmodal="#link-report-modal">' . esc_html__( 'report it to us', WPSURL_TEXT_DOMAIN ) . '</a>';
         printf( __( 'Please if you have any problem link to %s', WPSURL_TEXT_DOMAIN ), $link );
         ?>
        </div>
            </div>
      </div>

      <?php if ($use_html): ?>
      <div class="wpsurl-col-lg-6 wpsurl-col-md-6 wpsurl-col-sm-12 wpsurl-col-xs-12">
          <?php
          $ads = Settings::getOption( 'view_add_html_code' );
          if ( ! empty( $ads ) ): ?>
           <div class="wpsurl-view-ads" style="width: 100%;margin-top: 25px;color: #000000;">
          	 <?php echo \WPSURL\App\Utility::unslashHtml( $ads ); ?>
           </div>
          <?php else: ?>
           <div class="wpsurl-helper-content">
            <div class="wpsurl-ads-position">
             <p><?php _e( 'Your ad location', WPSURL_TEXT_DOMAIN ); ?></p>
             <P><?php echo \WPSURL\App\Number::numByLang( '333 * 515' ) ?></P>
            </div>
           </div>
          <?php endif; ?>
      </div>
      <?php endif; ?>
     </div>
 </div>
</div>
<?php endif; ?>