<?php include_once WPSURL_VIEW_INC . 'header.php'; ?>
<div class="wpsurl-view-content">
    <?php
    require_once WPSURL_VIEW_INC . 'actions.php';
    if($is_active_elementor_page && !\WPSURL\App\LinkOptions::isIframePreview($extra->unique_id)):
        echo do_shortcode("[elementor-template id='{$elementor_page_id}']");
    else:
        if (\WPSURL\App\LinkOptions::isOnlyLoggedUser($extra->unique_id)):
            if (is_user_logged_in()):
                do_action('wpsurl_view_html_content');
            else:
                if (\WPSURL\App\Options::isActiveWoo()) {
                    $login_url = get_permalink(get_option('woocommerce_myaccount_page_id'));
                    $register_url = $login_url;
                } else {
                    $login_url = wp_login_url(\WPSURL\App\Utility::getCurrentViewPageUrl());
                    $register_url = wp_registration_url();
                }
                ?>
                <div class="columns mt-5">
                    <div class="column"></div>
                    <div class="column is-one-third">
                        <div class="card">
                            <header class="card-header">
                                <p class="card-header-title">
                                    <?php _e('Notice', WPSURL_TEXT_DOMAIN) ?>
                                </p>
                            </header>
                            <div class="card-content">
                                <div class="content">
                                    <?php _e('You must be logged in to use this section', WPSURL_TEXT_DOMAIN) ?>
                                </div>
                            </div>
                            <footer class="card-footer">
                                <a href="<?php echo esc_attr($login_url) ?>" class="card-footer-item"><?php _e('Login', WPSURL_TEXT_DOMAIN) ?></a>
                                <a href="<?php echo esc_attr($register_url) ?>" class="card-footer-item"><?php _e('Register', WPSURL_TEXT_DOMAIN) ?></a>
                                <a href="<?php echo esc_attr(site_url()) ?>" class="card-footer-item"><?php _e('Home', WPSURL_TEXT_DOMAIN) ?></a>
                            </footer>
                        </div>
                    </div>
                    <div class="column"></div>
                </div>
            <?php endif;
        else:
            do_action('wpsurl_view_html_content');
        endif;
    endif;
    ?>
</div>
<?php include_once WPSURL_VIEW_INC . 'footer.php'; ?>