<?php
/**
 * Plugin Name: WP Safe Url
 * Plugin URI: https://bavance.com
 * Author: Bavance
 * Author URI: https://bavance.com
 * Version: 1.0.0
 * Description: ability to create secure and short links
 * Text Domain: wpsurl
 * Domain Path: /languages
 */
/**
 * Exit if accessed directly
 */
if (!defined('ABSPATH')) {
    exit;
}

if(class_exists('WPSURL_Plugin'))
    return false;

/*
 *
 *  Loaded plugin core
 *
 */
require_once __DIR__ . DIRECTORY_SEPARATOR . 'core.php';
/*
 *  init hooks
 */
if(class_exists('WPSURL_Plugin')){
    register_activation_hook(plugin_basename(__FILE__), function (){
        if(!class_exists('WPSURL\App\Database')){
            include_once(WPSURL_APP_PATH . 'Database.php');
        }
        $db = new \WPSURL\App\Database();
        $db->create_tables();
    });
    WPSURL_Plugin::Instance();
}
