<?php // phpcs:ignore SlevomatCodingStandard.TypeHints.DeclareStrictTypes.DeclareStrictTypesMissing

namespace MailPoet\Config;

if (!defined('ABSPATH')) exit;


use MailPoet\Util\Helpers;
use MailPoet\WooCommerce\Helper as WooCommerceHelper;
use MailPoet\WP\Functions as WPFunctions;

class PrivacyPolicy {
  public function init() {
    if (function_exists('wp_add_privacy_policy_content')) {
      wp_add_privacy_policy_content(__('MailPoet', 'mailpoet'), $this->getPrivacyPolicyContent());
    }
  }

  public function getPrivacyPolicyContent() {
    $content = (
      '<h2>' .
        __('MailPoet newsletter & emails', 'mailpoet') .
      '</h2>' .
      '<p>' .
        __('If you have subscribed to our newsletter or if you are a member of our website (you can log in) or if you have purchased on our website, there is a good chance you will receive emails from us.', 'mailpoet') .
      '</p>' .
      '<p>' .
        __('We will only send you emails which you have signed up to receive, or which pertain to the services we provided to you.', 'mailpoet') .
      '</p>' .
      '<p>' .
        __('To send you emails, we use the name and email address you provide us. Our site also logs the IP address you used when you signed up for the service to prevent abuse of the system.', 'mailpoet') .
      '</p>' .
      '<p>' .
        Helpers::replaceLinkTags(
          __('This website can send emails through the [link]MailPoet Sending Service[/link]. This service allows us to track opens and clicks on our emails. We use this information to improve the content of our newsletters.', 'mailpoet'),
        'https://www.mailpoet.com/privacy-notice/',
          ['target' => '_blank']
        ) .
      '</p>' .
      '<p>' .
        __('No identifiable information is otherwise tracked outside this website except for the email address.', 'mailpoet') .
      '</p>'
    );
    $helper = new WooCommerceHelper(WPFunctions::get());
    if ($helper->isWooCommerceActive()) {
      $content .= (
        '<p> ' .
          __('Below is a list of cookies that may be generated by MailPoet (note that some cookies are only utilized when WooCommerce is installed and activated):', 'mailpoet') .
        '</p>' .
        '<p>' .
          // translators: %s is the name of the cookie.
          sprintf(__('Cookie name: %s', 'mailpoet'), 'mailpoet_page_view' ) .
          '<br>' .
          // translators: %s is the number of days.
          sprintf(__('Cookie expiry: %s days.', 'mailpoet'), WPFunctions::get()->numberFormatI18n(3650) ) .
          '<br>' .
          __('Cookie description: The purpose of this cookie is to track the last time a subscriber viewed any page on the site.', 'mailpoet') .
        '</p> ' .
        '<p>' .
          // translators: %s is the name of the cookie.
          sprintf(__('Cookie name: %s', 'mailpoet'), 'mailpoet_revenue_tracking' ) .
          '<br>' .
          // translators: %s is the number of days.
          sprintf(__('Cookie expiry: %s days.', 'mailpoet'), WPFunctions::get()->numberFormatI18n(14) ) .
          '<br>' .
          __('Cookie description: The purpose of this cookie is to track which newsletter sent from your website has acquired a click-through and a subsequent purchase in your WooCommerce store.', 'mailpoet') .
        '</p> ' .
        '<p>' .
          // translators: %s is the name of the cookie.
          sprintf(__('Cookie name: %s', 'mailpoet'), 'mailpoet_subscriber' ) .
          '<br>' .
          // translators: %s is the number of days.
          sprintf(__('Cookie expiry: %s days.', 'mailpoet'), WPFunctions::get()->numberFormatI18n(3650) ) .
          '<br>' .
          __('Cookie description: The purpose of this cookie is to track subscriber engagement. It is used when the user logs in, signs up in a form, confirms subscription to a newsletter, or places an order through WooCommerce.', 'mailpoet') .
          '<br>' .
          __('Note: User must be opted-in and a confirmed subscriber.', 'mailpoet') .
        '</p>' .
        '<p>' .
          // translators: %s is the name of the cookie.
          sprintf(__('Cookie name: %s', 'mailpoet'), 'popup_form_dismissed_{$formId}' ) .
          '<br>' .
          __('Cookie expiry: the expiration date varies and can be set per form.', 'mailpoet') .
          '<br>' .
          __("Cookie description: This cookie is used to track if a user has previously dismissed a specific form, preventing the re-display of the form until the cookie's expiration date. It is applicable for popup, slide-in, or fixed bar forms.", 'mailpoet') .
        '</p>'
      );
    }
    return $content;
  }
}
