<?php
/**
 * Exit if accessed directly
 */
if (!defined('ABSPATH')) {
    exit;
}

use WPSURL\App\Statistics;

do_action('wpsurl_bulk_actions');

$links_count = \WPSURL\App\Links::count();
$per_page = 15;
$show = false;
?>
<div class="wrap">
    <?php if($links_count > 0): ?>
    <h1 class="wp-heading-inline"><?php _e('Safe Links', WPSURL_TEXT_DOMAIN) ?></h1>
    <a href="javascript:void(0)" class="page-title-action wpsurl-add-new-link"><?php _e('Add New Link', WPSURL_TEXT_DOMAIN) ?></a>
    <div id="wpsurl-insert-loader" style="display:none;float: left;margin: 21px 0 0 0;"><?php \WPSURL\App\Utility::showLoader('#000000') ?></div>
    <?php endif; ?>
    <hr class="wp-header-end">
    <form id="posts-filter" method="get">
        <div class="wpsurl-admin-page">
            <?php
            if ($links_count > 0):
                ?>
                <div class="search-box">
                    <input type="text" name="search_param" id="search_param" placeholder="<?php _e('Search...', WPSURL_TEXT_DOMAIN) ?>">
                    <select name="search_filter" id="search_filter">
                        <option value="title"><?php _e('Title', WPSURL_TEXT_DOMAIN) ?></option>
                        <option value="link_id"><?php _e('ID', WPSURL_TEXT_DOMAIN) ?></option>
                        <option value="link_key"><?php _e('Key', WPSURL_TEXT_DOMAIN) ?></option>
                    </select>
                    <button class="button button-primary"><?php _e('Filter', WPSURL_TEXT_DOMAIN) ?></button>
                </div>
                <div class="tablenav top" style="width: 100%;margin-bottom:25px">
                    <div class="alignleft actions bulkactions">
                        <div class="wpsurl-link-checkbox" style="float:<?php echo is_rtl() ? 'right' : 'left' ?>;margin:3px 11px 0">
                            <input type="checkbox" name="link_checked_all[]" id="link-checked-all">
                            <label for="link-checked-all"><i class="wpsurl-icon-check"></i></label>
                        </div>
                        <label for="bulk-action-selector-top" class="screen-reader-text"><?php _e('Select collective work', WPSURL_TEXT_DOMAIN) ?></label>
                        <select name="action" id="bulk-action-selector-top">
                            <option value="-1"><?php _e('Collective work', WPSURL_TEXT_DOMAIN) ?></option>
                            <option value="1"><?php _e('Active', WPSURL_TEXT_DOMAIN) ?></option>
                            <option value="2"><?php _e('Inactive', WPSURL_TEXT_DOMAIN) ?></option>
                            <option value="3"><?php _e('Delete', WPSURL_TEXT_DOMAIN) ?></option>
                        </select>
                        <input type="submit" id="doaction" class="button action"
                               value="<?php _e('Run', WPSURL_TEXT_DOMAIN) ?>">
                        <input type="hidden" name="page" value="wpsurl-links">
                    </div>
                    <div class="tablenav-pages one-page">
                        <div class="wpsurl-links-counter">
                            <span class="count"><?php echo \WPSURL\App\Number::numByLang($links_count); ?></span>
                            <?php _e('Item', WPSURL_TEXT_DOMAIN) ?>
                        </div>
                    </div>
                    <div class="wpsurl-search-result" style="width: 100%;display: none">
                        <div class="wpsurl-links-list">
                            <div class="wpsurl-res" style="width: 100%;padding: 10px; background-color: #9ea3a8; border-radius: 5px; margin: 10px 0; "></div>
                        </div>
                    </div>
                    <br class="clear">
                </div>
            <?php endif; ?>
            <div class="wpsurl-links-list wpsurl-links-list-container">
                <?php
                $search_field = (isset($_GET['search_filter'])) ? $_GET['search_filter'] : '';
                $search_param = (isset($_GET['search_param'])) ? $_GET['search_param'] : '';
                $offset = (\WPSURL\App\Utility::getCurrentPageNum() * $per_page) - $per_page;
                $args = [
                    'per_page' => $per_page,
                    'offset' => $offset,
                    'order_by' => 'created_at',
                    'order' => 'DESC',
                ];
                if(!empty($search_field)){
                    $args['fields'] = [
                        [
                            'key' => $search_field,
                            'value' => $search_param
                        ],
                    ];
                }
                $links = \WPSURL\App\Links::getResults($args);

                if ($links):
                    foreach ($links as $link):
                        $link_views = Statistics::getViews($link->link_id);
                        $link_clicks = Statistics::getClicks($link->link_id);
                        $is_preview = \WPSURL\App\LinkOptions::isIframePreview($link->link_id);
                        ?>
                        <div class="link-item link-item-<?php echo $link->link_id; ?> link-item-<?php echo $link->link_key; ?> wpsurl-clearfix">
                            <div class="wpsurl-link-item-loader" style="display: none"><?php \WPSURL\App\Utility::showLoader('#9ea3a8'); ?></div>
                            <div class="wpsurl-float-<?php echo is_rtl() ? 'right' : 'left' ?>">
                                <div class="wpsurl-link-checkbox link-affected-chckbox">
                                    <input type="checkbox" name="link_check[]" value="<?php echo $link->link_id; ?>" id="link-check-<?php echo $link->link_id; ?>">
                                    <label for="link-check-<?php echo $link->link_id; ?>"><i class="wpsurl-icon-check"></i></label>
                                </div>
                                <a href="#" title="<?php _e('Active/Inactive', WPSURL_TEXT_DOMAIN); ?>" class="wpsurl-button link-status link-status-option-color <?php echo $link->status == 'active' ? 'active' : 'inactive'; ?>" data-wpsurl-link-id="<?php echo $link->link_id; ?>" data-wpsurl-link-key="<?php echo $link->link_key; ?>"><i class="wpsurl-icon-link"></i></a>
                                <span class="link-id"><?php echo \WPSURL\App\Number::numByLang($link->link_id); ?></span>
                                <div class="link-title"><?php echo $link->title; ?></div>
                                <div class="link-option safe-link safe-link-<?php echo $link->link_id; ?>">
                                    <input type="text" onclick="select();" value="<?php echo \WPSURL\App\Utility::getHashLink($link->link_id); ?>" readonly/>
                                    <div class="link-field-options">
                                        <div class="link-copy wpsurl-button" title="<?php _e('Copy', WPSURL_TEXT_DOMAIN); ?>" data-wpsurl-link-type="safe" data-wpsurl-link-id="<?php echo $link->link_id; ?>"><i class="wpsurl-icon-copy"></i></div>
                                        <a href="javascript:void(0)" title="<?php _e('Open link', WPSURL_TEXT_DOMAIN); ?>" target="_blank" class="link-open wpsurl-button" data-wpsurl-link-type="safe" data-wpsurl-link-id="<?php echo $link->link_id; ?>"><i class="wpsurl-icon-external-link"></i></a>
                                    </div>
                                </div>
                                <a href="#" title="<?php _e('More', WPSURL_TEXT_DOMAIN); ?>" class="wpsurl-button wpsurl-link-open-more" data-wpsurl-link-id="<?php echo $link->link_id; ?>"><i class="wpsurl-icon-ellipsis-h"></i></a>
                                <?php if ($is_preview): ?>
                                    <span class="option-status"><?php echo __('Is Preview', WPSURL_TEXT_DOMAIN) ?></span>
                                <?php elseif($link->type == 2): ?>
                                    <span class="option-status"><?php echo __('Downloadable File', WPSURL_TEXT_DOMAIN) ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="wpsurl-float-<?php echo is_rtl() ? 'left' : 'right' ?> wpsurl-link-action-btns" style="margin-top:7px;">
                                <a href="javascript:void(0)" title="<?php _e('Edit'); ?>" class="wpsurl-button link-edit" data-wpsurl-link-id="<?php echo $link->link_id; ?>" data-wpsurl-link-key="<?php echo $link->link_key; ?>"><i class="wpsurl-icon-edit"></i></a>
                                <a href="javascript:void(0)" title="<?php _e('Delete'); ?>" class="wpsurl-button link-delete" data-wpsurl-link-id="<?php echo $link->link_id; ?>" data-wpsurl-link-key="<?php echo $link->link_key; ?>"><i class="wpsurl-icon-trash"></i></a>
                                <a href="javascript:void(0)" title="<?php _e('Lock', WPSURL_TEXT_DOMAIN); ?>" class="wpsurl-button link-lock link-status-option-color <?php echo !empty($link->password) || $link->password != null || $link->password != '' ? 'active' : 'inactive'; ?>" data-wpsurl-link-id="<?php echo $link->link_id; ?>" data-wpsurl-link-key="<?php echo $link->link_key; ?>" data-wpsurl-link-locked="<?php echo !empty($link->password) || $link->password != null || $link->password != '' ? 'true' : 'false'; ?>"><i class="wpsurl-icon-lock"></i></a>
                            </div>
                            <div class="link-push-options" style="display: none">
                                <div class="link-option original-link original-link-<?php echo $link->link_id; ?>">
                                    <label for=""><?php _e('Original link', WPSURL_TEXT_DOMAIN) ?></label>
                                    <input type="text" onclick="select();" value="<?php echo $link->link; ?>" readonly/>
                                    <div class="link-field-options">
                                        <div class="link-copy wpsurl-button" title="<?php _e('Copy', WPSURL_TEXT_DOMAIN); ?>" data-wpsurl-link-type="original" data-wpsurl-link-id="<?php echo $link->link_id; ?>"><i class="wpsurl-icon-copy"></i></div>
                                        <a href="javascript:void(0)" title="<?php _e('Open link', WPSURL_TEXT_DOMAIN); ?>" target="_blank" class="link-open wpsurl-button" data-wpsurl-link-type="original" data-wpsurl-link-id="<?php echo $link->link_id; ?>"><i class="wpsurl-icon-external-link"></i></a>
                                    </div>
                                </div>
                                <div class="link-option short-link short-link-<?php echo $link->link_id; ?>">
                                    <label for=""><?php _e('Short link', WPSURL_TEXT_DOMAIN) ?></label>
                                    <input type="text" onclick="select();" value="<?php echo \WPSURL\App\Utility::getHashLink($link->link_id, 'surl'); ?>" readonly/>
                                    <div class="link-field-options">
                                        <div class="link-copy wpsurl-button" title="<?php _e('Copy', WPSURL_TEXT_DOMAIN); ?>" data-wpsurl-link-type="short" data-wpsurl-link-id="<?php echo $link->link_id; ?>"><i class="wpsurl-icon-copy"></i></div>
                                        <a href="javascript:void(0)" title="<?php _e('Open link', WPSURL_TEXT_DOMAIN); ?>" target="_blank" class="link-open wpsurl-button" data-wpsurl-link-type="short" data-wpsurl-link-id="<?php echo $link->link_id; ?>"><i class="wpsurl-icon-external-link"></i></a>
                                    </div>
                                </div>
                                <?php if (in_array($link->type, [2])): ?>
                                    <div class="link-option download-link download-link-<?php echo $link->link_id; ?>">
                                        <label for=""><?php _e('Download link', WPSURL_TEXT_DOMAIN) ?></label>
                                        <?php
                                        $slug = \WPSURL\App\Utility::getPagesSlug(2);
                                        if (!empty($link->password) || $link->password != null || $link->password != '') {
                                            $dl_link = site_url(\WPSURL\App\Utility::getPagesSlug(2) . '-download/' . $link->link_id . '/?ac=' . base64_encode($link->password));
                                        } else {
                                            $dl_link = site_url(\WPSURL\App\Utility::getPagesSlug(2) . '-download/' . $link->link_id);
                                        }
                                        ?>
                                        <input type="text" onclick="select();" value="<?php echo $dl_link; ?>" readonly/>
                                        <div class="link-field-options">
                                            <div class="link-copy wpsurl-button" title="<?php _e('Copy', WPSURL_TEXT_DOMAIN); ?>" data-wpsurl-link-type="download" data-wpsurl-link-id="<?php echo $link->link_id; ?>"><i class="wpsurl-icon-copy"></i></div>
                                            <a href="javascript:void(0)" title="<?php _e('Open link', WPSURL_TEXT_DOMAIN); ?>" target="_blank" class="link-open wpsurl-button" data-wpsurl-link-type="download" data-wpsurl-link-id="<?php echo $link->link_id; ?>"><i class="wpsurl-icon-external-link"></i></a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="link-option hash-link hash-link-<?php echo $link->link_id; ?>">
                                    <label for=""><?php _e('Key', WPSURL_TEXT_DOMAIN) ?></label>
                                    <input type="text" onclick="select();" value="<?php echo $link->link_key; ?>" readonly/>
                                    <div class="link-field-options">
                                        <div class="link-copy wpsurl-button" title="<?php _e('Copy', WPSURL_TEXT_DOMAIN); ?>" data-wpsurl-link-type="hash" data-wpsurl-link-id="<?php echo $link->link_id; ?>"><i class="wpsurl-icon-copy"></i></div>
                                    </div>
                                </div>
                                <div class="link-option short-code-link short-code-link-<?php echo $link->link_id; ?>">
                                    <label for=""><?php _e('Short code', WPSURL_TEXT_DOMAIN) ?></label>
                                    <input type="text" onclick="select();" value='[wpsurl id="<?php echo $link->link_id; ?>"]<?php echo $link->title; ?>[/wpsurl]' readonly/>
                                    <div class="link-field-options">
                                        <div class="link-copy wpsurl-button" title="<?php _e('Copy', WPSURL_TEXT_DOMAIN); ?>" data-wpsurl-link-type="short-code" data-wpsurl-link-id="<?php echo $link->link_id; ?>"><i class="wpsurl-icon-copy"></i></div>
                                    </div>
                                </div>
                                <div class="link-option php-code-link php-code-link-<?php echo $link->link_id; ?>">
                                    <label for=""><?php _e('Php code', WPSURL_TEXT_DOMAIN) ?></label>
                                    <input type="text" onclick="select();" value='&lt;?php echo do_shortcode(&#39;[wpsurl id=&#34;<?php echo $link->link_id; ?>&#34;]<?php echo $link->title; ?>[/wpsurl]&#39;) ?&gt;' readonly/>
                                </div>
                            </div>
                            <div class="link-counter">
                                <div class="link-views-count">
                                    <i class="wpsurl-icon-eye" title="<?php _e('Views Count', WPSURL_TEXT_DOMAIN) ?>"></i>
                                    <span><?php echo \WPSURL\App\Number::numByLang($link_views) ?></span>
                                    <?php if ($link_views > 0): ?>
                                        <a href="#" data-wpsurl-clear-type="views" data-wpsurl-link-id="<?php echo $link->link_id ?>" data-wpsurl-link-key="<?php echo $link->link_key ?>" class="clear-link-data"><?php _e('Clear', WPSURL_TEXT_DOMAIN) ?></a>
                                    <?php endif; ?>
                                </div>
                                <div class="link-clicks-count">
                                    <i class="wpsurl-icon-mouse-pointer" title="<?php _e('Clicks Count', WPSURL_TEXT_DOMAIN) ?>"></i>
                                    <span><?php echo \WPSURL\App\Number::numByLang($link_clicks) ?></span>
                                    <?php if ($link_clicks > 0): ?>
                                        <a href="#" data-wpsurl-clear-type="clicks" data-wpsurl-link-id="<?php echo $link->link_id ?>" data-wpsurl-link-key="<?php echo $link->link_key ?>" class="clear-link-data"><?php _e('Clear', WPSURL_TEXT_DOMAIN) ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php
                    endforeach;
                else: ?>
                    <div class="wpsurl-add-one-link">
                        <p><img src="<?php echo WPSURL_IMG_URL . 'logo.png'; ?>" alt="" style="width:100px;filter:grayscale(1);pointer-events:none"></p>
                        <p><?php _e('Create the first secure link', WPSURL_TEXT_DOMAIN) ?></p>
                        <p>
                            <a href="javascript:void(0)" class="wpsurl-add-new-link wpsurl-first-link">
                                <i class="wpsurl-icon-plus"></i>
                                <?php _e('Add New Link', WPSURL_TEXT_DOMAIN) ?>
                            </a>
                        </p>
                    </div>
                <?php
                endif;
                ?>
            </div>
            <div id="wpsurl-pagenavi" style="width: 100%;text-align: center;margin: 15px 0">
                <?php \WPSURL\App\Utility::renderPagination($per_page) ?>
            </div>
        </div>
    </form>
</div>
<?php
include_once(WPSURL_VIEW_ADMIN_PATH . 'new-link.php');