<?php
use WPSURL\App\Settings;
?>
<div class="wpsurl-page-option-header">
    <h3 class="wpsurl-title"><?php _e( 'Style and Elements control', WPSURL_TEXT_DOMAIN ) ?></h3>
</div>
<fieldset class="wpsurl-fieldset" style="display: none">
    <div class="wpsurl-field wpsurl-field--radio wpsurl-fieldset-group">
        <div class="wpsurl-radio">
            <input type="checkbox" name="use_elementor" value="1" class="checkbox-affected-reverse-toggle-elements" data-hide=".is-not-active-elementor" data-show=".is-active-elementor" id="use_elementor"<?php echo $use_elementor == true ? ' checked' : ''; ?>>
            <label for="use_elementor"><?php _e( 'Use Elementor', WPSURL_TEXT_DOMAIN ) ?></label>
        </div>
    </div>
</fieldset>
<fieldset class="wpsurl-fieldset is-active-elementor" style="display:<?php echo $use_elementor == true ? 'block' : 'none'; ?>">
    <div class="wpsurl-field wpsurl-field--radio wpsurl-fieldset-group">
        <label for="elementor_page"><?php _e( 'Custom Page', WPSURL_TEXT_DOMAIN ) ?></label>
        <select name="elementor_page" id="elementor_page" class="wpsurl-js-select">
            <option value="0"><?php _e( 'Select...', WPSURL_TEXT_DOMAIN ) ?></option>
            <?php
            $elementor = new \WPSURL\App\Elementor\ElementorBuilder();
            if($elementor->getTemplates()):
                foreach ($elementor->getTemplates() as $element):
                    if (strpos(strtolower($element->post_title), 'kit') !== false) continue;
                    ?>
                    <option <?php selected(Settings::getOption('elementor_page'), $element->ID) ?> value="<?php echo $element->ID ?>"><?php echo $element->post_title ?></option>
            <?php
                endforeach;
            endif;
            ?>
        </select>
    </div>
</fieldset>
<div class="is-not-active-elementor" style="display:<?php echo $use_elementor == true ? 'none' : 'block'; ?>">
    <fieldset class="wpsurl-fieldset">
        <div class="wpsurl-field--group wpsurl-fieldset-group">
            <div class="wpsurl-field wpsurl-fieldset--input-text">
                <label for="view_page_logo_url"><?php _e( 'Logo url', WPSURL_TEXT_DOMAIN ) ?></label>
                <input type="text" dir="ltr" name="view_page_logo_url" class="view_page_logo_url" id="view_page_logo_url" value="<?php echo ! empty( Settings::getOption( 'view_page_logo_url' ) ) ? Settings::getOption( 'view_page_logo_url' ) : WPSURL_IMG_URL . 'default-logo.png'; ?>">
                <button class="wpsurl-upload-button button" data-wpsurl-field="view_page_logo_url"><?php _e( 'Select Image' ); ?></button>
            </div>
        </div>
    </fieldset>
    <fieldset class="wpsurl-fieldset">
        <div class="wpsurl-field wpsurl-field--radio wpsurl-fieldset-group">
            <div class="wpsurl-radio">
                <input type="checkbox" name="links_title_status" value="true" id="links_title_status"<?php echo Settings::getOption( 'links_title_status' ) == true ? ' checked' : ''; ?>>
                <label for="links_title_status"><?php _e( 'Links title', WPSURL_TEXT_DOMAIN ) ?></label>
            </div>
            <div class="wpsurl-field-description"><?php _e( 'Show or not show', WPSURL_TEXT_DOMAIN ); ?></div>
        </div>
    </fieldset>
    <fieldset class="wpsurl-fieldset">
        <div class="wpsurl-field wpsurl-field--radio wpsurl-fieldset-group">
            <div class="wpsurl-radio">
                <input type="checkbox" name="view_timer_status" value="true" id="view_timer_status"<?php echo Settings::getOption( 'view_timer_status' ) == true ? ' checked' : ''; ?>>
                <label for="view_timer_status"><?php _e( 'Timer status', WPSURL_TEXT_DOMAIN ) ?></label>
            </div>
            <div class="wpsurl-field-description"><?php _e( 'Show or not show', WPSURL_TEXT_DOMAIN ); ?></div>
        </div>
    </fieldset>
    <fieldset class="wpsurl-fieldset">
        <div class="wpsurl-field wpsurl-field--radio wpsurl-fieldset-group">
            <div class="wpsurl-radio">
                <input type="checkbox" name="transfer_end_timer_status" value="true" id="transfer_end_timer_status"<?php echo Settings::getOption( 'transfer_end_timer_status' ) == true ? ' checked' : ''; ?>>
                <label for="transfer_end_timer_status"><?php _e( 'Transfer after the end of the timer', WPSURL_TEXT_DOMAIN ) ?></label>
            </div>
        </div>
    </fieldset>
    <fieldset class="wpsurl-fieldset">
        <div class="wpsurl-field--group wpsurl-fieldset-group">
            <div class="wpsurl-field wpsurl-fieldset--input-text">
                <label for="view_timer_second_value"><?php _e( 'Timer time', WPSURL_TEXT_DOMAIN ) ?></label>
                <input type="number" min="5" name="view_timer_second_value" id="view_timer_second_value" value="<?php echo ! empty( Settings::getOption( 'view_timer_second_value' ) ) ? Settings::getOption( 'view_timer_second_value' ) : 5; ?>">
                <label for="view_timer_second_value"><?php _e( 'Seconds', WPSURL_TEXT_DOMAIN ) ?></label>
            </div>
        </div>
    </fieldset>
    <fieldset class="wpsurl-fieldset">
        <div class="wpsurl-field wpsurl-field--group wpsurl-fieldset-group">
            <label for=""><?php _e( 'Add html code', WPSURL_TEXT_DOMAIN ) ?></label>
            <textarea name="view_add_html_code" id="view_add_html_code" class="html-editor"><?php echo \WPSURL\App\Utility::unslashHtml( Settings::getOption( 'view_add_html_code' ) ) ?></textarea>
        </div>
    </fieldset>
</div>
<div class="wpsurl-page-option-header">
    <h3 class="wpsurl-title"><?php _e( 'Actions', WPSURL_TEXT_DOMAIN ) ?></h3>
</div>
<fieldset class="wpsurl-fieldset">
    <div class="wpsurl-field--group wpsurl-fieldset-group">
        <div class="wpsurl-field wpsurl-fieldset--input-text">
            <label for="redirect_page_slug"><?php _e( 'Redirect page slug', WPSURL_TEXT_DOMAIN ) ?></label>
            <input type="text" dir="ltr" name="redirect_page_slug" id="redirect_page_slug" value="<?php echo ! empty( Settings::getOption( 'redirect_page_slug' ) ) ? Settings::getOption( 'redirect_page_slug' ) : 'safe-url'; ?>" autocomplete="off" onkeyup="rewrite_input_fetch('redirect_page_slug')">
        </div>
    </div>
</fieldset>
<fieldset class="wpsurl-fieldset">
    <div class="wpsurl-field--group wpsurl-fieldset-group">
        <div class="wpsurl-field wpsurl-fieldset--input-text">
            <label for="redirect_page_short_slug"><?php _e( 'Redirect page short slug', WPSURL_TEXT_DOMAIN ) ?></label>
            <input type="text" dir="ltr" name="redirect_page_short_slug" id="redirect_page_short_slug" value="<?php echo ! empty( Settings::getOption( 'redirect_page_short_slug' ) ) ? Settings::getOption( 'redirect_page_short_slug' ) : 'surl'; ?>" autocomplete="off" onkeyup="rewrite_input_fetch('redirect_page_short_slug')">
        </div>
    </div>
</fieldset>
<fieldset class="wpsurl-fieldset">
    <div class="wpsurl-field wpsurl-field--radio wpsurl-fieldset-group">
        <div class="wpsurl-radio">
            <input type="checkbox" name="view_redirect_page_status" value="true" id="view_redirect_page_status"<?php echo Settings::getOption( 'view_redirect_page_status' ) == true ? ' checked' : ''; ?>>
            <label for="view_redirect_page_status"><?php _e( 'Redirect page', WPSURL_TEXT_DOMAIN ) ?></label>
        </div>
        <div class="wpsurl-field-description"><?php _e( 'Activate direct transfer', WPSURL_TEXT_DOMAIN ) ?></div>
        <div class="wpsurl-field-description"><?php #_e( 'Ignored: Transfer page (direct transfer to main link), passwords, only woocommerce customers, click report', WPSURL_TEXT_DOMAIN ) ?></div>
    </div>
</fieldset>
<fieldset class="wpsurl-fieldset">
    <div class="wpsurl-field wpsurl-field--radio wpsurl-fieldset-group">
        <div class="wpsurl-radio">
            <input type="checkbox" name="view_only_logged_users" value="true" id="view_only_logged_users"<?php echo Settings::getOption( 'view_only_logged_users' ) == true ? ' checked' : ''; ?>>
            <label for="view_only_logged_users"><?php _e( 'Restriction', WPSURL_TEXT_DOMAIN ) ?></label>
        </div>
        <div class="wpsurl-field-description"><?php _e( 'Only the logged-in user will have access to the links', WPSURL_TEXT_DOMAIN ); ?></div>
    </div>
</fieldset>
<fieldset class="wpsurl-fieldset">
    <div class="wpsurl-field wpsurl-field--radio wpsurl-fieldset-group">
        <div class="wpsurl-radio">
            <input type="checkbox" name="show_other_previews" value="true" id="show_other_previews"<?php echo Settings::getOption( 'show_other_previews' ) == true ? ' checked' : ''; ?>>
            <label for="show_other_previews"><?php _e( 'Show other previews in iframe', WPSURL_TEXT_DOMAIN ) ?></label>
        </div>
    </div>
</fieldset>