<?php
namespace WPSURL\App;

use WPSURL\App\User\User;
use WPSURL\App\User\UserData;

class Ajax {
    public static function viewRedirectButton() {
        $link_token = $_POST['link_token'];
        $link = Links::get($link_token);
        if ($link) {
            $pwd     = $link->password;
            $type    = $link->type;
            $link_id = $link->link_id;
            if ( \WPSURL\App\Options::isActiveWoo() ) {
                if ( $type == '3' && ! \WPSURL\App\Woocommerce::isUserCustomer() ) {
                    $result = array(
                        'msg'  => __( 'Sorry, this link is for customers', WPSURL_TEXT_DOMAIN ),
                        'type' => 'error',
                        'lock' => true
                    );
                    wp_send_json( $result );
                }
            }
            if ( empty( $pwd ) || $pwd == '' ) {
                $download = null;
                if ( $type == 2 ) {
                    $download = site_url( \WPSURL\App\Utility::getPagesSlug( 2 ) . '-download/' . $link_token );
                }
                $result        = array(
                    'msg'       => __( 'Redirecting ...', WPSURL_TEXT_DOMAIN ),
                    'type'      => 'success',
                    'link'      => $link->link,
                    'link_type' => (integer) $type,
                    'download'  => $download,
                    'lock'      => false
                );
                $insert_report = Statistics::incrementView($link_id);
                if (Statistics::isExistsIP($link_id)) {
                    Statistics::incrementClick( $link_id );
                }
            } else {
                $result = array(
                    'msg'  => __( 'Link is locked, reload...', WPSURL_TEXT_DOMAIN ),
                    'type' => 'error',
                    'lock' => true
                );
            }
        } else {
            $result = array(
                'msg'  => __( 'Link Not Found', WPSURL_TEXT_DOMAIN ),
                'type' => 'error',
                'lock' => false
            );
        }
        wp_send_json( $result );
    }
    
    public static function openLinkByPassword() {
        $link_token = $_POST['link_token'];
        $pwd        = $_POST['password'];
        $link = Links::get($link_token);
        if ( $link && ! empty( $pwd ) && ! empty( $link_token ) ) {
            $link_pass = $link->password;
            $type      = $link->type;
            $link_id   = $link->link_id;

            if ( \WPSURL\App\Options::isActiveWoo() ) {
                if (LinkOptions::isRestrictByWoo($link_id)) {
                    if(!\WPSURL\App\Woocommerce::isUserCustomer()){
                        $result = array(
                            'msg'  => __( 'Sorry, this link is for customers', WPSURL_TEXT_DOMAIN ),
                            'type' => 'error',
                            'lock' => true
                        );
                        wp_send_json( $result );
                    }
                }
            }
            if ( \WPSURL\App\Options::isActiveWoo() ) {
                if(LinkOptions::isRestrictByEdd($link_id)){
                    if(!Edd::isUserCustomerProducts()){
                        $result = array(
                            'msg'  => __( 'Sorry, this link is for customers', WPSURL_TEXT_DOMAIN ),
                            'type' => 'error',
                            'lock' => true
                        );
                        wp_send_json( $result );
                    }
                }
            }

            if ( \WPSURL\App\Utility::isEqualPassword( md5( $pwd ), $link_pass ) ) {
                $download = null;
                if ( $type == 2 ) {
                    $download = site_url( \WPSURL\App\Utility::getPagesSlug( 2 ) . '-download/' . $link_token . '/?ac=' . base64_encode( md5( $pwd ) ) );
                }
                $result        = array(
                    'msg'       => __( 'Done, wait...', WPSURL_TEXT_DOMAIN ),
                    'type'      => 'success',
                    'link'      => $link->link,
                    'link_type' => (integer) $type,
                    'download'  => $download
                );
                $insert_report = Statistics::incrementView($link_id);
                if (Statistics::isExistsIP($link_id)) {
                    Statistics::incrementClick($link_id);
                }
                wp_send_json($result);
            } else {
                wp_send_json(array(
                    'msg'  => __( 'Invalid values entered', WPSURL_TEXT_DOMAIN ),
                    'type' => 'error'
                ));
            }

        } else {
            $result = array(
                'msg'  => __( 'Please enter the value', WPSURL_TEXT_DOMAIN ),
                'type' => 'error'
            );
        }
        wp_send_json($result);
    }
    
    public static function reportLinkProblem() {
        $link_data = Links::get( $_POST['link_token'] );
        if ( $link_data ) {
            $mailer = new Mailer();
            $link_id = $link_data->link_id;
            $content       = '<div class="link-title">' . $link_data->title . '</div><br>';
            $link          = \WPSURL\App\Utility::getHashLink( $link_id, 'surl' );
            $content       .= '<div class="link"><a href="' . $link . '">' . $link . '</a></div><br>';
            $report_text   = str_replace( PHP_EOL, '<br>', $_POST['description'] );
            $content       .= '<div class="report-des">' . $_POST['email'] . '</div><br>';
            $content       .= '<div class="report-des">' . $report_text . '</div><br>';
            $email_title   = sprintf( __( 'Link report problem %s', WPSURL_TEXT_DOMAIN ), $link_id );
            $mailer->setToAdmin()->setEmailTemplate($email_title, $content);
            $insert = Reports::insert($link_id, [
                'user_id' => UserData::getCurrentUserID(),
                'fullname' => $_POST['fullname'] ?? '',
                'email' => $_POST['email'],
                'content' => $_POST['description'],
            ]);
            if ($insert) {
                $result = array(
                    'type' => 'success',
                    'msg'  => __( 'Thank you for your cooperation, the link report will be registered and will be resolved as soon as possible', WPSURL_TEXT_DOMAIN )
                );
                $send = $mailer->send();
            } else {
                $result = array(
                    'type' => 'error',
                    'msg'  => __( 'An error occurred, please try again', WPSURL_TEXT_DOMAIN )
                );
            }
        } else {
            $result = array(
                'type' => 'error',
                'msg'  => __( 'Link Not Found', WPSURL_TEXT_DOMAIN )
            );
        }
        wp_send_json( $result );
    }
}