<?php
namespace WPSURL\App;
class LinkOptions {
    use \WPSURL\App\Traits\Singleton;

    use \WPSURL\App\Traits\Database\Connection;
    public static function addOption($link_id, $option, $value){
        return self::getDb()->options()->insert([
            'link_id' => $link_id,
            'link_option' => $option,
            'link_option_value' => $value
        ]);
    }

    public static function updateOption($link_id, $option, $value){
        if(self::isExistsOption($link_id, $option)){
            return self::getDb()->options()->update([
                'link_option_value' => $value
            ], [
                'link_id' => $link_id,
                'link_option' => $option,
            ]);
        } else {
            return self::addOption($link_id, $option, $value);
        }
    }

    public static function deleteOption($link_id, $option){
        return self::getDb()->options()->delete([
            'link_id' => $link_id,
            'link_option' => $option,
        ]);
    }

    public static function getOption($link_id, $option){
        $option = self::getDb()->options()->get([
            'link_id' => $link_id,
            'link_option' => $option,
        ]);

        return $option && is_object($option) ? $option->link_option_value : false;
    }

    public static function isExistsOption($link_id, $option){
        $option = self::getDb()->options()->get([
            'link_id' => $link_id,
            'link_option' => $option,
        ]);

        return $option && is_object($option);
    }

    public static function deleteOptions($link_id){
        return self::getDb()->options()->delete(['link_id' => $link_id]);
    }

    public static function getOptions($link_id){
        return self::getDb()->options()->getResults([
            'fields' => [
                'link_id' => $link_id
            ]
        ]);
    }

    public static function isRestrictByView($link_id){
        return self::getOption($link_id, 'view_restrictions_status') == 'true';
    }

    public static function isRestrictByWoo($link_id){
        return Options::isActiveWoo() && self::getOption($link_id, 'restriction_woo') == 'true';
    }

    public static function isRestrictByEdd($link_id){
        return Options::isActiveEdd() && self::getOption($link_id, 'restriction_edd') == 'true';
    }

    public static function isAccessForProducts($link_id){
        return self::getOption($link_id, 'woo_products');
    }

    public static function isAccessForEddProducts($link_id){
        return self::getOption($link_id, 'edd_products');
    }

    public static function getClickLimitNumber($link_id){
        return self::getOption($link_id, 'click_limited_num');
    }

    public static function getViewLimitNumber($link_id){
        return self::getOption($link_id, 'click_limited_num');
    }

    public static function getClicksCount($link_id){
        return self::getOption($link_id, 'clicks_count');
    }

    public static function getViewsCount($link_id){
        return self::getOption($link_id, 'views_count');
    }

    public static function isOnlyLoggedUser($link_id){
        return self::getOption($link_id, 'only_user_logged') == 'true';
    }

    public static function isIframePreview($link_id){
        return self::getOption($link_id, 'iframe_preview') == 'true';
    }

    public static function isVerifyPassword($link_id, $user_password){
        $link = Links::get($link_id);
        return $link && $link->password === $user_password;
    }
}