<?php
namespace WPSURL\App;
/**
 * Exit if accessed directly
 */
if (!defined('ABSPATH')) {
    exit;
}

class Logger {
    /**
     * Clean logs
     *
     * @return void
     */
    public static function clean(){
        file_put_contents(WPSURL_PATH . 'logs.json', '');
    }
    
    /**
     * Logger
     *
     * @param array $message
     * @return void
     */
    public static function log(array $message){
        file_put_contents(WPSURL_PATH . 'logs.json', json_encode($message) . PHP_EOL, FILE_APPEND);
    }
}