<?php
namespace WPSURL\App;

use WPSURL\App\Database;

class Reports {

    use \WPSURL\App\Traits\Database\Connection;

    public static function getResults($params){
        return self::getDb()->reports()->getResults($params);
    }
    public static function insert($link_id, $fields)
    {
        return intval($link_id) ? self::getDb()->reports()->insert(array_merge(['link_id' => $link_id], $fields)) : false;
    }

    public static function update($id, $fields)
    {
        return self::getDb()->reports()->update($fields, ['id' => $id]);
    }

    public static function truncate($link_id)
    {
        return self::getDb()->reports()->delete(['link_id' => $link_id]);
    }
}