<?php
namespace WPSURL\App;

class Shortcode {
    /**
     *
     * get safe url html button by short code
     *
     * @param $atts
     * @param null $content
     *
     * @return string
     */
    public static function buttonShortcodeCallback($atts, $content = null)
    {
        $atts = shortcode_atts(
            array(
                'id' => ''
            ),
            $atts
        );
        if (!empty($atts['id']) && !empty($content)) {
            if (wpsurl_is_exists_link_id($atts['id'])) {
                $link = wpsurl_get_link_item_by_id($atts['id'], 'link_id');
                $link = \WPSURL\App\Utility::getShortHashLink($link);
                $status = wpsurl_get_link_status($atts['id']);
                $type = wpsurl_get_link_type($atts['id']);
                $pwd = wpsurl_get_link_item($atts['id'], 'password');
                $cls = '';
                if ($status == 'active') {
                    if (!\WPSURL\App\Options::isViewOnlyLoggedUser()) {
                        if (!empty($pwd) || $pwd != null || $pwd != '') {
                            $cls .= ' locked';
                        }
                        if ($type == '2') {
                            $cls .= ' download';
                        } elseif ($type == '3') {
                            $cls .= ' customers';
                        }
                        $text = $content;
                    } else {
                        $text = __('Log in to access this link', WPSURL_TEXT_DOMAIN);
                        $link = wp_login_url(get_permalink());
                    }

                    return '<a href="' . $link . '" target="_blank" class="wpsurl-button wpsurl-redirect-button' . $cls . '">' . $text . '</a>';
                }
            }
        }
    }
}