<?php
namespace WPSURL\App;
class Statistics extends Database {
    private static $wpdb;

    private static $table;

    use \WPSURL\App\Traits\Database\Connection;

    public function __construct()
    {
        global $wpdb;
        self::$wpdb = $wpdb;
        self::$table = $wpdb->_prefix . 'links_statistics';
    }

    public static function getResults($params){
        return self::getDb()->statistics()->getResults($params);
    }

    public static function insert($link_id)
    {
        $ip = \WPSURL\App\Utility::getVisitorIP();
        $link = Links::get($link_id);
        if($link){
            return self::getDb()->statistics()->insert([
                'link_id' => $link_id,
                'link_key' => $link->link_key,
                'ip' => $ip,
                'visit' => 1
            ]);
        }
        return false;
    }

    public static function update($link_id, $fields)
    {
        if(Links::get($link_id)){
            return self::getDb()->statistics()->update($fields, ['link_id' => $link_id]);
        }
        return false;
    }

    public static function updateOption($link_id, $option, $value)
    {
        return self::update($link_id, [$option => $value]);
    }

    public static function incrementView($link_id)
    {
        global $wpdb;
        $ip = \WPSURL\App\Utility::getVisitorIP();
        $views = self::getViews($link_id);
        LinkOptions::updateOption($link_id, 'views_count', $views + 1);
        $table = Database::$table_statistics;
        if(self::isExistsIP($link_id, $ip)){
            return $wpdb->query($wpdb->prepare("UPDATE `{$table}` SET visit = visit + 1, last_visit = %s WHERE link_id = %d AND ip = %s", current_time('mysql'), $link_id, $ip));
        } else {
            return self::insert($link_id);
        }
    }
    
    public static function incrementClick($link_id)
    {
        global $wpdb;
        $ip = \WPSURL\App\Utility::getVisitorIP();
        $views = self::getViews($link_id);
        LinkOptions::updateOption($link_id, 'clicks_count', $views + 1);
        $table = Database::$table_statistics;
        if(self::isExistsIP($link_id, $ip)){
            return $wpdb->query($wpdb->prepare("UPDATE `{$table}` SET click = click + 1 WHERE link_id = %d AND ip = %s", $link_id, $ip));
        } else {
            return self::insert($link_id);
        }
    }

    public static function decrementView($link_id)
    {
        global $wpdb;
        $ip = \WPSURL\App\Utility::getVisitorIP();
        $views = self::getViews($link_id);
        LinkOptions::updateOption($link_id, 'views_count', $views - 1);
        $table = Database::$table_statistics;
        if(self::isExistsIP($link_id, $ip)){
            return $wpdb->query($wpdb->prepare("UPDATE `{$table}` SET visit = visit - 1 WHERE link_id = %d AND ip = %s", $link_id, $ip));
        } else {
            return self::insert($link_id);
        }
    }
    
    public static function decrementClick($link_id)
    {
        global $wpdb;
        $ip = \WPSURL\App\Utility::getVisitorIP();
        $views = self::getViews($link_id);
        LinkOptions::updateOption($link_id, 'clicks_count', $views - 1);
        $table = Database::$table_statistics;
        if(self::isExistsIP($link_id, $ip)){
            return $wpdb->query($wpdb->prepare("UPDATE `{$table}` SET click = click - 1 WHERE link_id = %d AND ip = %s", $link_id, $ip));
        } else {
            return self::insert($link_id);
        }
    }

    public static function getViews($link_id)
    {
        $views = (int) LinkOptions::getOption($link_id, 'views_count');
        return $views > 0 ? $views : 0;
    }

    public static function getClicks($link_id)
    {
        $clicks = (int) LinkOptions::getOption($link_id, 'clicks_count');
        return $clicks > 0 ? $clicks : 0;
    }

    public static function isExistsIP($link_id, $ip = ''){
        return self::getDb()->statistics()->get(['link_id' => $link_id, 'ip' => $ip]);
    }

    public static function truncate($link_id)
    {
        return self::getDb()->statistics()->delete(['link_id' => $link_id]);
    }
}