<?php
namespace WPSURL\App;
/*
 *  wp gallery attachment custom fields
 *
 */

class WPGallery
{
    use \WPSURL\App\Traits\Singleton;

    function __construct()
    {
        add_filter('attachment_fields_to_edit', array($this, 'applyFilter'), 11, 2);
        //add_filter('attachment_fields_to_save', array($this, 'saveFields'), 11, 2);
    }

    protected function attachment_link($post)
    {
        global $wpsurl_loops;
        $field = array(
            'label' => __('Attachment safe url', WPSURL_TEXT_DOMAIN),
            'input' => 'html',
            'required' => true,
            'html' => '',
        );
        $links = $wpsurl_loops->links_by('link', wp_get_attachment_url($post->ID));
        if ($links) {
            if (is_array($links) || is_object($links)) {
                foreach ($links as $link) {
                    $field['html'] = '<input type="text" dir="ltr" value="' . \WPSURL\App\Utility::getHashLink($link->link) . '" onclick="select();" id="safe-url-attachment-links-' . $post->ID . '" readonly/>';
                    $field['html'] .= '<label>' . __('Short link', WPSURL_TEXT_DOMAIN) . '</label>';
                    $field['html'] .= '<input type="text" dir="ltr" value="' . \WPSURL\App\Utility::getHashLink($link->link_id, 'surl') . '" id="short-url-attachment-links-' . $post->ID . '" onclick="select();" readonly/>';
                    $field['html'] .= '<label>' . __('Download link', WPSURL_TEXT_DOMAIN) . '</label>';
                    $slug = \WPSURL\App\Utility::getPagesSlug(2);
                    if (!empty($link->password) || $link->password != null || $link->password != '') {
                        $dl_link = site_url($slug . '-download/' . $link->link_id . '/?ac=' . base64_encode($link->password));
                    } else {
                        $dl_link = site_url($slug . '-download/' . $link->link_id);
                    }
                    if ($link->type == 2)
                        $field['html'] .= '<input type="text" dir="ltr" value="' . $dl_link . '" id="dl-url-attachment-links-' . $post->ID . '" onclick="select();" readonly/>';
                }
            }
        } else {
            $field['html'] = '<input type="text" value="is empty" id="safe-url-attachment-links-' . $post->ID . '" readonly/>';
        }

        return $field;
    }

    protected function fields($post)
    {
        global $wpsurl_loops;
        $links = $wpsurl_loops->links_by('link', wp_get_attachment_url($post->ID));
        $attachment_meta = wp_get_attachment_metadata($post->ID);
        if (!$links) {
            $fields = array(
                'safe_url_title' => array(
                    'label' => __('Title', WPSURL_TEXT_DOMAIN),
                    'input' => 'html',
                    'required' => true,
                    'html' => '<input type="text" id="safe-url-title-' . $post->ID . '" value="' . get_the_title($post->ID) . '" data-wpsurl-id="' . $post->ID . '"/>',
                ),
                'safe_url_link' => array(
                    'label' => __('Link', WPSURL_TEXT_DOMAIN),
                    'input' => 'html',
                    'required' => true,
                    'html' => '<input type="url" id="safe-url-link-' . $post->ID . '" data-wpsurl-id="' . $post->ID . '" value="' . wp_get_attachment_url($post->ID) . '" readonly/>',
                    'helps' => __('unchangeable', WPSURL_TEXT_DOMAIN)
                ),
                'safe_url_password' => array(
                    'label' => __('Password', WPSURL_TEXT_DOMAIN),
                    'input' => 'html',
                    'html' => '<input type="text" id="safe-url-password-' . $post->ID . '" data-wpsurl-id="' . $post->ID . '"/>',
                    'helps' => __('It can be empty', WPSURL_TEXT_DOMAIN)
                ),
                'safe_url_options' => array(
                    'label' => __('Type', WPSURL_TEXT_DOMAIN),
                    'input' => 'html',
                    'required' => true,
                    'html' => '',
                ),
                'safe_url_button' => array(
                    'label' => __('Safe Url', WPSURL_TEXT_DOMAIN),
                    'input' => 'html',
                    'html' => '<button class="button wpsurl-safe-attachment" data-wpsurl-id="' . $post->ID . '">' . __('Create Safe Url', WPSURL_TEXT_DOMAIN) . '</button>',
                ),
            );

            $fields['safe_url_options']['html'] = '<select id="safe-url-type-' . $post->ID . '" data-wpsurl-id="' . $post->ID . '">';
            $fields['safe_url_options']['html'] .= '<option value="">' . __('Select Type...', WPSURL_TEXT_DOMAIN) . '</option>';
            $fields['safe_url_options']['html'] .= '<option value="1">' . __('Website url', WPSURL_TEXT_DOMAIN) . '</option>';
            //$fields['safe_url_options']['html'] .= '<option value="2">' . __('Download url', WPSURL_TEXT_DOMAIN) . '</option>';
            if (\WPSURL\App\Options::is_active_woocommerce())
                $fields['safe_url_options']['html'] .= '<option value="3">' . __('Use only woo customers', WPSURL_TEXT_DOMAIN) . '</option>';
            $fields['safe_url_options']['html'] .= '</select>';
        } else {
            $fields = array(
                'safe_url_attachment_is_exists' => array(
                    'input' => 'html',
                    'html' => __('Link is exists', WPSURL_TEXT_DOMAIN),
                ),
                'safe_url_attachment_actions' => array(
                    'input' => 'html',
                    'html' => '',
                ),
            );
            if (!empty($links)) {
                foreach ($links as $link) {
                    $link_id = $link->link_id;
                    $link_key = $link->link_key;
                    $link_password = $link->password;
                    $link_status = $link->status;
                }
            }
            $status_color = $link_status == 'active' ? 'active' : 'inactive';
            $lock_color = !empty($link_password) || $link_password != null || $link_password != '' ? 'active' : 'inactive';
            $lock_type = !empty($link_password) || $link_password != null || $link_password != '' ? 'true' : 'false';
            $fields['safe_url_attachment_actions']['html'] = '<a href="javascript:void();" class="wpsurl-button button link-status link-status-option-color ' . $status_color . '" data-wpsurl-link-id="' . $link_id . '" data-wpsurl-link-key="' . $link_key . '"><i class="wpsurl-icon-link"></i></a>';
            $fields['safe_url_attachment_actions']['html'] .= '<a href="javascript:void();" class="wpsurl-button button link-delete" data-wpsurl-link-id="' . $link_id . '" data-wpsurl-link-key="' . $link_key . '"><i class="wpsurl-icon-trash"></i></a>';
            $fields['safe_url_attachment_actions']['html'] .= '<a href="javascript:void();" class="wpsurl-button button link-lock link-status-option-color ' . $lock_color . '" data-wpsurl-link-id="' . $link_id . '" data-wpsurl-link-key="' . $link_key . '" data-wpsurl-link-locked="' . $lock_type . '"><i class="wpsurl-icon-lock"></i></a>';

            $fields['safe_url_attachment_links'] = $this->attachment_link($post);
        }
        return $fields;
    }

    public function applyFilter($form_fields, $post = null)
    {
        $form_fields = $this->fields($post);
        return $form_fields;
    }

    /*function saveFields($post, $attachment)
    {
    }*/
}

