<?php
namespace WPSURL\App\Elementor;

use Elementor\Core\Files\CSS\Post as Post_CSS;
class ElementorBuilder extends Elementor
{
    protected $content_id;
    private $getInstance;

    public function __construct()
    {
        $this->getInstance = parent::instance();
    }

    /**
     *
     * Get elementor templates by post type
     *
     * @param $post_type
     * @return mixed
     */
    public function getTemplates($post_type = 'elementor_library'){
        return get_posts(['post_type' => $post_type]);
    }

    /**
     *
     * Set content id for build
     *
     * @param $content_id
     */
    public function setContentID($content_id){
        $this->content_id = $content_id;
        return $this;
    }

    /**
     * 
     * Get content id
     * 
     * @return int
     */
    public function getContentID()
    {
        return $this->content_id;
    }

    /**
     * Get content translation id
     *
     * @return int
     */
    public function getContentTranslationID(){
        return \WPSURL\App\Utility::getContentTranslationID($this->content_id);
    }

    /**
     *
     * Build custom element content
     *
     */
    public function build($with_css = false, $return_in_ajax = false){
        if(!$return_in_ajax && wp_doing_ajax()) return false;
        return $this->getInstance->frontend->get_builder_content($this->getContentTranslationID(), $with_css);
    }

    /**
     *
     * Build and display element content (with restore edit mode state)
     *
     */
    public function display($with_css = false, $return_in_ajax = false){
        if(!$return_in_ajax && wp_doing_ajax()) return false;
        return $this->getInstance->frontend->get_builder_content_for_display($this->getContentTranslationID(), $with_css);
    }

    /**
     * Print element inline css
     *
     * @return void
     */
    public function printCss(){
        if(!empty($this->getContentTranslationID()) && intval($this->getContentTranslationID()) && get_post_status($this->getContentTranslationID())){
            $css_file = new Post_CSS($this->getContentTranslationID());
			$css_file->print_css();
		}
    }

    /**
     *
     * Check is elementor preview page (preview is backend)
     *
     * @return mixed
     */
    public static function isPreviewMode(){
        # $this->getInstance->preview->is_preview_mode();
        return isset($_REQUEST['action']) && strpos($_REQUEST['action'], 'elementor') !== false;
    }
}
