<?php
namespace WPSURL\App\Elementor\Widgets;

use Elementor\Controls_Manager;
use WPSURL\App\Assets;
use WPSURL\App\Elementor\ElementorBuilder;
use WPSURL\App\GlobalData;
use WPSURL\App\Links;
use WPSURL\App\Settings;
use WPSURL\App\Utility;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class RedirectButton extends \Elementor\Widget_Base
{
    public function __construct($data=[], $args=[])
    {
        parent::__construct($data, $args);
        Assets::registerStyle('wpsurl.assets.css', WPSURL_CSS_URL . 'assets.css', null, WPSURL_VERSION);
        Assets::registerStyle('wpsurl.ui.css', WPSURL_CSS_URL . 'ui.css', null, WPSURL_VERSION);
    }

    public function get_style_depends()
    {
        return [Assets::getHandleName('wpsurl.assets.css'), Assets::getHandleName('wpsurl.ui.css')];
    }

    public function get_name()
    {
        return 'wpsurl_redirect_button';
    }

    public function get_title()
    {
        return esc_html__('Redirect Button', WPSURL_TEXT_DOMAIN);
    }

    public function get_icon() {
        return 'eicon-button';
    }

    public function get_categories() {
        return ['wpsurl_elements'];
    }

    public function get_keywords()
    {
        return ['redirect_button', 'redirectbutton', esc_html__('Redirect Button' , WPSURL_TEXT_DOMAIN)];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_styles',
            [
                'label' => esc_html__('Content', WPSURL_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $alignment = [
            'left' => [
                'title' => __('Left', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-left'
            ],
            'center' => [
                'title' => __('Center', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-center'
            ],
            'right' => [
                'title' => __('Right', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-right'
            ]
        ];

        $this->add_responsive_control(
            'box_text_alignment',
            [
                'label' => esc_html__('Alignment', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $alignment : array_reverse($alignment),
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-page-title-element' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__('Text color', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-page-title-element a' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'box_content_typo',
                'selector' => '{{WRAPPER}} .wpsurl-page-title-element a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '18'
                        ]
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_bg',
                'label' => esc_html__('Background', WPSURL_TEXT_DOMAIN),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .wpsurl-page-title-element',
            ]
        );

        $this->add_responsive_control(
            'box_border_radius',
            [
                'label' => esc_html__('Border Radius', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-page-title-element' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => esc_html__('Padding', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-page-title-element' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'label' => esc_html__('Border', WPSURL_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .wpsurl-page-title-element',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_wrap_shadow',
                'label' => esc_html__('Box Shadow', WPSURL_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .wpsurl-page-title-element',
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $is_preview = ElementorBuilder::isPreviewMode();
        $val = Utility::getQueryVarsValue();
        $link_data = Links::get($val);
        $extra = $link_data ? GlobalData::loadedExtraLinkData($link_data->link_id) : false;
        $timer_status = !$is_preview ? Settings::getOption( 'view_timer_status' ) : true;
        $time = Settings::getOption( 'view_timer_second_value' );
        $transfer_status = Settings::getOption('transfer_end_timer_status');
        $btn_cls = 'button';
        if(is_object($extra) && isset($extra->pwd)){
            $btn_cls = (empty($extra->pwd) || $extra->pwd == '') ? 'button' : 'by-pass';
        }
        $type = Links::getType($val);
        ?>
        <div class="wpsurl-redirect-button-element wpsurl-redirect-button-element-<?php echo $wid; ?>">
            <div class="wpsurl-view-buttons wpsurl-buttons" style="display:<?php echo ( ! $timer_status ) ? 'none' : 'block' ?>">
                <?php if ($transfer_status): ?>
                    <p><?php echo sprintf(__('If the transfer does not take place after %d seconds, click on this button', WPSURL_TEXT_DOMAIN), $time) ?></p>
                <?php endif; ?>
                <a href="javascript:void(0)" data-wpsurl-link-type="<?php echo $type ?>" data-wpsurl-link-token="<?php echo Utility::getQueryVarsValue() ?>" class="wpsurl-button wpsurl-transfer-button wpsurl-redirect-<?php echo $btn_cls ?><?php echo (!Settings::getOption('view_timer_status')) ? ' wpsurl-button-disable' : ''; ?>">
                    <?php if ($type == 1): ?>
                        <i class="wpsurl-icon-external-link-square"></i>
                        <?php _e('Click to transfer', WPSURL_TEXT_DOMAIN) ?>
                    <?php else: ?>
                        <i class="wpsurl-icon-download"></i>
                        <?php _e('Download file', WPSURL_TEXT_DOMAIN) ?>
                    <?php endif; ?>
                </a>
            </div>
        </div>
        <?php
    }
}