<?php
namespace WPSURL\App\Elementor\Widgets;

use Elementor\Controls_Manager;
use WPSURL\App\Assets;
use WPSURL\App\Elementor\ElementorBuilder;
use WPSURL\App\GlobalData;
use WPSURL\App\Links;
use WPSURL\App\Settings;
use WPSURL\App\Utility;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class Timer extends \Elementor\Widget_Base
{
    public function __construct($data=[], $args=[])
    {
        parent::__construct($data, $args);
        Assets::registerStyle('wpsurl.assets.css', WPSURL_CSS_URL . 'assets.css', null, WPSURL_VERSION);
        Assets::registerStyle('wpsurl.ui.css', WPSURL_CSS_URL . 'ui.css', null, WPSURL_VERSION);

        Assets::registerScript('wpsurl.countdown.js', WPSURL_JS_URL . 'countdown.js', null, WPSURL_VERSION, true);
        wp_localize_script(Assets::getHandleName('wpsurl.countdown.js'), 'wpsurl_data', Assets::getLocalizeData());
    }

    public function get_style_depends()
    {
        return [Assets::getHandleName('wpsurl.assets.css'), Assets::getHandleName('wpsurl.ui.css')];
    }

    public function get_script_depends()
    {
        return [Assets::getHandleName('wpsurl.countdown.js')];
    }

    public function get_name()
    {
        return 'wpsurl_timer';
    }

    public function get_title()
    {
        return esc_html__('Timer', WPSURL_TEXT_DOMAIN);
    }

    public function get_icon() {
        return 'eicon-countdown';
    }

    public function get_categories() {
        return ['wpsurl_elements'];
    }

    public function get_keywords()
    {
        return ['timer', esc_html__('Timer' , WPSURL_TEXT_DOMAIN)];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_styles',
            [
                'label' => esc_html__('Content', WPSURL_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $is_preview = ElementorBuilder::isPreviewMode();
        $timer_status = !$is_preview ? Settings::getOption( 'view_timer_status' ) : true;
        $time = Settings::getOption( 'view_timer_second_value' );
        ?>
        <div class="wpsurl-timer-element wpsurl-timer-element-<?php echo $wid; ?>">
            <?php if ( ! $timer_status ): ?>
                <div class="wpsurl-timer-container">
                    <div id="timer-app" data-time="<?php echo ($time >= 5) ? $time : '5'; ?>"></div>
                </div>
            <?php endif; ?>
        </div>
        <?php
    }
}