documentReady(function () {
    var body = $('body');

    $('.wpsurl-header-nav > a').click(function (e) {
        e.preventDefault();
        let navWrap = $('.wpsurl-header-nav');
        let tabsWrap = $('.wpsurl-content');
        let currentLink = $(this);
        let currentTabID = currentLink.attr('href');
        let currentTab = $(currentTabID);
        navWrap.find('.wpsurl-menu-item').removeClass('is-active');
        currentLink.addClass('is-active');
        tabsWrap.find('.wpsurl-tab-content').hide();
        currentTab.show();
    });

    body.on("click", ".wpsurl-parent-close", function (e) {
        e.preventDefault();
        let $this = $(this);
        $this.parent().slideUp();
    });

    body.on("click", ".wpsurl-link-open-more", function (e) {
        e.preventDefault();
        let $this = $(this);
        let link_id = $this.data('wpsurl-link-id');
        let el = $('.link-item-' + link_id + ' .link-push-options');
        el.fadeToggle();
    });

    body.on("click", ".link-copy", function (e) {
        e.preventDefault();
        let $this = $(this);
        let cel = $this.data('wpsurl-link-type');
        let link_id = $this.data('wpsurl-link-id');
        let el = document.querySelector('.' + cel + '-link-' + link_id + ' input');
        el.select();
        el.setSelectionRange(0, 99999); // For mobile devices
        navigator.clipboard.writeText(el.value);
        Messager.success(wpsurl_data.txt_copy_success, 'bottomLeft', 7000);
    });

    body.on("click", ".link-open", function (e) {
        e.preventDefault();
        let $this = $(this);
        let link_id = $this.data('wpsurl-link-id');
        let cel = $this.data('wpsurl-link-type');
        let link = $('.' + cel + '-link-' + link_id + ' input').val();
        if (isUrlValid(link)) {
            window.open(link);
        } else {
            Messager.fire(wpsurl_data.txt_link_invalid, "error");
        }
    });

    body.on("click", ".wpsurl-upload-button", function (e) {
        e.preventDefault();
        let field_cls = $(this).data('wpsurl-field');
        let field = $('.' + field_cls);
        let custom_uploader = wp.media({
            title: 'Upload file',
            button: {
                text: 'Select file'
            },
            multiple: false
        }).on('select', function () {
            let attachment = custom_uploader.state().get('selection').first().toJSON();
            field.val(attachment.url);
        }).open();
    });

    body.on('change', ".wpsurl-file-input-control", function (e) {
        e.preventDefault();
        let field = $(this);
        let fieldVal = field.val();
        let fieldID = field.attr('id');
        let fieldLabel = $('label[for=' + fieldID + ']');
        if (fieldVal !== '' || fieldVal !== undefined) {
            fieldLabel.addClass('file-selected');
        }
    });

    /*
    *
    * Ajax requests
    *
    */
    body.on("click", ".wpsurl-safe-attachment", function (e) {
        e.preventDefault();
        let $this = $(this);
        let post_id = $this.data('wpsurl-id');
        let title = $('#safe-url-title-' + post_id).val();
        let link = $('#safe-url-link-' + post_id).val();
        let password = $('#safe-url-password-' + post_id).val();
        let type = $('#safe-url-type-' + post_id).val();
        if (title === '' || link === '' || type === '') {
            Messager.fire(wpsurl_data.txt_complete_fields_err, 'error');
            return false;
        }
        Swal.mixin({
            input: 'text',
            confirmButtonText: wpsurl_data.txt_next,
            cancelButtonText: wpsurl_data.txt_cancel,
            showCancelButton: true,
            progressSteps: ['1', '2', '3', '4']
        }).queue([
            {
                title: wpsurl_data.txt_title,
                inputValue: title,
                inputValidator: (value) => {
                    if (value == null || value === '' || value === undefined) {
                        return wpsurl_data.txt_pls_entr_value
                    }
                }
            },
            {
                title: wpsurl_data.txt_link,
                inputValue: link,
                inputAttributes: {
                    dir: 'ltr',
                    placeholder: 'http://...',
                    readonly: true
                },
                inputValidator: (value) => {
                    if (value == null || value === '' || value === undefined) {
                        return wpsurl_data.txt_pls_entr_value
                    }
                }
            },
            {
                title: wpsurl_data.txt_password,
                text: wpsurl_data.txt_link_empty_not_lock,
                inputValue: password,
                inputAttributes: {
                    dir: 'ltr',
                    minlength: 8
                },
                inputValidator: (value) => {
                    if (value.length !== 0) {
                        if (value.length < 8) {
                            return wpsurl_data.txt_pwd_inv_char
                        }
                    }
                }
            },
            {
                title: wpsurl_data.txt_type,
                input: 'select',
                inputValue: type,
                inputOptions: {
                    1: wpsurl_data.txt_web_url,
                   // 2: wpsurl_data.txt_dl_url,
                    3: wpsurl_data.txt_only_woo_users
                },
                confirmButtonText: wpsurl_data.txt_create,
            }
        ]).then((result) => {
            if (result.value) {
                const answers = JSON.stringify(result.value);
                const aParse = JSON.parse(answers);
                let loader = $('#wpsurl-insert-loader');
                $.ajax({
                    url: wpsurl_data.ajax_url,
                    data: {
                        'action': 'wpsurl_action_insert_link',
                        'link_title': aParse[0],
                        'link_value': aParse[1],
                        'link_password': aParse[2],
                        'link_type': aParse[3],
                    },
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        loader.show();
                    },
                    success: function (response) {
                        loader.hide();
                        if ($('body[class*="wpsurl-links"]').length > 0) {
                            Messager.fire(response.msg, response.type);
                            if (response.type === 'success') {
                                if (response.links_count > 0) {
                                    setTimeout(function () {
                                        location.reload();
                                    }, 2000)
                                }
                            }
                        } else {
                            if (response.type === 'success') {
                                Swal.fire({
                                    icon: 'success',
                                    title: wpsurl_data.txt_link_copy_fo_user,
                                    html: '<input type="text" dir="ltr" value="' + response.safe + '" onclick="select();" style="width:100%;margin:7px 0;" readonly><input type="text" dir="ltr" value="' + response.short + '" onclick="select();" style="width:100%" readonly>',
                                    footer: wpsurl_data.txt_reopen_uploader,
                                    confirmButtonText: wpsurl_data.txt_yes,
                                })
                            } else {
                                Messager.fire(response.msg, response.type);
                            }
                        }
                    },
                    error: function () {
                        Messager.fire(wpsurl_data.txt_unknown_err, 'error');
                    },
                });
                return false;
            }
        })
    });

    body.on("click", ".wpsurl-add-new-link", function (e) {
        e.preventDefault();
        let $this = $(this);
        let modal = $(".wpsurl-modal.create-new-link");
        if (modal.length > 0) {
            modal.fadeIn(300);
        }
    });

    $('.wpsurl-link-checkbox #only-user-logged').change(function (e) {
        e.preventDefault();
        let $this = jQuery(this);
        if ($this.prop('checked')) {
            $this.prop('value', true);
            $this.attr('checked', 'checked');
        } else {
            $this.prop('value', false);
            $this.removeAttr('checked');
        }
    });

    $("#wpsurl-new-link-form").submit(function (e) {
        e.preventDefault();
        let loader = $('.wpsurl-modal.create-new-link .wpsurl-button.save');
        let $this = $(this);
        let multiSelect = $("#link-access-for-products").val() || [];
        let eddSelect = $("#link-access-for-edd-products").val() || [];
        let formData = wpsurlGetFormData(this);

        formData['action'] = 'wpsurl_action_insert_link';

        $.ajax({
            url: wpsurl_data.ajax_url,
            data: formData,
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                loader.addClass('loading');
            },
            success: function (response) {
                Messager.fire(response.msg, response.type);
                if (response.type === 'success') {
                    if (response.links_count > 0) {
                        setTimeout(function () {
                            location.reload();
                        }, 2000)
                    }
                } else {
                    loader.removeClass('loading');
                }
            },
            error: function () {
                loader.removeClass('loading');
                Messager.fire(wpsurl_data.txt_unknown_err, 'error');
            },
        });
        return false;
    });

    body.on("click", ".link-status", function (e) {
        e.preventDefault();
        let $this = $(this);
        let link_id = $this.data('wpsurl-link-id');
        let link_key = $this.data('wpsurl-link-key');
        let el = $('.link-item-' + link_id);
        let loader = $('.link-item-' + link_id + ' .wpsurl-link-item-loader');
        Messager.info({
            timeout: 20000,
            displayMode: 'once',
            id: 'inputs',
            zindex: 999,
            message: wpsurl_data.txt_chng_status,
            position: 'center',
            drag: false,
            buttons: [
                [`<button><b>${wpsurl_data.txt_yes}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'cbutton');
                }, true],
                [`<button><b>${wpsurl_data.txt_no}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'nobutton');
                }, true],
            ],
            onClosing: function(instance, toast, closedBy){
                if(closedBy !== 'cbutton')
                    return false;

                $.ajax({
                    url: wpsurl_data.ajax_url,
                    data: {
                        'action': 'wpsurl_action_change_link_status',
                        'link_id': link_id,
                        'link_key': link_key
                    },
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        loader.show();
                    },
                    success: function (response) {
                        loader.hide();
                        Messager.fire(response.msg, response.type);
                        if (response.type === 'success') {
                            if (response.status === 'active') {
                                $this.removeClass('inactive').addClass('active');
                            } else {
                                $this.removeClass('active').addClass('inactive');
                            }
                        }
                    },
                    error: function () {
                        Messager.fire(wpsurl_data.txt_unknown_err, 'error');
                    },
                });
            },
        });
    });

    body.on("click", ".link-lock", function (e) {
        e.preventDefault();
        let $this = $(this),
            link_id = $this.data('wpsurl-link-id'),
            link_key = $this.data('wpsurl-link-key'),
            $locked = $this.data('wpsurl-link-locked'),
            el = $('.link-item-' + link_id),
            loader = $('.link-item-' + link_id + ' .wpsurl-link-item-loader'),
            enteredPass = null,
            msg;

        msg = {
            timeout: 20000,
            displayMode: 'once',
            id: 'inputs',
            zindex: 999,
            message: $locked ? wpsurl_data.txt_inactive_lock : wpsurl_data.txt_pls_entr_pwd,
            position: 'center',
            drag: false,
            buttons: [
                [`<button><b>${wpsurl_data.txt_confirm}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'cbutton');
                }, true],
            ],
            onClosing: function(instance, toast, closedBy){
                if(closedBy !== 'cbutton')
                    return false;

                if(!$locked){
                    if(enteredPass === null || enteredPass === ''){
                        Messager.error(wpsurl_data.txt_pls_entr_value);
                        return false;
                    }
                }

                $.ajax({
                    url: wpsurl_data.ajax_url,
                    data: {
                        'action': 'wpsurl_action_active_link_lock',
                        'link_id': link_id,
                        'link_key': link_key,
                        'password': enteredPass,
                        'unlock': $locked ? true : false,
                    },
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        loader.show();
                    },
                    success: function (response) {
                        loader.hide();
                        Messager.fire(response.msg, response.type);
                        if (response.type === 'success') {
                            if (typeof response.lock !== "undefined") {
                                $this.removeClass('inactive').addClass('active');
                                $this.attr('data-wpsurl-link-locked', true);
                                $this.data('wpsurl-link-locked', true);
                            } else {
                                $this.removeClass('active').addClass('inactive');
                                $this.attr('data-wpsurl-link-locked', false);
                                $this.data('wpsurl-link-locked', false);
                            }
                        }
                    },
                    error: function () {
                        Messager.fire(wpsurl_data.txt_unknown_err, 'error');
                    },
                })
            },
        };

        if(!$locked){
            msg['inputs'] = [
                ['<input type="text">', 'keyup', function (instance, toast, input, e) {
                    enteredPass = input.value;
                }, true]
            ];
        }

        Messager.info(msg);
    });

    body.on("click", ".link-delete", function (e) {
        e.preventDefault();
        let $this = $(this);
        let link_id = $this.data('wpsurl-link-id');
        let link_key = $this.data('wpsurl-link-key');
        let el = $('.link-item-' + link_id);
        let loader = $('.link-item-' + link_id + ' .wpsurl-link-item-loader');
        Messager.info({
            timeout: 20000,
            displayMode: 'once',
            id: 'inputs',
            zindex: 999,
            message: wpsurl_data.txt_delete,
            position: 'center',
            drag: false,
            buttons: [
                [`<button><b>${wpsurl_data.txt_yes}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'cbutton');
                }, true],
                [`<button><b>${wpsurl_data.txt_no}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'nobutton');
                }, true],
            ],
            onClosing: function(instance, toast, closedBy){
                if(closedBy !== 'cbutton')
                    return false;

                $.ajax({
                    url: wpsurl_data.ajax_url,
                    data: {
                        'action': 'wpsurl_action_delete_link',
                        'link_id': link_id,
                        'link_key': link_key
                    },
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        loader.show();
                        el.css('opacity', 0.3);
                    },
                    success: function (response) {
                        loader.hide();
                        Messager.fire(response.msg, response.type);
                        if (response.type === 'success') {
                            $('.wpsurl-links-counter .count').text(response.links_count);
                            if (response.links_count == null || response.links_count === '0' || response.links_count === 0) {
                                if ($('body[class*="wpsurl-links"]').length > 0) {
                                    setTimeout(function () {
                                        location.reload();
                                    }, 2000)
                                }
                            }
                            if ($('body').hasClass('post-type-attachment')) {
                                setTimeout(function () {
                                    location.reload();
                                }, 1000)
                            }
                            el.remove().slideUp();
                        } else {
                            el.css('opacity', 1);
                        }
                    },
                    error: function () {
                        Messager.fire(wpsurl_data.txt_unknown_err, 'error');
                    },
                });
            },
        });
    });

    body.on("click", ".link-edit", function (e) {
        e.preventDefault();
        let $this = $(this);
        let link_id = $this.data('wpsurl-link-id');
        let link_key = $this.data('wpsurl-link-key');
        let loader = $('.link-item-' + link_id + ' .wpsurl-link-item-loader');
        body.append(
            $('<div/>', {'class': 'wpsurl-modal edit-link remove-close'}).append(
                $('<div/>', {'class': 'wpsurl-modal-overly'})
            ).append(
                $('<div/>', {'class': 'wpsurl-modal-wrapper'}).append(
                    $('<div/>', {'class': 'wpsurl-modal-title'}).append(
                        $('<span/>', {'class': 'wpsurl-close-modal'}).append(
                            $('<i/>', {'class': 'wpsurl-icon-close'})
                        ),
                        $('<span/>', {'class': 'title', text: wpsurl_data.txt_link_edit})
                    ),
                    $('<div/>', {'class': 'wpsurl-modal-content'}).append(
                        $('<div/>', {'class': 'wpsurl-edit-link-loader'}).append(
                            $('<div/>', {'class': 'wpsurl-svg-loader dark'}).append(
                                $('<svg width="38" height="38" viewBox="0 0 38 38" xmlns="http://www.w3.org/2000/svg"><g fill="none" fill-rule="evenodd"> <g transform="translate(1 1)" stroke-width="2"> <circle stroke-opacity=".5" cx="18" cy="18" r="18"></circle> <path d="M36 18c0-9.94-8.06-18-18-18" transform="rotate(242.643 18 18)"> <animateTransform attributeName="transform" type="rotate" from="0 18 18" to="360 18 18" dur="1s" repeatCount="indefinite"></animateTransform> </path> </g> </g><svg/>'),
                            ),
                        ),
                    )
                )
            )
        );
        if ($('.wpsurl-modal').length > 0) {
            $.ajax({
                url: wpsurl_data.ajax_url,
                data: {
                    'action': 'wpsurl_action_edit_html',
                    'link_id': link_id,
                    'link_key': link_key
                },
                type: 'POST',
                beforeSend: function () {
                    loader.show();
                },
                success: function (response) {
                    loader.hide();
                    if (response.length > 0) {
                        $(".wpsurl-modal.edit-link .wpsurl-modal-content").html(response);
                    } else {
                        body.find(".wpsurl-modal.edit-link").remove();
                    }
                },
                error: function () {
                    loader.hide();
                    Messager.fire(wpsurl_data.txt_unknown_err, 'error');
                    body.find(".wpsurl-modal.edit-link").remove();
                },
            });
        }
    });

    body.on("click", ".clear-link-data", function (e) {
        e.preventDefault();
        let $this = $(this);
        let link_id = $this.data('wpsurl-link-id');
        let link_key = $this.data('wpsurl-link-key');
        let clear_type = $this.data('wpsurl-clear-type');
        let el = $('.link-item-' + link_id);
        let loader = $('.link-item-' + link_id + ' .wpsurl-link-item-loader');
        let views_wrap = $('.link-item-' + link_id + ' .link-views-count span');
        let clicks_wrap = $('.link-item-' + link_id + ' .link-clicks-count span');
        let $swal_title = '';
        if (clear_type === 'views') {
            $swal_title = wpsurl_data.txt_views_count;
        } else if (clear_type === 'clicks') {
            $swal_title = wpsurl_data.txt_clicks_count;
        }

        Messager.info({
            timeout: 20000,
            displayMode: 'once',
            id: 'inputs',
            zindex: 999,
            title: wpsurl_data.txt_delete,
            message: $swal_title,
            position: 'center',
            drag: false,
            buttons: [
                [`<button><b>${wpsurl_data.txt_yes}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'cbutton');
                }, true],
                [`<button><b>${wpsurl_data.txt_no}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'nobutton');
                }, true],
            ],
            onClosing: function(instance, toast, closedBy){
                if(closedBy !== 'cbutton')
                    return false;

                $.ajax({
                    url: wpsurl_data.ajax_url,
                    data: {
                        'action': 'wpsurl_action_clear_link_data',
                        'link_id': link_id,
                        'link_key': link_key,
                        'clear_type': clear_type
                    },
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        loader.show();
                        el.css('opacity', 0.3);
                    },
                    success: function (response) {
                        loader.hide();
                        el.css('opacity', 1);
                        Messager.fire(response.msg, response.type);
                        if (response.type === 'success') {
                            if (clear_type === 'views') {
                                views_wrap.text(response.count);
                            } else if (clear_type === 'clicks') {
                                clicks_wrap.text(response.count);
                            }
                        }
                    },
                    error: function () {
                        Messager.fire(wpsurl_data.txt_unknown_err, 'error');
                    },
                });
            },
        });
    });

    body.on("click", ".wpsurl-empty-table", function (e) {
        e.preventDefault();
        let $this = $(this);
        let tableWrap = $('.wp-list-table');
        let table = $this.data('table');

        Messager.info({
            timeout: 20000,
            displayMode: 'once',
            id: 'inputs',
            zindex: 999,
            message: wpsurl_data.txt_are_clear_data,
            position: 'center',
            drag: false,
            buttons: [
                [`<button><b>${wpsurl_data.txt_yes}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'cbutton');
                }, true],
                [`<button><b>${wpsurl_data.txt_no}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'nobutton');
                }, true],
            ],
            onClosing: function(instance, toast, closedBy){
                if(closedBy !== 'cbutton')
                    return false;

                $.ajax({
                    url: wpsurl_data.ajax_url,
                    data: {
                        'action': 'wpsurl_action_empty_table',
                        table: table
                    },
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        tableWrap.css('opacity', 0.4);
                    },
                    success: function (response) {
                        tableWrap.css('opacity', 1);
                        Messager.fire(response.msg, response.type);
                        if (response.type === 'success') {
                            location.reload();
                        }
                    },
                    error: function () {
                        tableWrap.css('opacity', 1);
                        Messager.fire(wpsurl_data.txt_unknown_err, 'error');
                    },
                });
            },
        });
    });

    $('#link-type').change(function () {
        let select = $(this),
            selected = select.val(),
            parent = select.parent(),
            allDes = $('.des-link-type'),
            target = $('.des-link-type-' + selected);
        if (target.length) {
            allDes.hide();
            target.show();
        } else {
            allDes.hide();
        }
    });

    body.on("change", "#link-checked-all", function (e) {
        e.preventDefault();
        let input = $(this),
            checkboxes = document.getElementsByTagName('input'),
            checks = $('.wpsurl-links-list .link-affected-chckbox input[type="checkbox"]');
        if (input.is(':checked')) {
            for (var i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].type == 'checkbox') {
                    checkboxes[i].checked = true;
                }
            }
        } else {
            for (var i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].type == 'checkbox') {
                    checkboxes[i].checked = false;
                }
            }
        }
    });

    body.on("change", '.wpsurl-links-list .link-affected-chckbox input[type="checkbox"]', function (e) {
        e.preventDefault();
        let input = $(this),
            checkboxes = document.querySelectorAll('.wpsurl-links-list .link-affected-chckbox input[type="checkbox"]'),
            checkAllBtn = document.getElementById('link-checked-all');
        if (!input.is(':checked') && checkAllBtn.checked === true) {
            checkAllBtn.checked = false;
        } else {
            let allChecked = true;
            for (var i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].type === 'checkbox' && (checkboxes[i].id).search('all') < 0) {
                    if (!checkboxes[i].checked) {
                        allChecked = false;
                        break;
                    }
                }
            }
            if (allChecked){
                checkAllBtn.checked = true;
            }
        }
    });

    $('#wpsurl-import-form').submit(function (e) {
        let form = $(this);
        let input = $('#wpsurl_import_links_file').val();
        if (input === '' || input === undefined) {
            Messager.fire(wpsurl_data.txt_pls_select_file, 'error');
            return false;
        }
    });

    body.on("click", ".wpsurl-modal-overly, .wpsurl-close-modal", function (e) {
        e.preventDefault();
        if ($(".wpsurl-modal.remove-close").length > 0) {
            body.find(".wpsurl-modal.remove-close").remove();
        } else {
            body.find(".wpsurl-modal").fadeOut(300);
        }
    });

    if ($('.html-editor').length > 0) {
        wp.codeEditor.initialize($('.html-editor'), wpsurl_data);
    }

    if ($('.wpsurl-js-select').length > 0) {
        $('.wpsurl-js-select').selectize({
            searchField: ['text'],
            plugins: ['remove_button']
        });
    }

    body.on("change", ".checkbox-affected-toggle-elements", function (e) {
        e.preventDefault();
        let $this = $(this),
            reverse = $this.data('reverse'),
            target = $($this.data('elements'));
        if(target.length){
            if(typeof reverse !== 'undefined' && reverse === true){
                if(!$this.is(':checked')){
                    target.slideDown();
                } else {
                    target.slideUp();
                }
            } else {
                if($this.is(':checked')){
                    target.slideDown();
                } else {
                    target.slideUp();
                }
            }
        }
    });

    body.on("change", ".select-affected-toggle-elements", function (e) {
        e.preventDefault();
        let item = $(this),
            itemVal = item.val(),
            allTargets = $(item.data('option-targets')),
            target = $(item.data('option-target-' + itemVal));
        if(target.length){
            if(target.is(':visible')){
                target.slideUp();
            } else {
                target.slideDown();
            }
        } else {
            if(allTargets.length){
                allTargets.slideUp();
            }
        }
    });

    body.on("change", ".affected-toggle-elements", function (e) {
        e.preventDefault();
        let $this = $(this),
            target = $($this.data('elements'));
        if(target.length){
            if(target.is(':visible')){
                target.slideUp();
            } else {
                target.slideDown();
            }
        }
    });

    body.on("change", ".checkbox-affected-reverse-toggle-elements", function (e) {
        e.preventDefault();
        let $this = $(this),
            showEl = $($this.data('show')),
            hideEl = $($this.data('hide'));
        if($this.is(':checked')){
            showEl.slideDown();
            hideEl.slideUp();
        } else {
            showEl.slideUp();
            hideEl.slideDown();
        }
    });

    body.on("click", ".report-item-action-btn", function (e) {
        e.preventDefault();
        let btn = $(this),
            itemID = btn.data('id'),
            action = btn.data('action');

        $.ajax({
            url: wpsurl_data.ajax_url,
            data: {
                'action': 'wpsurl_report_item_action',
                id: itemID,
                item_action: action
            },
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                btn.attr('disabled', true);
            },
            complete: function (res) {
                res = res.responseJSON;
                Messager.fire(res.msg, res.type);
                if(res.type === 'success'){
                    location.reload();
                } else {
                    btn.attr('disabled', false);
                }
            },
            error: function () {
                btn.attr('disabled', false);
            }
        });
    });
});
