documentReady(function () {
    let body = iElement('body');

    body.on("click", ".wpsurl-redirect-button", function (e) {
        e.preventDefault();
        let $this = $(this);
        let link_token = $this.data('wpsurl-link-token');
        let loader = $('.wpsurl-loader-content');
        $.ajax({
            url: wpsurl_data.ajax_url,
            data: 'action=wpsurl_action_view_redirect_button&link_token=' + link_token,
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                iWantLoader($this);
                $this.addClass('wpsurl-button-disable');
            },
            success: function (response) {
                iCantLoader($this);
                $this.removeClass('wpsurl-button-disable');
                Messager.fire(response.msg, response.type);
                if (response.type === 'success') {
                    if (!response.lock) {
                        setTimeout(function () {
                            if (response.link_type === 2) {
                                window.location.href = response.download;
                            } else {
                                window.location.href = response.link;
                            }
                        }, 2000)
                    }
                } else {
                    if (response.lock) {
                        setTimeout(function () {
                            location.reload();
                        }, 1000)
                    }
                }
            },
            error: function () {
                iCantLoader($this);
            }
        });
        return false;
    });

    body.on("click", ".wpsurl-redirect-by-pass", function (e) {
        e.preventDefault();
        let $this = $(this);
        let link_token = $this.data('wpsurl-link-token');
        let link_type = $this.data('wpsurl-link-type');
        let loader = $('.wpsurl-loader-content'),
            enteredPass = null;

        Messager.info({
            timeout: 20000,
            displayMode: 'once',
            id: 'inputs',
            zindex: 999,
            message: wpsurl_data.txt_pls_entr_pwd,
            position: 'center',
            drag: false,
            inputs: [
                ['<input type="text">', 'keyup', function (instance, toast, input, e) {
                    enteredPass = input.value;
                }, true]
            ],
            buttons: [
                [`<button><b>${wpsurl_data.txt_confirm}</b></button>`, function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'cbutton');
                }, true],
            ],
            onClosing: function(instance, toast, closedBy){
				if(closedBy !== 'cbutton')
					return false;
				
				if(enteredPass === null || enteredPass === ''){
					Messager.error(wpsurl_data.txt_pls_entr_value);
					return false;
				}
				
				$.ajax({
					url: wpsurl_data.ajax_url,
					data: 'action=wpsurl_action_open_link_by_pwd&password=' + enteredPass + '&link_token=' + link_token,
					type: 'POST',
					dataType: 'json',
					beforeSend: function () {
						iWantLoader($this);
						$this.addClass('wpsurl-button-disable');
					},
					success: function (response) {
						iCantLoader($this);
						$this.removeClass('wpsurl-button-disable');
						Messager.fire(response.msg, response.type);
						if (response.type === 'success') {
							setTimeout(function () {
								if (response.link_type === 2) {
									window.location.href = response.download;
								} else {
									window.location.href = response.link;
								}
							}, 2000)
						}
					},
					error: function (){
						iCantLoader($this);
						$this.removeClass('wpsurl-button-disable');
					}
				})
            },
        });
    });

    body.on("submit", "#link-report-form", function (e) {
        e.preventDefault();
        let form = $(this),
            formData = [],
            captchaKey = 'report-problem-captcha',
            formArr = form.serializeArray();

        if(formArr){
            $.each(formArr, function (k, v) {
                formData[v['name']] = v['value'];
            })
        }

        if(formData['security_code'] !== getCaptchaCode(captchaKey)){
            Messager.error(wpsurl_data.txt_invalid_captcha);
            return;
        }

        $.ajax({
            url: wpsurl_data.ajax_url,
            data: "action=wpsurl_action_report_link_problem&link_token=" + form.data('token') + "&" + form.serialize(),
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                iWantLoader(form);
            },
            success: function (response) {
                iCantLoader(form);
                Messager.fire(response.msg, response.type);
                if (response.type === 'success') {
                    form[0].reset();
                }
                generateCatptcha(captchaKey);
            },
            error: function () {
                iCantLoader(form);
                generateCatptcha(captchaKey);
            }
        });
        return false;
    });

    body.on("submit", "#open-link-with-password-form", function (e) {
        e.preventDefault();
        let form = $(this),
            link_token = form.data('token'),
            formData = [],
            captchaKey = 'password-form-captcha',
            formArr = form.serializeArray();

        if(formArr){
            $.each(formArr, function (k, v) {
                formData[v['name']] = v['value'];
            })
        }

        if(formData['security_code'] !== getCaptchaCode(captchaKey)){
            Messager.error(wpsurl_data.txt_invalid_captcha);
            return;
        }

        $.ajax({
            url: wpsurl_data.ajax_url,
            data: "action=wpsurl_action_open_link_by_pwd&link_token=" + link_token + "&" + form.serialize(),
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                iWantLoader(form);
            },
            success: function (response) {
                Messager.fire(response.msg, response.type);
                if (response.type === 'success') {
                    location.reload();
                    wpsurlSetCookie('wpsurl-password-' + link_token, md5(form.find('#password').val()), 3);
                    form[0].reset();
                } else {
                    iCantLoader(form);
                }
                generateCatptcha(captchaKey);
            },
            error: function () {
                iCantLoader(form);
                generateCatptcha(captchaKey);
            }
        });
    });
});