let $ = typeof jQuery === 'function' ? jQuery : document;

let surl_captcha_ids = [
    'report-problem-captcha',
    'password-form-captcha',
];
function generateCatptcha(element_id = 'captcha', type = 'number'){
    if(document.getElementById(element_id)){
        document.getElementById(element_id).innerHTML = "";
        var charsArray ="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ@!#$%^&*";
        if(type == 'number'){
            charsArray ="0123456789";
        }
        var lengthOtp = 6;
        var captcha = [];
        for (var i = 0; i < lengthOtp; i++) {
            var index = Math.floor(Math.random() * charsArray.length + 1);
            if (captcha.indexOf(charsArray[index]) == -1)
                captcha.push(charsArray[index]);
            else i--;
        }
        var canv = document.createElement("canvas");
        canv.id = element_id;
        canv.width = 100;
        canv.height = 50;
        var ctx = canv.getContext("2d");
        ctx.font = "25px Georgia";
        ctx.strokeText(captcha.join(""), 0, 30);
        surl_captcha_ids[element_id] = captcha.join("");
        document.getElementById(element_id).appendChild(canv);
    }
}

function reGenerateCaptchaCodes(){
    if(typeof surl_captcha_ids !== "undefined" && surl_captcha_ids.length){
        jQuery.each(surl_captcha_ids, function(i, val){
            generateCatptcha(val);
        });
    }
}

function getCaptchaCode(key){
    return typeof surl_captcha_ids !== "undefined" && typeof surl_captcha_ids[key] !== "undefined" && surl_captcha_ids.length ? surl_captcha_ids[key] : null;
}

function iElement(selector){
    return typeof selector === 'function' ? selector : jQuery(selector);
}
function documentReady(fn) {
    if (document.readyState != 'loading'){
        fn();
    } else {
        document.addEventListener('DOMContentLoaded', fn);
    }
}

let matches = function(el, selector) {
    return (el.matches || el.matchesSelector || el.msMatchesSelector || el.mozMatchesSelector || el.webkitMatchesSelector || el.oMatchesSelector).call(el, selector);
};

function numberFatToEn(num){
    return document.body.classList.contains('rtl') ? PersianTools.digitsEnToFa(num) : num;
}

class MyMessager {
    static overlayColor = 'rgba(0, 0, 0, 0.6)';
    static params(params){
        let options = {
            overlay: true,
            overlayClose: true,
            overlayColor: this.overlayColor,
            rtl: document.body.classList.contains('rtl')
        };
        if(params){
            for ( let index in params ) {
                options[index] = params[index];
            }
        }
        return options;
    }
    static success(msg, position = 'center', timeout = 20000){
        msg = typeof msg === 'object' ? msg : {
            message: msg,
            position: position,
            timeout: timeout
        };
        iziToast.success(this.params(msg));
    }

    static error(msg, position = 'center', timeout = 20000){
        msg = typeof msg === 'object' ? msg : {
            message: msg,
            position: position,
            timeout: timeout
        };
        iziToast.error(this.params(msg));
    }

    static warning(msg, position = 'center', timeout = 20000){
        msg = typeof msg === 'object' ? msg : {
            message: msg,
            position: position,
            timeout: timeout
        };
        iziToast.warning(this.params(msg));
    }

    static info(msg, position = 'center', timeout = 20000){
        msg = typeof msg === 'object' ? msg : {
            message: msg,
            position: position,
            timeout: timeout
        };
        iziToast.info(this.params(msg));
    }

    static fire(msg = '', type = 'success'){
        if(type === 'error'){
            this.error(msg);
        } else if(type === 'warning'){
            this.warning(msg);
        } else if(type === 'info'){
            this.info(msg);
        } else {
            this.success(msg);
        }
    }
}

let Messager = MyMessager;

function iWantLoader(element){
    let el = iElement(element),
        loaderContent = iElement(`<div class="is-loader loader-line"></div>`);
    el.css('position', 'relative');
    loaderContent.hide();
    el.append(loaderContent);
    el.find('.is-loader').slideDown();
    el.addClass('has-loader');
}

function iCantLoader(element){
    let el = iElement(element);
    el.find('.is-loader').slideUp(function(){
        iElement(this).remove();
    });
    el.removeClass('has-loader');
}

function isUrlValid(url) {
    return /(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/.test(url);
}

function ConvertNumberToPersion() {
    persian = {0: '۰', 1: '۱', 2: '۲', 3: '۳', 4: '۴', 5: '۵', 6: '۶', 7: '۷', 8: '۸', 9: '۹'};

    function traverse(el) {
        if (el.nodeType == 3) {
            var list = el.data.match(/[0-9]/g);
            if (list != null && list.length != 0) {
                for (var i = 0; i < list.length; i++)
                    el.data = el.data.replace(list[i], persian[list[i]]);
            }
        }
        for (var i = 0; i < el.childNodes.length; i++) {
            traverse(el.childNodes[i]);
        }
    }

    traverse(document.body);
}

function urlToBlob(url) {
    return new Promise(resolve => {
        const xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'blob';
        xhr.onload = () => {
            if (xhr.status === 200) {
                resolve(xhr.response);
            }
        };
        xhr.send();
    });
}

function rewrite_input_fetch(id) {
    let $this = jQuery(this);
    let field = jQuery('#' + id);
    let rewrite = field.val();
    let saveBtn = jQuery('.save-settings-btn');
    if (rewrite.length <= 3 || rewrite.length === 0) {
        return false
    }
    jQuery.ajax({
        url: wpsurl_data.ajax_url,
        type: 'post',
        data: {
            action: 'wpsurl_action_rewrite_exists',
            'rewrite': rewrite
        },
        beforeSend: function () {
            field.css({'opacity': 0.6, 'pointer-events': 'none'});
            saveBtn.css({'opacity': 0.6, 'pointer-events': 'none'});
        },
        success: function (data) {
            field.css({'opacity': 1, 'pointer-events': 'all'});
            if (data.type === 'success') {
                field.css('border-color', 'green');
                saveBtn.css({'opacity': 1, 'pointer-events': 'all'});
            } else {
                field.css('border-color', 'red');
            }
        },
        complete: function () {
            field.css({'opacity': 1, 'pointer-events': 'all'});
        },
        error: function () {
            saveBtn.css({'opacity': 0.6, 'pointer-events': 'none'});
            Messager.fire(wpsurl_data.txt_unknown_err, 'error');
        },
    });
}

function wpsurlSetCookie(name, value, exdays = 30) {
    const d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    let expires = "expires=" + d.toUTCString();
    document.cookie = name + "=" + value + ";" + expires + ";path=/";
}

function wpsurlDeleteCookie(name, exdays = 100) {
    const d = new Date();
    d.setTime(d.getTime() + (-exdays * 24 * 60 * 60 * 1000));
    let expires = "expires=" + d.toUTCString();
    document.cookie = name + "=;" + expires + ";path=/";
}

function wpsurlGetCookie(cname) {
    let name = cname + "=";
    let ca = document.cookie.split(';');
    for(let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

function wpsurlCheckCookie(name) {
    let data = wpsurlGetCookie(name);
    if (data != "") {
        return true;
    }

    return false;
}

function wpsurlGetFormData(form){
    let formData = {},
        fields = form.elements;
    for (let i = 0; i < fields.length; i++) {
        let field = fields[i],
            fieldType = field.type.toLowerCase(),
            fieldName = field.name,
            fieldValue = field.value;

        switch (fieldType) {
            case 'text':
            case 'email':
            case 'password':
            case 'textarea':
            case 'number':
            case 'search':
            case 'url':
            case 'hidden':
            case 'radio':
            case 'select':
            case 'select-one':
            case 'select-multiple':
                if(field.multiple || fieldType.search('multiple') >= 0){
                    fieldValue = jQuery(field).val() || [];
                    fieldValue = fieldValue.join(',');
                }
                formData[fieldName || field.id] = fieldValue;
                break;
            case 'checkbox':
                if (field.checked) {
                    formData[fieldName || field.id] = field.checked;
                }
                break;
        }
    }
    formData = new Object(formData);
    return formData;
}

documentReady(function () {
    let body = $('body');
    if(typeof HystModal !== 'undefined'){
        const myModal = new HystModal({
            linkAttributeName: "data-hystmodal",
        });
    }

    reGenerateCaptchaCodes();

    body.on('click', '.reload-captcha', function (e){
        e.preventDefault();
        let btn = $(this),
            captchaID = btn.attr('id');
        generateCatptcha(captchaID);
    })
});