<?php
$is_active_woo = \WPSURL\App\Options::isActiveWoo();
$is_active_edd = \WPSURL\App\Options::isActiveEdd();
?>
<!-- Modal Create New Link -->
<div class="wpsurl-modal create-new-link" style="display: none">
    <div class="wpsurl-modal-overly"></div>
    <div class="wpsurl-modal-wrapper">
        <div class="wpsurl-modal-title">
            <span class="wpsurl-close-modal"><i class="wpsurl-icon-close"></i></span>
            <span class="title"><?php _e('Add New Link', WPSURL_TEXT_DOMAIN) ?></span>
        </div>
        <div class="wpsurl-modal-content">
            <div class="wpsurl-loader-done" style="display: none">
                <?php \WPSURL\App\Utility::showLoader(null, 'svg', 'dark') ?>
            </div>
            <form action="<?php add_query_arg(['']) ?>" method="post" id="wpsurl-new-link-form" novalidate>
                <div class="form-fields-group">
                    <div class="form-field-group">
                        <label><?php _e('Title', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <input type="text" id="link-title" name="title" required>
                        </div>
                    </div>
                    <div class="form-field-group">
                        <label><?php _e('Link', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <input type="text" dir="ltr" id="link-value" name="link" required>
                        </div>
                    </div>
                    <div class="form-field-group">
                        <label><?php _e('Password', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <input type="text" dir="ltr" id="link-password" name="password">
                        </div>
                    </div>
                    <div class="form-field-group">
                        <label><?php _e('Type', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <select id="link-type" name="type" class="select-affected-toggle-elements" data-option-targets=".link-type-option-targets" data-option-target-1=".preview-iframe-field" required>
                                <option value="0"><?php _e('Select Type...', WPSURL_TEXT_DOMAIN); ?></option>
                                <option value="1"><?php _e('Website url', WPSURL_TEXT_DOMAIN); ?></option>
                                <option value="2"><?php _e('Download url', WPSURL_TEXT_DOMAIN); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="form-field-group link-type-option-targets preview-iframe-field w-100" style="display:none">
                        <div class="form-field-box">
                            <div class="wpsurl-link-checkbox">
                                <input type="checkbox" value="false" id="iframe-preview" name="iframe_preview">
                                <label for="iframe-preview">
                                    <i class="wpsurl-icon-check"></i>
                                </label>
                            </div>
                            <label for="iframe-preview"><?php _e('Preview in Iframe', WPSURL_TEXT_DOMAIN) ?></label>
                        </div>
                    </div>
                    <div class="form-field-group">
                        <div class="wpsurl-link-checkbox">
                            <input type="checkbox" value="false" id="restriction-woo" name="restriction_woo" class="checkbox-affected-toggle-elements" data-elements=".woo-products-list" <?php echo !$is_active_woo ? ' disabled' : '' ?>>
                            <label for="restriction-woo">
                                <i class="wpsurl-icon-check"></i>
                            </label>
                        </div>
                        <label for="restriction-woo">
                            <?php _e('Restriction woocommerce customers', WPSURL_TEXT_DOMAIN) ?>
                            <?php if (!$is_active_woo): ?>
                                <span class="is-not-active"><?php _e('Woo is not active.', WPSURL_TEXT_DOMAIN) ?></span>
                            <?php endif; ?>
                        </label>
                        <div class="form-field-box-wrap woo-products-list" style="display:none">
                            <label><?php _e('WooCommerce products', WPSURL_TEXT_DOMAIN) ?></label>
                            <div class="form-field-box">
                                <?php
                                $products_count = wp_count_posts('product');
                                if (isset($products_count->publish) && $products_count->publish > 0) {
                                    \WPSURL\App\Utility::dropDownPosts(array(
                                        'post_type' => 'product',
                                        'multi' => true,
                                        'class' => 'wpsurl-js-select',
                                        'id' => 'woo-products',
                                        'select_name' => 'woo_products',
                                        'selected' => 0
                                    ));
                                } else { ?>
                                    <div class="not-found"><?php echo __('Product Not Found.', WPSURL_TEXT_DOMAIN); ?></div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="form-field-group">
                        <div class="wpsurl-link-checkbox">
                            <input type="checkbox" value="false" id="restriction-edd" name="restriction_edd" class="checkbox-affected-toggle-elements" data-elements=".edd-products" <?php echo !$is_active_edd ? ' disabled' : '' ?>>
                            <label for="restriction-edd">
                                <i class="wpsurl-icon-check"></i>
                            </label>
                        </div>
                        <label for="restriction-edd">
                            <?php _e('Restriction edd customers', WPSURL_TEXT_DOMAIN) ?>
                            <?php if (!$is_active_edd): ?>
                                <span class="is-not-active"><?php _e('Edd is not active.', WPSURL_TEXT_DOMAIN) ?></span>
                            <?php endif; ?>
                        </label>
                        <div class="form-field-box-wrap edd-products" style="display:none">
                            <label><?php _e('Edd products', WPSURL_TEXT_DOMAIN) ?></label>
                            <div class="form-field-box">
                                <?php
                                $products_count = wp_count_posts('download');
                                if (isset($products_count->publish) && $products_count->publish > 0) {
                                    \WPSURL\App\Utility::dropDownPosts(array(
                                        'post_type' => 'download',
                                        'multi' => true,
                                        'class' => 'wpsurl-js-select',
                                        'id' => 'edd-products',
                                        'select_name' => 'edd_products',
                                        'selected' => 0
                                    ));
                                } else { ?>
                                    <div class="not-found"><?php echo __('Product Not Found.', WPSURL_TEXT_DOMAIN); ?></div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="form-field-group w-100">
                        <div class="form-field-box">
                            <div class="wpsurl-link-checkbox">
                                <input type="checkbox" value="false" id="view-restrictions" name="view_restrictions" class="checkbox-affected-toggle-elements" data-elements=".views-limit-box,.click-limit-box">
                                <label for="view-restrictions">
                                    <i class="wpsurl-icon-check"></i>
                                </label>
                            </div>
                            <label for="view-restrictions"><?php _e('Visit restrictions', WPSURL_TEXT_DOMAIN) ?></label>
                        </div>
                    </div>
                    <div class="form-field-group views-limit-box" style="display:none">
                        <label><?php _e('View limit', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <input type="number" id="link-views-limit" name="view_limited_num" min="1">
                        </div>
                    </div>
                    <div class="form-field-group click-limit-box" style="display:none">
                        <label><?php _e('Click limit', WPSURL_TEXT_DOMAIN) ?></label>
                        <div class="form-field-box">
                            <input type="number" id="link-clicks-limit" name="click_limited_num" min="1">
                        </div>
                    </div>
                    <div class="form-field-group">
                        <div class="form-field-box">
                            <div class="wpsurl-link-checkbox">
                                <input type="checkbox" value="false" id="only-user-logged" name="only_user_logged">
                                <label for="only-user-logged">
                                    <i class="wpsurl-icon-check"></i>
                                </label>
                            </div>
                            <label for="only-user-logged"><?php _e('Only the logged in user', WPSURL_TEXT_DOMAIN) ?></label>
                        </div>
                    </div>
                </div>
                <button type="submit" class="wpsurl-button save">
                    <img src="<?php echo WPSURL_IMG_URL . 'loader.svg' ?>" alt="loader" style="display: none">
                    <?php _e('Save Changes', WPSURL_TEXT_DOMAIN) ?>
                </button>
            </form>
        </div>
    </div>
</div>