<?php
/**
 * Exit if accessed directly
 */
if (!defined('ABSPATH')) {
    exit;
}

use WPSURL\App\{Links, Options, LinkOptions, Statistics};

@ini_set('error_reporting', E_ALL & ~E_NOTICE);

//- turn off compression on the server
if(function_exists('apache_setenv')){
    @apache_setenv('no-gzip', 1);
}

ignore_user_abort(false);
@ini_set('output_buffering', 0);
@ini_set('zlib.output_compression', 0);

$slug = \WPSURL\App\Utility::getPagesSlug(2);
$q_val = \WPSURL\App\Utility::getQueryVarsValue($slug . '-download');
$link_data = Links::get($q_val);

if(!$link_data){
    wp_redirect(site_url());
    exit;
}

$type = Links::getType($q_val);
$pwd = (string)Links::getItem($q_val, 'password');
$pwd2 = isset($_GET['ac']) && !empty($_GET['ac']) ? base64_decode($_GET['ac']) : null;
$link_id = $link_data->link_id;
$link = $link_data->link;
$status = $link_data->status;
$logged = (bool)\WPSURL\App\Options::isViewOnlyLoggedUser();
$woo_restriction = Options::isActiveWoo() && LinkOptions::getOption('restriction_woo', $q_val, $q_val) == 'true';
$edd_restriction = Options::isActiveEdd() && LinkOptions::getOption('restriction_edd', $q_val, $q_val) == 'true';
$view_restriction = LinkOptions::getOption('view_restrictions_status', $q_val, $q_val);
$clicks = LinkOptions::getOption('click_limited_num', $q_val, $q_val);
$views = LinkOptions::getOption('view_limited_num', $q_val, $q_val);
$only_logged_user = LinkOptions::getOption('only_user_logged', $q_val, $q_val);
$access_products = LinkOptions::getOption('woo_products', $q_val, $q_val);
$access_products_arr = explode(",", $access_products);
$access_downloads = LinkOptions::getOption('edd_products', $q_val, $q_val);
$access_downloads_arr = explode(",", $access_downloads);
$url = '<a href="' . get_site_url() . '">' . __('Return to Home', WPSURL_TEXT_DOMAIN) . '</a>';
$hash_link = \WPSURL\App\Utility::getHashLink($link);
if ($status !== 'active') {
    wp_redirect(site_url());
    exit;
}

if ($woo_restriction){
    if (is_array($access_products_arr) && !empty($access_products)) {
        if (!\WPSURL\App\Woocommerce::isUserCustomerProducts($access_products_arr)) {
            wp_redirect($hash_link);
            exit;
        }
    }
}
if ($edd_restriction) {
    if (is_array($access_downloads_arr) && !empty($access_downloads)) {
        if (!\WPSURL\App\Edd::isUserCustomerProducts($access_downloads_arr)) {
            wp_redirect($hash_link);
            exit;
        }
    }
}
if ($only_logged_user == 'true' || $only_logged_user == '1') {
    if (!is_user_logged_in()) {
        wp_redirect($hash_link);
        exit;
    }
}
if($view_restriction == 'true'){
    if (!empty($clicks) && $clicks > 0) {
        if (Statistics::getClicks($q_val) > $clicks) {
            wp_redirect($hash_link);
            exit;
        }
    }
    if (!empty($views) && $views > 0) {
        if (Statistics::getViews($q_val) > $views) {
            wp_redirect($hash_link);
            exit;
        }
    }
}
if ($logged) {
    wp_redirect($hash_link);
    exit;
}

if (!empty($pwd) || $pwd != null || $pwd != '') {
    if (!empty($pwd2) || $pwd2 != null || $pwd2 != '') {
        if ($pwd !== $pwd2) {
            wp_redirect($hash_link);
            exit;
        }
    } else {
        wp_redirect($hash_link);
        exit;
    }
}

Statistics::incrementClick($link_id);
$downloader = new \WPSURL\App\Downloader($link);
$downloader->downloadFileFromUrl();
exit;