<?php
$iframes = \WPSURL\App\Links::getPreviewsItems();
$show_iframes = \WPSURL\App\Settings::getOption('show_other_previews') == true;
$is_verify_password = \WPSURL\App\LinkOptions::isVerifyPassword($extra->link_id, ($_COOKIE['wpsurl-password-' . $extra->link_id] ?? ''));
?>
<div class="wpsurl-iframe-page">
    <nav class="iframe-header navbar is-transparent">
        <div class="navbar-brand">
            <a href="<?php echo site_url() ?>" class="navbar-item" target="_blank">
                <img src="<?php echo \WPSURL\App\Settings::getLogoUrl(); ?>" alt="<?php bloginfo('name') ?>">
            </a>
            <?php if($show_iframes): ?>
            <div class="navbar-burger" data-target="navbarLinks">
                <span></span>
                <span></span>
                <span></span>
            </div>
            <?php endif; ?>
        </div>

        <div id="navbarLinks" class="navbar-menu">
            <?php if($show_iframes): ?>
            <div class="navbar-<?php echo is_rtl() ? 'end' : 'start' ?>">
                <?php if ($iframes): ?>
                <div class="navbar-item has-dropdown is-hoverable">
                    <a class="navbar-link" href="#">
                        <?php _e('All Previews', WPSURL_TEXT_DOMAIN) ?>
                    </a>
                    <div class="navbar-dropdown is-boxed iframe-items">
                        <?php foreach ($iframes as $iframe): ?>
                        <a class="navbar-item <?php echo $iframe->link_id == $extra->link_id ? ' is-active' : '' ?>" href="<?php echo \WPSURL\App\Utility::getHashLink($iframe->link_id) ?>">
                            <?php echo $iframe->title ?>
                        </a>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <div class="navbar-<?php echo is_rtl() ? 'start' : 'end' ?>">
                <div class="navbar-item">
                    <div class="field">
                        <p class="control">
                            <a class="button is-link is-light report-problem-btn" href="#" data-id="<?php echo $link_data->link_id ?>" data-hystmodal="#link-report-modal">
                                <span><?php _e('Report Problem', WPSURL_TEXT_DOMAIN) ?></span>
                            </a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </nav>
    <div class="iframe-content" style="display: none">
        <?php if ($extra->is_locked && !$is_verify_password): ?>
            <form action="" method="post" id="open-link-with-password-form" class="box" autocomplete="off" data-token="<?php echo $link_data->link_id ?>">
                <article class="message is-danger">
                    <div class="message-body"><?php echo esc_html__('Protected by password.', WPSURL_TEXT_DOMAIN) ?></div>
                </article>
                <div class="field">
                    <label class="label"><?php echo esc_html__('Password', WPSURL_TEXT_DOMAIN) ?></label>
                    <div class="control">
                        <input class="input" type="password" id="password" name="password" autocomplete="off">
                    </div>
                </div>
                <div class="field captcha-wrap">
                    <p class="control has-icons-left">
                        <input class="input" type="text" name="security_code" placeholder="<?php _e( 'Security Code', WPSURL_TEXT_DOMAIN ) ?>">
                        <span class="icon is-small is-left">
                            <em class="captcha-code reload-captcha" id="password-form-captcha"></em>
                        </span>
                    </p>
                </div>
                <button class="button is-link"><?php echo esc_html__('Confirm', WPSURL_TEXT_DOMAIN) ?></button>
            </form>
        <?php else: ?>
            <iframe src="<?php echo $link_data->link ?>" data-id="<?php echo $link_data->link_id ?>" frameborder="0"></iframe>
        <?php endif; ?>
    </div>
</div>