<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.

use ahura\app\woocommerce;
use ahura\app\mw_assets;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class bestseller_carousel extends \Elementor\Widget_Base {

	function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_style('bestseller_carousel_css', mw_assets::get_css('elementor.bestseller_carousel'));
    }
    
	function get_style_depends()
    {
        return [mw_assets::get_handle_name('bestseller_carousel_css')];
    }

	public function get_name() {
		return 'bestsellercarousel';
	}

	public function get_title() {
		return __( 'Best Seller Carousel', 'ahura' );
	}

	public function get_icon() {
		return 'aicon-svg-best-seller-carousel';
	}

	public function get_categories() {
		return [ 'ahuraelements' ];
	}
	function get_keywords()
	{
		return ['best_seller_carousel', 'bestseller_carousel', 'bestsellercarousel', esc_html__('Best Seller Carousel', 'ahura')];
	}

	public function register_controls() {
		if(!woocommerce::is_active())
		{
			return false;
		}
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'count',
			[
				'label'      => __( 'Number of products', 'ahura' ),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'default'    => 8
			]
		);

		$this->add_control(
			'price',
			[
				'label'   => __( 'Show Price', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'fa fa-check-circle' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'fa fa-times-circle' ]
				],
				'default' => 'yes'
			]
		);

        $this->add_control(
			'show_img',
			[
				'label' => __( 'Show Image', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'fa fa-check-circle' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'fa fa-times-circle' ]
				],
				'default' => 'yes',
			]
		);

        $this->add_control(
			'desktop_column',
			[
				'label' => esc_html__( 'Desktop column', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '3',
				'options' => [
					'12' => esc_html__( '1', 'ahura' ),
					'6' => esc_html__( '2', 'ahura' ),
					'4' => esc_html__( '3', 'ahura' ),
					'3' => esc_html__( '4', 'ahura' ),
					'2' => esc_html__( '6', 'ahura' ),
				],
			]
		);

        $this->add_control(
			'mobile_column',
			[
				'label' => esc_html__( 'Mobile column', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '3',
				'options' => [
					'12' => esc_html__( '1', 'ahura' ),
					'6' => esc_html__( '2', 'ahura' ),
					'4' => esc_html__( '3', 'ahura' ),
					'3' => esc_html__( '4', 'ahura' ),
					'2' => esc_html__( '6', 'ahura' ),
				],
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( class_exists( 'WooCommerce' ) ) {
			$wc_query = new \WP_Query( array(
				'post_type'      => 'product',
				'post_status'    => 'publish',
				'posts_per_page' => $settings['count'],
                'ignore_sticky_posts' => 1,
                'meta_key' => 'total_sales',
                'orderby' => 'meta_value_num',
                'order' => 'DESC',
			) );
			if ( $wc_query->have_posts() ) : ?>
                <div class="ahura-element-bestseller-carousel">
					<?php if(is_admin()): ?>
						<div class="preload_widget_section">
							<h3><?php _e('Slider is here!', 'ahura'); ?></h3>
							<small><?php _e('To see slider please view page.', 'ahura'); ?></small>
						</div>
					<?php else: ?>
                    <div class="container">
                        <div class="row">
						<?php while ( $wc_query->have_posts() ) : $wc_query->the_post(); ?>
                            <div align="center" class="col-<?php echo $settings['mobile_column'] ?> col-md-<?php echo $settings['desktop_column'] ?>">
                                <?php if ( 'yes' === $settings['show_img'] ): ?>
                                    <a class="fimage" href="<?php the_permalink(); ?>">
                                        <?php the_post_thumbnail( 'woocommerce_thumbnail' ); ?>
                                    </a>
                                <?php endif; ?>
                                
                                <a href="<?php the_permalink(); ?>">
                                    <h3><?php echo wp_trim_words( get_the_title(), 6, '...' ); ?></h3></a>
								<?php if ( $settings['price'] == 'yes' ) : ?>
                                    <div class="mwprprice">
										<?php
											$price = woocommerce_template_single_price();
											echo $price;
										?>
                                    </div>
								<?php endif; ?>
                            </div>
						<?php endwhile; ?>
                        </div>
					</div>
					<?php endif; ?>
                </div>
				<?php wp_reset_postdata(); ?>
			<?php else: ?>
					<div class="mw_element_error">
						<?php echo __('Nothing found. Edit the page with Elementor and select a category for this section.','ahura');?>
					</div>
			<?php endif; ?>
            <div class="clear"></div>
			<?php
		}elseif(is_admin()){
			?>
			<div class="productcategorybox mw_elem_empty_box"><h3><?php _e('To use this element you must install woocommerce plugin.', 'ahura'); ?></h3></div>
			<?php
		}
	}

}
