<?php
namespace ahura\inc\widgets;
// Block direct access to the main plugin file.

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class product_pricebox_1 extends \Elementor\Widget_Base
{
    use \ahura\app\traits\mw_elementor;
    public function get_name()
    {
        return 'product_pricebox_1';
    }
    function get_title()
    {
        return esc_html__('Product Price box 1', 'ahura');
    }
    public function get_icon() {
		return 'aicon-svg-product-price-box';
	}
    function get_categories() {
		return [ 'ahuraelements' ];
	}
    function get_keywords()
    {
        return ['product_pricebox_1', 'productpricebox1', esc_html__( 'Product Price box 1' , 'ahura')];
    }
    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);
        mw_assets::register_style('product_pricebox_1_widget_style', mw_assets::get_css('elementor.product_pricebox_1'));
    }
    public function get_style_depends() {
        return [ mw_assets::get_handle_name('product_pricebox_1_widget_style') ];
    }
    protected function register_controls()
    {
        $this->start_controls_section(
            'title_section',
            [
                'label' => esc_html__('Title', 'ahura'),
            ]
        );
        $this->add_control(
            'title_alignment',
            [
                'label' => esc_html__('Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => __('Right', 'ahura'),
                        'icon' => 'eicon-text-align-right'
                    ],
                    'center' => [
                        'title' => __('Center', 'ahura'),
                        'icon' => 'eicon-text-align-center'
                    ],
                    'left' => [
                        'title' => __('Left', 'ahura'),
                        'icon' => 'eicon-text-align-left'
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper .title' => 'text-align: {{VALUE}};'
                ]
            ]
        );
        $this->add_control(
            'title_color',
            [
                'type' => Controls_Manager::COLOR,
                'label' => esc_html__('Color', 'ahura'),
                'default' => '#ff071b',
                'selectors' =>
                [
                    '{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper .title' => 'color: {{VALUE}}'
                ]
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'price_section',
            [
                'label' => esc_html__('Price', 'ahura')
            ]
        );
        $this->add_control(
            'price_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper .price-line' => 'color: {{VALUE}}'
                ]
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_value_typography',
                'label' => esc_html__('Price Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper .price-line .value',
                'fields_options' =>
				[
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '30'
						]
                    ],
                    'font_weight' => [
                        'default' => 'bold'
                    ]
				]
			]
		);
        $this->add_control(
            'price_line_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
				'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100
                    ],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper .price-line' => 'border-radius: 0 {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}} 0;',
				],
            ]
        );
        $this->add_control(
            'price_section_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => ['top'],
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper .price-line' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' =>
                [
                    'isLinked' => false,
                    'top' => '10'
                ]
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'price_line_bg',
                'selector' => '{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper .price-line',
                'fields_options' =>
                [
                    'background' =>
                    [
                        'default' => 'gradient'
                    ],
                    'color' => 
                    [
                        'default' => '#fe248b'
                    ],
                    'color_b' =>
                    [
                        'default' => '#ff071b'
                    ],
                    'gradient_angle' =>
                    [
                        'default' =>
                        [
                            'unit' => 'deg',
                            'size' => 110
                        ]
                    ]
                ]
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'button_section',
            [
                'label' => esc_html__('Button', 'ahura')
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => esc_html__('Text', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Purchase', 'ahura'),
            ]
        );
        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
				'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50
                    ],
				],
				'default' => [
					'unit' => 'px',
                    'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper .btn-wrapper a' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
            ]
        );
        $this->add_control(
            'button_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => ['top'],
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper .btn-wrapper a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' =>
                [
                    'isLinked' => false,
                    'top' => '20'
                ]
            ]
        );
        $this->add_control(
            'button_text_color',
            [
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'label' => esc_html__('Text Color', 'ahura'),
                'selectors' =>
                [
                    '{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper .btn-wrapper a' => 'color: {{VALUE}}'
                ]
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'button_bg',
                'selector' => '{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper .btn-wrapper a',
                'fields_options' =>
                [
                    'background' =>
                    [
                        'default' => 'gradient'
                    ],
                    'color' => 
                    [
                        'default' => '#fe248b'
                    ],
                    'color_b' =>
                    [
                        'default' => '#ff071b'
                    ],
                    'gradient_angle' =>
                    [
                        'default' =>
                        [
                            'unit' => 'deg',
                            'size' => 110
                        ]
                    ]
                ]
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'box_section',
            [
                'label' => esc_html__('Box', 'ahura')
            ]
        );

        $tags   = get_terms( ['taxonomy' => 'product_tag'] );
		$tag    = [];
        if($tags){
            foreach ( $tags as $tagItem ) {
                if($tagItem){
                    if(!empty($tagItem->term_id) && !empty($tagItem->name)){
                        $tag[$tagItem->term_id] = $tagItem->name;
                    }
                }
            }
        }
		$default = ($tag) ? key($tag) : 0;

		$this->add_control(
			'product_tag_selected',
			[
				'label'         => __('Product tag', 'ahura'),
				'type'          => \Elementor\Controls_Manager::SELECT2,
				'options'       => $tag,
				'label_block'   => true,
				'multiple'      => false,
				'default'       => $default
			]
		);
        
        $this->add_control(
            'box_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
				'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100
                    ],
				],
				'default' => [
					'unit' => 'px',
                    'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Box Shadow', 'ahura' ),
				'selector' => '{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper',
			]
		);

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_bg',
                'selector' => '{{WRAPPER}} .product_pricebox_1 .product_pricebox_box_wrapper',
                'fields_options' =>
                [
                    'background' =>
                    [
                        'default' => 'classic'
                    ],
                    'color' =>
                    [
                        'default' => '#ffffff'
                    ]
                ]
            ]
        );
        
        $this->end_controls_section();
    }
    protected function render_link_attrs($url_data)
	{
		$target = $url_data['is_external'] ? 'target="_blank"' : '';
		$nofollow = $url_data['nofollow'] ? 'rel="nofollow"' : '';
		$cu_attr = $url_data['custom_attributes'] ? $url_data['custom_attributes'] : false;
		$data = 'href="'.$url_data['url'].'" '.$target.' '.$nofollow.' '.$cu_attr;
		echo $data;
	}
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if(!\ahura\app\woocommerce::is_active()){
            return false;
        }

        $post_box = new \WP_Query ( [
			'posts_per_page' => 1,
			'tax_query' => [
                'relation' => 'OR',
                [
                    'taxonomy' => 'product_tag',
                    'field' => 'term_id',
                    'terms' => $settings['product_tag_selected'],
                ],
            ],
		] );
        ?>

        <?php if ( $post_box->have_posts() ) : ?>
            <div class="product_pricebox_1">
                <div class="post_box">
                    <div class="post_box_post row">
                        <?php while ( $post_box->have_posts() ) : $post_box->the_post(); ?>
                        <div class="product_pricebox_box_wrapper">
                            <div class="title">
                                <span><?php echo the_title(); ?></span>
                            </div>
                            <div class="price-line">
                                <span class="value"><?php echo wc_get_product( get_the_ID() )->get_price_html(); ?></span>
                            </div>
                            <div class="price_items">
                                <?php echo the_content(); ?>
                            </div>
                            <div class="btn-wrapper">
                                <a href="<?php echo get_site_url().'?add-to-cart='.get_the_ID(); ?>" class="btn"><?php echo $settings['button_text'];?></a>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                </div>
                <?php wp_reset_postdata(); ?>
                    <?php else:?>
                        <div class="mw_element_error">
                            <?php echo __('Nothing found. Edit the page with Elementor and select a category for this section.','ahura');?>
                        </div>
                <?php endif; ?>
            </div>
        <?php
    }
}
