<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use ahura\app\mw_assets;

defined('ABSPATH') || exit('No Access');

class Elementor_ahura_logo_svg extends \Elementor\Widget_Base
{
    public function __construct($data=[], $args=[])
    {
        parent::__construct($data, $args);
        mw_assets::register_style('logo_svg_css', mw_assets::get_css('elementor.logo_svg'));
    }

    public function get_style_depends()
    {
        $styles = [mw_assets::get_handle_name('logo_svg_css')];
        return $styles;
    }

    function get_name()
    {
        return 'ahura_logo_svg';
    }

    function get_title()
    {
        return esc_html__('SVG Logo', 'ahura');
    }

    function get_icon()
    {
        return 'eicon-logo';
    }

    function get_categories()
    {
        return ['ahurabuilder'];
    }

    public function get_keywords()
    {
        return ['logo_svg', 'logosvg', esc_html__('SVG Logo' , 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'section_image',[
                'label' => __('Image', 'ahura')
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __('Choose Image', 'ahura'),
                'type' => Controls_Manager::MEDIA,
                'media_types' => ['svg'],
                'default' => [
                    'url' => \ahura\app\mw_assets::get_img('ahura-logo', 'svg')
                ]
            ]
        );

        $this->add_control(
            'hide_in_scroll',
            [
                'label' => __('Hide in scroll', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'default' => false,
                'description' => __('This feature is work just in header', 'ahura'),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_image_style',[
                'label' => __('Image', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'width',
            [
                'label' => __('Width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'unit' => '%'
                ],
                'tablet_default' => [
                    'unit' => '%'
                ],
                'mobile_default' => [
                    'unit' => '%'
                ],
                'size_units' => ['%', 'px', 'vw'],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .ahura-logo-element a' => 'width: {{SIZE}}{{UNIT}}'
                ],
            ]
        );

        $this->add_responsive_control(
            'height',
            [
                'label' => __('Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'vw'],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .ahura-logo-element a' => 'height: {{SIZE}}{{UNIT}}'
                ],
            ]
        );

        $this->add_control(
            'svg_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ahura-logo-element svg path' => 'fill: {{VALUE}}',
                ]
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'ahura'),
                        'icon' => 'eicon-text-align-left'
                    ],
                    'center' => [
                        'title' => __('Center', 'ahura'),
                        'icon' => 'eicon-text-align-center'
                    ],
                    'right' => [
                        'title' => __('Right', 'ahura'),
                        'icon' => 'eicon-text-align-right'
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .ahura-logo-element, {{WRAPPER}} .ahura-logo-element a' => 'justify-content: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $site_link = home_url();
        $classes = [];
        $img = isset($settings['image']['url']) && !empty($settings['image']['url']) ? $settings['image']['url'] : null;

        if(empty($img)){
            return false;
        }

        if($settings['hide_in_scroll']){
            $classes[] = 'hide_in_scroll';
        }

        $class_args = implode(' ', $classes);
        ?>
        <div class="ahura-logo-element ahura-svg-logo-element <?php echo $class_args ?>">
            <a href="<?php echo $site_link ?>">
                <?php echo !empty($img) ? file_get_contents($img) : ''; ?>
            </a>
        </div>
        <?php
    }
}
