<?php

namespace ahura\inc\widgets;

// Block direct access to the main plugin file.

use ahura\app\woocommerce;

defined('ABSPATH') or die('No script kiddies please!');

use ahura\app\mw_assets;

class shop_category extends \Elementor\Widget_Base
{
    /**
     * shop_category constructor.
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_style('owl_carousel_css', mw_assets::get_css('owl-carousel'));
        mw_assets::register_script('owl_carousel_js', mw_assets::get_js('owl-carousel-min'));
        mw_assets::register_style('shop_category_css', mw_assets::get_css('elementor.shop_category'));
        mw_assets::register_script('shop_category_js', mw_assets::get_js('elementor.shop_category'));
    }

    public function get_style_depends()
    {
        return [mw_assets::get_handle_name('shop_category_css'), mw_assets::get_handle_name('owl_carousel_css')];
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('owl_carousel_js'), mw_assets::get_handle_name('shop_category_js')];
    }

    public function get_name()
    {
        return 'shopcategory';
    }

    public function get_title()
    {
        return __('Products Category', 'ahura');
    }

    public function get_icon()
    {
        return 'aicon-svg-shop-category';
    }

    public function get_categories()
    {
        return ['ahuraelements'];
    }

    public function get_keywords()
    {
        return ['productscategory', 'products_category', __('Products Category', 'ahura')];
    }

    protected function register_controls()
    {
        if (!woocommerce::is_active()) {
            return false;
        }
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'display_type',
            [
                'label' => esc_html__('Display Type', 'ahura'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'default' => 1,
                'options' => [
                    '1' => esc_html__('Latest Products', 'ahura'),
                    '2' => esc_html__('Discounted products', 'ahura'),
                ]
            ]
        );

        $categories = get_terms(array(
            'taxonomy' => 'product_cat',
            'hide_empty' => false,
        ));
        $cats = array();
        foreach ($categories as $category) {
            $cats[$category->slug] = $category->name;
        }
        $default = key($cats);
        $this->add_control(
            'catsid',
            [
                'label' => __('Categories', 'ahura'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $cats,
                'label_block' => true,
                'multiple' => true,
                'default' => $default
            ]
        );

        $this->add_control(
            'price',
            [
                'label' => __('Show Price', 'ahura'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'yes' => ['title' => __('Yes', 'ahura'), 'icon' => 'fa fa-check-circle'],
                    'no' => ['title' => __('No', 'ahura'), 'icon' => 'fa fa-times-circle']
                ],
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'count',
            [
                'label' => __('Number of posts', 'ahura'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 8
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __('Image', 'ahura'),
                'type' => \Elementor\Controls_Manager::MEDIA
            ]
        );

        $this->add_control(
            'product_order',
            [
                'label' => __('Sort', 'ahura'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'default' => 'DESC',
                'options' => [
                    'ASC' => [
                        'title' => __('Ascending', 'ahura'),
                        'icon' => 'fa fa-arrow-up'
                    ],
                    'DESC' => [
                        'title' => __('Descending', 'ahura'),
                        'icon' => 'fa fa-arrow-down'
                    ],
                ],
                'toggle' => true
            ]
        );


        $this->add_control(
            'direction',
            [
                'label' => __('Image Direction', 'ahura'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'default' => 'DESC',
                'options' => [
                    'left' => [
                        'title' => __('Left', 'ahura'),
                        'icon' => 'fa fa-arrow-left'
                    ],
                    'right' => [
                        'title' => __('Right', 'ahura'),
                        'icon' => 'fa fa-arrow-right'
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .productcategorybox section' => 'float: {{VALUE}}',
                ],
                'toggle' => true
            ]
        );

        $this->add_control(
            'stock_status',
            [
                'label' => __('Show product stock status', 'ahura'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'yes' => ['title' => __('Yes', 'ahura'), 'icon' => 'fa fa-check-circle'],
                    'no' => ['title' => __('No', 'ahura'), 'icon' => 'fa fa-times-circle']
                ],
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'outofstock_text',
            [
                'label' => __('Out of stock text', 'ahura'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('out of stock', 'ahura'),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content_style_section',
            [
                'label' => __('Box', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color',
            [
                'label' => __('Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#66bb6a'
            ]
        );

        $this->add_control(
            'outofstock_background_color',
            [
                'label' => esc_html__('Of of stock background color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'red',
                'selectors' => [
                    '{{WRAPPER}} .out-of-stock' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'outofstock_color',
            [
                'label' => esc_html__('Of of stock color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'white',
                'selectors' => [
                    '{{WRAPPER}} .out-of-stock' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
                'label' => esc_html__( 'Out of Stock typography', 'ahura' ),
				'name' => 'outofstock_text_typography',
				'selector' => '{{WRAPPER}} .out-of-stock',
			]
		);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if (class_exists('WooCommerce')) {
            $field_is_term = (is_array($settings['catsid']) && isset($settings['catsid'][0]) && is_numeric($settings['catsid'][0])) || is_int($settings['catsid']);
            $type = $settings['display_type'];
            $arg = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => $settings['count'],
                'tax_query' => array(
                    array(
                        'taxonomy' => 'product_cat',
                        'field' => $field_is_term ? 'term_id' : 'slug',
                        'terms' => $settings['catsid'],
                    )
                ),
                'order' => $settings['product_order']
            );
            if ($type == 2) {
                $arg['meta_query'] = array(
                    'relation' => 'OR',
                    array(
                        'key' => '_sale_price',
                        'value' => 0,
                        'compare' => '>',
                        'type' => 'numeric'
                    ),
                    array(
                        'key' => '_min_variation_sale_price',
                        'value' => 0,
                        'compare' => '>',
                        'type' => 'numeric'
                    )
                );
            }
            $wc_query = new \WP_Query($arg);
            $first_cat_id = is_array($settings['catsid']) && isset($settings['catsid'][0]) ? $settings['catsid'][0] : $settings['catsid'];
            if ($wc_query->have_posts()) : ?>
                <div class="productcategorybox">
                    <section style="background-color:<?php echo $settings['color']; ?>" class="prcatboxtitle">
                        <img src="<?php echo $settings['image']['url']; ?>"/>
                        <h2>
                            <?php 
                            $term = get_term_by($field_is_term ? 'id' : 'slug', $first_cat_id, 'product_cat');
                            if($term){
                                echo $term->name;
                            }
                            ?>
                        </h2>
                        <?php if($term): ?>
                            <a href="<?php echo get_term_link($term); ?>"><?php _e('All Products', 'ahura'); ?></a>
                        <?php endif; ?>
                        <div class="clear"></div>
                    </section>
                    <?php if (is_admin()): ?>
                        <div class="preload_widget_section">
                            <h3><?php _e('Slider is here!', 'ahura'); ?></h3>
                            <small><?php _e('To see slider please view page.', 'ahura'); ?></small>
                        </div>
                    <?php else: ?>
                        <div class="owl-carousel owl-shop-category w-80">
                            <?php
                            while ($wc_query->have_posts()): $wc_query->the_post();
                                $product = wc_get_product(get_the_ID());
                            ?>
                                <div>
                                    <a class="fimage" href="<?php the_permalink(); ?>"><?php the_post_thumbnail('woocommerce_thumbnail'); ?></a>
                                    <a href="<?php the_permalink(); ?>">
                                        <h3><?php echo wp_trim_words(get_the_title(), 8, '...'); ?></h3></a>
                                    <?php if ($settings['price'] == 'yes') : ?>
                                        <div class="mwprprice">
                                            <?php
                                            $price = woocommerce_template_single_price();
                                            echo $price;
                                            ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php
                                    if (($settings['stock_status'] == 'yes' && $product->get_stock_status() == "outofstock")) {
                                        echo '<p class="out-of-stock">' . $settings['outofstock_text'] . '</p>';
                                    }
                                    ?>
                                </div>
                            <?php endwhile; ?>
                        </div>
                    <?php endif; ?>
                </div>
                <?php wp_reset_postdata(); ?>
            <?php else: ?>
                <div class="mw_element_error">
                    <?php echo __('Nothing found. Edit the page with Elementor and select a category for this section.', 'ahura'); ?>
                </div>
            <?php endif; ?>
            <div class="clear"></div>
            <?php
        } elseif (is_admin()) {
            ?>
            <div class="mw_element_error"><?php _e('To use this element you must install woocommerce plugin.', 'ahura'); ?></div>
            <?php
        }
    }

}
