<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.

use ahura\app\mw_assets;
use ahura\app\woocommerce;

defined('ABSPATH') or die('No script kiddies please!');


class shop_category1 extends \Elementor\Widget_Base
{

	public function get_name()
	{
		return 'shopcategory1';
	}

	public function get_title()
	{
		return __('Products Category 1', 'ahura');
	}

	public function get_icon()
	{
		return 'aicon-svg-shop-category-1';
	}

	public function get_categories()
	{
		return ['ahuraelements'];
	}
	function get_keywords()
	{
		return ['shop_category1', 'shopcategory1', 'productscategory1', 'products_category_1', esc_html__( 'Products Category 1' , 'ahura')];
	}
	function __construct($data=[], $args=null)
	{
		parent::__construct($data, $args);
		$shop_category1_css = mw_assets::get_css('elementor.shop_category1');
		mw_assets::register_style('shop_category1', $shop_category1_css);
	}
	function get_style_depends()
	{
		return [mw_assets::get_handle_name('shop_category1')];
	}

	protected function register_controls()
	{
		if (!woocommerce::is_active()) {
			return false;
		}
		$this->start_controls_section(
			'content_section',
			[
				'label' => __('Content', 'ahura'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$categories = get_terms(array(
			'taxonomy' => 'product_cat',
			'hide_empty' => false,
		));
		$cats       = array();
		foreach ($categories as $category) {
			$cats[$category->slug] = $category->name;
		}
		$default = key($cats);
		$this->add_control(
			'catsid',
			[
				'label'    => __('Categories', 'ahura'),
				'type'     => \Elementor\Controls_Manager::SELECT2,
				'options'  => $cats,
				'label_block' => true,
				'multiple' => false,
				'default' => $default
			]
		);

		$this->add_control(
			'price',
			[
				'label'   => __('Show Price', 'ahura'),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => ['title' => __('Yes', 'ahura'), 'icon' => 'fa fa-check-circle'],
					'no'  => ['title' => __('No', 'ahura'), 'icon' => 'fa fa-times-circle']
				],
				'default' => 'yes'
			]
		);

		$this->add_control(
			'count',
			[
				'label'      => __('Number of posts', 'ahura'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'default'    => 8
			]
		);

		$this->add_control(
			'product_order',
			[
				'label' => __('Sort', 'ahura'),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'default' => 'DESC',
				'options' => [
					'ASC' => [
						'title' => __('Ascending', 'ahura'),
						'icon' => 'fa fa-arrow-up'
					],
					'DESC' => [
						'title' => __('Descending', 'ahura'),
						'icon' => 'fa fa-arrow-down'
					],
				],
				'toggle' => true
			]
		);

		$this->add_control(
			'border_color',
			[
				'label'      => __('Border Color', 'ahura'),
				'type'       => \Elementor\Controls_Manager::COLOR,
				'default'    => '#444',
				'selectors' => [
					'{{WRAPPER}} .mw_shop_cat_title_box b' => 'background-color: {{VALUE}};'
				],
			]
		);

		$this->add_control(
			'stock_status',
			[
				'label'   => __( 'Show product stock status', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'fa fa-check-circle' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'fa fa-times-circle' ]
				],
				'default' => 'yes'
			]
		);

		$this->add_control(
			'outofstock_text',
			[
				'label' => __( 'Out of stock text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'out of stock', 'ahura' ),
			]
		);

		$this->add_control(
			'outofstock_background_color',
			[
				'label' => esc_html__( 'Of of stock background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => 'red',
				'selectors' => [
					'{{WRAPPER}} .out-of-stock' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'outofstock_color',
			[
				'label' => esc_html__( 'Of of stock color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => 'white',
				'selectors' => [
					'{{WRAPPER}} .out-of-stock' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'label' => esc_html__( 'Out of Stock typography', 'ahura' ),
				'name' => 'outofstock_text_typography',
				'selector' => '{{WRAPPER}} .out-of-stock',
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();

		if (class_exists('WooCommerce')) {
			$field_is_term = (is_array($settings['catsid']) && is_numeric($settings['catsid'][0])) || is_int($settings['catsid']);
			$wc_query = new \WP_Query(array(
				'post_type'      => 'product',
				'post_status'    => 'publish',
				'posts_per_page' => $settings['count'],
				'tax_query' => array(
					array(
						'taxonomy' => 'product_cat',
						'field' => $field_is_term ? 'term_id' : 'slug',
						'terms' => $settings['catsid'],
					)
				),
				'order'         =>  $settings['product_order']
			));
			$first_cat_id = is_array($settings['catsid']) ? $settings['catsid'][0] : $settings['catsid'];
			if ($wc_query->have_posts()) : ?>
				<div class="mw_shop_cat">
					<div class="mw_shop_cat_title_box">
						<b></b>
						<h2><?php $term = get_term_by( $field_is_term ? 'id' : 'slug', $first_cat_id, 'product_cat' );echo $term->name; ?></h2>
						<b></b>
					</div>
					<?php while ($wc_query->have_posts()) : $wc_query->the_post(); ?>
						<a href="<?php the_permalink(); ?>" class="mw_shop_cat_item">
							<?php if (get_post_meta(get_the_ID(), '_sale_price', true) != null) : ?>
								<div class="mw_shop_cat_item_off_over">
									<i class="fa fa-star"></i>
								</div>
							<?php endif; ?>
							<div class="mw_shop_cat_item_pic">
								<?php the_post_thumbnail('woocommerce_thumbnail'); ?>
							</div>
							<div class="mw_shop_cat_item_data">
								<h3><?php the_title(); ?></h3>
								<?php if ($settings['price'] == 'yes') : ?>
									<div class="mw_shop_cat_item_price">
										<?php
										$price = woocommerce_template_single_price(); 
										echo '<span class="mw_shop_cat_item_price">'.$price.'</span>';
										?>
									</div>
								<?php endif;
								 if ( ( $settings['stock_status'] == 'yes' && wc_get_product( get_the_ID() ) -> get_stock_status() == "outofstock" ) ) {
									echo '<p class="out-of-stock">'.$settings['outofstock_text'].'</p>';
								 }
								?>
							</div>
						</a>

					<?php endwhile; ?>

				</div>
				<?php wp_reset_postdata(); ?>
				<?php else:?>
					<div class="mw_element_error">
						<?php echo __('Nothing found. Edit the page with Elementor and select a category for this section.','ahura');?>
					</div>
			<?php endif; ?>
			<div class="clear"></div>
<?php
		}
	}
}
