window.canAutoHide = false;
window.lastScrollTop = 0;
window.sticky_header = true;
var body = jQuery('body'),
	headerWrap = jQuery('#ahura-header-main-wrap'),
	topbar = jQuery('.topbar'),
	topbar_el = document.querySelector('.topbar'),
	topbarHeight = topbar.outerHeight(),
	stickyElToggle, scrollTo;

jQuery(document).ready(function($){
    headerWrap.css('height', `${topbarHeight}px`);

    if(sticky_header_data.scrolling_top_show){
		// wheel event : Work in desktop
        $(document).on('wheel', function(e) {
            if(document.body.scrollTop > topbar.innerHeight() || document.documentElement.scrollTop > topbar.innerHeight()){
                if (e.deltaY < 0){
					topbar_el.classList.remove('header-sticky-hide');
					topbar_el.classList.add('header-sticky-show');
                } else if(e.deltaY > 0){
					topbar_el.classList.remove('header-sticky-show');
					topbar_el.classList.add('header-sticky-hide');
                }
            } else {
				topbar_el.classList.remove('header-sticky-show');
				topbar_el.classList.remove('header-sticky-hide');
            }
        });
    }
	
    window.addEventListener('scroll', function(e) {
		window.canAutoHide = true;
        e.stopPropagation();
        headerWrap.css('height', `${topbarHeight}px`);
        stickyElToggle = $('.scrolled-topbar:not(.header-mode-2) .top-menu, .scrolled-topbar .cats-list .cats-list-title:not(.in_custom_header), .scrolled-topbar .cats-list ul.menu:not(.in_custom_header ul.menu)');
        if(document.body.scrollTop > topbar.innerHeight() || document.documentElement.scrollTop > topbar.innerHeight()){
            topbar.addClass('scrolled-topbar');
            topbar.find('.show-in-sticky').slideDown();
            topbar.find('.hide-in-sticky').slideUp();
            if(topbar.find('.header-menu-sticky').length > 0){
                topbar.find('.topmenu-wrap').hide();
                topbar.find('.header-menu-sticky').show();
            }
            stickyElToggle.slideUp();
            if(sticky_header_data.scrolling_top_show){
                topbar.addClass('header-sticky-hide');
            }
        } else {
            stickyElToggle.slideDown();
            topbar.removeClass('scrolled-topbar');
            if(topbar.find('.header-menu-sticky').length > 0){
                topbar.find('.topmenu-wrap').show();
                topbar.find('.header-menu-sticky').hide();
            }
            topbar.find('.hide-in-sticky').slideDown();
            topbar.find('.show-in-sticky').slideUp();
            if(sticky_header_data.scrolling_top_show){
                topbar.removeClass('header-sticky-hide header-sticky-show');
            }
        }
    });
});

function ahuraHeaderAutoHide() {
	var scrollTop = jQuery(window).scrollTop();

	// Header scrolling top show / Work in mobile
	if (jQuery('.ahura-main-header').hasClass('scrolled-topbar')) {
		if (scrollTop > window.lastScrollTop + 20 && jQuery('.ahura-main-header').hasClass('header-sticky-show')) {
			topbar_el.classList.remove('header-sticky-show');
			topbar_el.classList.add('header-sticky-hide');
		} else if (scrollTop < window.lastScrollTop - 40 && !jQuery('.ahura-main-header').hasClass('header-sticky-show')) {
			topbar_el.classList.remove('header-sticky-hide');
			topbar_el.classList.add('header-sticky-show');
		}
	}

	window.lastScrollTop = scrollTop;
}

if(sticky_header_data.scrolling_top_show){
	setInterval(function () {
		if (window.canAutoHide) {
			ahuraHeaderAutoHide();
			window.canAutoHide = false;
		}
	}, 150);
}