<?php 
$show_mode_switcher = \ahura\app\mw_options::get_mod_show_theme_mode_switcher();
$mode_switcher_titles = \ahura\app\mw_options::get_mod_show_theme_mode_switcher_titles();
if(\ahura\app\mw_options::get_mod_is_active_dark_theme() && $show_mode_switcher): ?>
    <div class="theme-mode-switcher hide-in-sticky <?php echo !$mode_switcher_titles ? 'without-titles' : '' ?>">
        <input type="radio" id="ahura-light-theme" name="theme-mode-switch" <?php echo ahura_get_current_theme_mode(true, 'light') ? 'checked' : '' ?>/>
        <label for="ahura-light-theme">
            <span>
                <i class="fa fa-sun"></i>
                <em>
                    <?php
                    if($mode_switcher_titles){
                        echo esc_html__('Light', 'ahura');
                    }
                    ?>
                </em>
            </span>
        </label>
        <input type="radio" id="ahura-dark-theme" name="theme-mode-switch" <?php echo ahura_get_current_theme_mode(true, 'dark') ? 'checked' : '' ?>/>
        <label for="ahura-dark-theme">
            <span>
                <i class="fa fa-moon"></i>
                <em>
                    <?php
                    if($mode_switcher_titles){
                        echo esc_html__('Dark', 'ahura');
                    }
                    ?>
                </em>
            </span>
        </label>
        <input type="radio" id="ahura-black-theme" name="theme-mode-switch" <?php echo ahura_get_current_theme_mode(true, 'black') ? 'checked' : '' ?>/>
        <label for="ahura-black-theme">
            <span>
                <i class="fa fa-star"></i>
                <em>
                    <?php
                    if($mode_switcher_titles){
                        echo esc_html__('Black', 'ahura');
                    }
                    ?>
                </em>
            </span>
        </label>
        <span class="slider"></span>
    </div>
<?php endif;