<?php


// Load the main stylesheet
add_action( 'wp_enqueue_scripts', 'rooten_theme_style' );
function rooten_theme_style() {
	$theme = wp_get_theme();
	wp_enqueue_style( 'rooten-theme-style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_script( 'rooten-theme-custom-script', get_stylesheet_directory_uri() . '/script.js', ['jquery'], $theme->get('Version'), true);
}


// Load child theme's textdomain.
add_action( 'after_setup_theme', 'rooten_child_textdomain' );
function rooten_child_textdomain(){
   load_child_theme_textdomain( 'rooten', get_stylesheet_directory().'/languages' );
}

add_action('wp_head', function(){
    $is_account = class_exists('WooCommerce') ? is_account_page() : false;
    if(!wp_doing_ajax() && !is_user_logged_in() && !is_front_page() && !$is_account){
        wp_redirect(site_url());
    }
});


// Example code loading JS in footer. Uncomment to use.
 

/* ====== REMOVE COMMENT

add_action('wp_footer', 'rootenChildFooterScript' );
function rootenChildFooterScript(){

	echo '
	<script type="text/javascript">

	// Your JS code here

	</script>';

}
 ====== REMOVE COMMENT */

/* ======================================================== */